/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.instrument;

import com.liferay.whip.agent.InstrumentationAgent;
import com.liferay.whip.coveragedata.ProjectData;
import com.liferay.whip.coveragedata.ProjectDataUtil;
import com.liferay.whip.instrument.ContextAwareClassWriter;
import com.liferay.whip.instrument.WhipClassVisitor;
import com.liferay.whip.util.ReflectionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class WhipClassFileTransformer
implements ClassFileTransformer {
    private static final File _dumpDir;
    private final Pattern[] _excludePatterns;
    private final Pattern[] _includePatterns;

    public WhipClassFileTransformer(String[] includes, String[] excludes) {
        Pattern pattern;
        int i;
        this._includePatterns = new Pattern[includes.length];
        for (i = 0; i < includes.length; ++i) {
            this._includePatterns[i] = pattern = Pattern.compile(includes[i]);
        }
        this._excludePatterns = new Pattern[excludes.length];
        for (i = 0; i < excludes.length; ++i) {
            this._excludePatterns[i] = pattern = Pattern.compile(excludes[i]);
        }
    }

    public boolean matches(String className) {
        Matcher matcher;
        if (className == null) {
            return false;
        }
        if (this._excludePatterns.length != 0) {
            for (Pattern excludePattern : this._excludePatterns) {
                matcher = excludePattern.matcher(className);
                if (!matcher.matches()) continue;
                return false;
            }
        }
        if (this._includePatterns.length != 0) {
            for (Pattern includePattern : this._includePatterns) {
                matcher = includePattern.matcher(className);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> refinedClass, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        block5: {
            try {
                if (!this.matches(className)) break block5;
                InstrumentationAgent.recordInstrumentation(classLoader, className, classfileBuffer);
                ProjectData projectData = ProjectDataUtil.getProjectData();
                ContextAwareClassWriter classWriter = new ContextAwareClassWriter(2);
                String name = className.replace('/', '.');
                WhipClassVisitor classVisitor = new WhipClassVisitor(projectData.getOrCreateClassData(name), (ClassVisitor)classWriter);
                ClassReader classReader = new ClassReader(classfileBuffer);
                ProjectData projectData2 = projectData;
                synchronized (projectData2) {
                    classReader.accept((ClassVisitor)classVisitor, 0);
                }
                byte[] data = classWriter.toByteArray();
                this.dumpInstrumentedClass(classLoader, className, data);
                return data;
            }
            catch (IOException ioException) {
                ReflectionUtil.throwException(ioException);
            }
        }
        return null;
    }

    protected void dumpInstrumentedClass(ClassLoader classLoader, String className, byte[] data) throws IOException {
        if (!Boolean.getBoolean("whip.instrument.dump")) {
            return;
        }
        File logFile = new File(_dumpDir, "instrument.log");
        File dumpDir = _dumpDir;
        int index = className.lastIndexOf(47);
        if (index != -1) {
            dumpDir = new File(dumpDir + "/" + classLoader.toString(), className.substring(0, index));
            className = className.substring(index + 1);
        }
        dumpDir.mkdirs();
        File classFile = new File(dumpDir, className + ".class");
        try (FileOutputStream outputStream = new FileOutputStream(classFile);){
            ((OutputStream)outputStream).write(data);
        }
        var9_9 = null;
        try (FileWriter fileWriter = new FileWriter(logFile, true);){
            fileWriter.write("Instrumented " + className + " from " + classLoader + " and dumped to " + classFile.getAbsolutePath() + "\n");
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    static {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMXBean.getName();
        int index = name.indexOf(64);
        String processId = null;
        processId = index == -1 ? String.valueOf(System.currentTimeMillis()) : name.substring(0, index);
        _dumpDir = new File(System.getProperty("java.io.tmpdir"), "whip-dump/" + processId);
    }
}

