/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.instrument;

import com.liferay.whip.coveragedata.ClassData;
import com.liferay.whip.instrument.OutlineMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class WhipClassVisitor
extends ClassVisitor {
    private final ClassData _classData;
    private boolean _instrument;

    public WhipClassVisitor(ClassData classData, ClassVisitor classVisitor) {
        super(327680, classVisitor);
        this._classData = classData;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1200) == 0) {
            this._instrument = true;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        if (this._instrument && this._classData.getNumberOfValidLines() == 0) {
            System.err.println("No line number information found for class " + this._classData.getName() + ". Please recompile with debug info.");
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (!this._instrument || methodVisitor == null || (access & 0x40) != 0) {
            return methodVisitor;
        }
        return new OutlineMethodVisitor(this._classData, methodVisitor, access, name, desc, signature, exceptions);
    }
}

