/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiPage;

public class PageVersionComparator
extends OrderByComparator<WikiPage> {
    public static final String ORDER_BY_ASC = "WikiPage.version ASC";
    public static final String ORDER_BY_DESC = "WikiPage.version DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"version"};
    private static final PageVersionComparator _INSTANCE_ASCENDING = new PageVersionComparator(true);
    private static final PageVersionComparator _INSTANCE_DESCENDING = new PageVersionComparator(false);
    private final boolean _ascending;

    public static PageVersionComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    public int compare(WikiPage page1, WikiPage page2) {
        int value = 0;
        if (page1.getVersion() < page2.getVersion()) {
            value = -1;
        } else if (page1.getVersion() > page2.getVersion()) {
            value = 1;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private PageVersionComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

