/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine.html.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.BaseWikiEngine;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.exception.NoSuchNodeException;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiEngine.class})
public class HtmlEngine
extends BaseWikiEngine {
    private static final Log _log = LogFactoryUtil.getLog(HtmlEngine.class);
    private String _friendlyURLMapping;
    private Router _router;
    @Reference(target="(osgi.web.symbolicname=com.liferay.wiki.engine.input.editor.common)")
    private ServletContext _servletContext;
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private WikiNodeLocalService _wikiNodeLocalService;

    public String getEditorName() {
        return this._wikiGroupServiceConfiguration.getHTMLEditor();
    }

    public String getFormat() {
        return "html";
    }

    public String getHelpPageTitle(HttpServletRequest httpServletRequest) {
        return null;
    }

    public String getHelpURL() {
        return null;
    }

    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        try {
            return this._getOutgoingLinks(page);
        }
        catch (PortalException portalException) {
            throw new PageContentException((Throwable)portalException);
        }
    }

    public String getToolbarSet() {
        return null;
    }

    protected ServletContext getEditPageServletContext() {
        return this._servletContext;
    }

    protected ServletContext getHelpPageServletContext() {
        return null;
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
    }

    @Reference(target="(javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet)", unbind="-")
    protected void setFriendlyURLMapper(FriendlyURLMapper friendlyURLMapper) {
        this._friendlyURLMapping = "/-/" + friendlyURLMapper.getMapping();
        this._router = friendlyURLMapper.getRouter();
    }

    @Reference
    protected void setWikiGroupServiceConfiguration(WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiGroupServiceConfiguration = wikiGroupServiceConfiguration;
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }

    protected void unsetWikiGroupServiceConfiguration(WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiGroupServiceConfiguration = null;
    }

    private Map<String, Boolean> _getOutgoingLinks(WikiPage page) throws PortalException {
        if (Validator.isNull((String)page.getContent())) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> links = new HashMap<String, Boolean>();
        Source source = new Source((CharSequence)page.getContent());
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            HashMap routeParameters;
            int pos;
            String href = startTag.getAttributeValue("href");
            if (Validator.isNull((String)href) || (pos = href.lastIndexOf(this._friendlyURLMapping)) == -1) continue;
            String friendlyURL = href.substring(pos + this._friendlyURLMapping.length());
            if (friendlyURL.endsWith("/")) {
                friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
            }
            if (!this._router.urlToParameters(friendlyURL, routeParameters = new HashMap())) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No route could be found to match URL " + friendlyURL));
                continue;
            }
            String title = (String)routeParameters.get("title");
            String nodeName = (String)routeParameters.get("nodeName");
            if (Validator.isNull((String)title) || Validator.isNull((String)nodeName)) continue;
            try {
                this._wikiNodeLocalService.getNode(page.getGroupId(), nodeName);
                links.put(StringUtil.toLowerCase((String)title), Boolean.TRUE);
            }
            catch (NoSuchNodeException noSuchNodeException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)noSuchNodeException);
            }
        }
        return links;
    }
}

