/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wiki.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the WikiPage service. Represents a row in the &quot;WikiPage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>WikiPageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WikiPageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WikiPageImpl
 * @generated
 */
@JSON(strict = true)
public class WikiPageModelImpl
	extends BaseModelImpl<WikiPage> implements WikiPageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a wiki page model instance should use the <code>WikiPage</code> interface instead.
	 */
	public static final String TABLE_NAME = "WikiPage";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"pageId", Types.BIGINT}, {"resourcePrimKey", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"externalReferenceCode", Types.VARCHAR}, {"nodeId", Types.BIGINT},
		{"title", Types.VARCHAR}, {"version", Types.DOUBLE},
		{"minorEdit", Types.BOOLEAN}, {"content", Types.CLOB},
		{"summary", Types.VARCHAR}, {"format", Types.VARCHAR},
		{"head", Types.BOOLEAN}, {"parentTitle", Types.VARCHAR},
		{"redirectTitle", Types.VARCHAR}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resourcePrimKey", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("nodeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("minorEdit", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("summary", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("format", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("head", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("parentTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("redirectTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table WikiPage (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,pageId LONG not null primary key,resourcePrimKey LONG,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,externalReferenceCode VARCHAR(75) null,nodeId LONG,title VARCHAR(255) null,version DOUBLE,minorEdit BOOLEAN,content TEXT null,summary STRING null,format VARCHAR(75) null,head BOOLEAN,parentTitle VARCHAR(255) null,redirectTitle VARCHAR(255) null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table WikiPage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY wikiPage.nodeId ASC, wikiPage.title ASC, wikiPage.version DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY WikiPage.nodeId ASC, WikiPage.title ASC, WikiPage.version DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long FORMAT_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long HEAD_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NODEID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTTITLE_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REDIRECTTITLE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long RESOURCEPRIMKEY_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TITLE_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public WikiPageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _pageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _pageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return WikiPage.class;
	}

	@Override
	public String getModelClassName() {
		return WikiPage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((WikiPage)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<WikiPage, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<WikiPage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(WikiPage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<WikiPage, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<WikiPage, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<WikiPage, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<WikiPage, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<WikiPage, Object>>();
		Map<String, BiConsumer<WikiPage, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<WikiPage, ?>>();

		attributeGetterFunctions.put("mvccVersion", WikiPage::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<WikiPage, Long>)WikiPage::setMvccVersion);
		attributeGetterFunctions.put("uuid", WikiPage::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<WikiPage, String>)WikiPage::setUuid);
		attributeGetterFunctions.put("pageId", WikiPage::getPageId);
		attributeSetterBiConsumers.put(
			"pageId", (BiConsumer<WikiPage, Long>)WikiPage::setPageId);
		attributeGetterFunctions.put(
			"resourcePrimKey", WikiPage::getResourcePrimKey);
		attributeSetterBiConsumers.put(
			"resourcePrimKey",
			(BiConsumer<WikiPage, Long>)WikiPage::setResourcePrimKey);
		attributeGetterFunctions.put("groupId", WikiPage::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<WikiPage, Long>)WikiPage::setGroupId);
		attributeGetterFunctions.put("companyId", WikiPage::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<WikiPage, Long>)WikiPage::setCompanyId);
		attributeGetterFunctions.put("userId", WikiPage::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<WikiPage, Long>)WikiPage::setUserId);
		attributeGetterFunctions.put("userName", WikiPage::getUserName);
		attributeSetterBiConsumers.put(
			"userName", (BiConsumer<WikiPage, String>)WikiPage::setUserName);
		attributeGetterFunctions.put("createDate", WikiPage::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<WikiPage, Date>)WikiPage::setCreateDate);
		attributeGetterFunctions.put("modifiedDate", WikiPage::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<WikiPage, Date>)WikiPage::setModifiedDate);
		attributeGetterFunctions.put(
			"externalReferenceCode", WikiPage::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<WikiPage, String>)WikiPage::setExternalReferenceCode);
		attributeGetterFunctions.put("nodeId", WikiPage::getNodeId);
		attributeSetterBiConsumers.put(
			"nodeId", (BiConsumer<WikiPage, Long>)WikiPage::setNodeId);
		attributeGetterFunctions.put("title", WikiPage::getTitle);
		attributeSetterBiConsumers.put(
			"title", (BiConsumer<WikiPage, String>)WikiPage::setTitle);
		attributeGetterFunctions.put("version", WikiPage::getVersion);
		attributeSetterBiConsumers.put(
			"version", (BiConsumer<WikiPage, Double>)WikiPage::setVersion);
		attributeGetterFunctions.put("minorEdit", WikiPage::getMinorEdit);
		attributeSetterBiConsumers.put(
			"minorEdit", (BiConsumer<WikiPage, Boolean>)WikiPage::setMinorEdit);
		attributeGetterFunctions.put("content", WikiPage::getContent);
		attributeSetterBiConsumers.put(
			"content", (BiConsumer<WikiPage, String>)WikiPage::setContent);
		attributeGetterFunctions.put("summary", WikiPage::getSummary);
		attributeSetterBiConsumers.put(
			"summary", (BiConsumer<WikiPage, String>)WikiPage::setSummary);
		attributeGetterFunctions.put("format", WikiPage::getFormat);
		attributeSetterBiConsumers.put(
			"format", (BiConsumer<WikiPage, String>)WikiPage::setFormat);
		attributeGetterFunctions.put("head", WikiPage::getHead);
		attributeSetterBiConsumers.put(
			"head", (BiConsumer<WikiPage, Boolean>)WikiPage::setHead);
		attributeGetterFunctions.put("parentTitle", WikiPage::getParentTitle);
		attributeSetterBiConsumers.put(
			"parentTitle",
			(BiConsumer<WikiPage, String>)WikiPage::setParentTitle);
		attributeGetterFunctions.put(
			"redirectTitle", WikiPage::getRedirectTitle);
		attributeSetterBiConsumers.put(
			"redirectTitle",
			(BiConsumer<WikiPage, String>)WikiPage::setRedirectTitle);
		attributeGetterFunctions.put(
			"lastPublishDate", WikiPage::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<WikiPage, Date>)WikiPage::setLastPublishDate);
		attributeGetterFunctions.put("status", WikiPage::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<WikiPage, Integer>)WikiPage::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", WikiPage::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<WikiPage, Long>)WikiPage::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", WikiPage::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<WikiPage, String>)WikiPage::setStatusByUserName);
		attributeGetterFunctions.put("statusDate", WikiPage::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate", (BiConsumer<WikiPage, Date>)WikiPage::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getPageId() {
		return _pageId;
	}

	@Override
	public void setPageId(long pageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_pageId = pageId;
	}

	@JSON
	@Override
	public long getResourcePrimKey() {
		return _resourcePrimKey;
	}

	@Override
	public void setResourcePrimKey(long resourcePrimKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_resourcePrimKey = resourcePrimKey;
	}

	@Override
	public boolean isResourceMain() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalResourcePrimKey() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getNodeId() {
		return _nodeId;
	}

	@Override
	public void setNodeId(long nodeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_nodeId = nodeId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalNodeId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("nodeId"));
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTitle() {
		return getColumnOriginalValue("title");
	}

	@JSON
	@Override
	public double getVersion() {
		return _version;
	}

	@Override
	public void setVersion(double version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public double getOriginalVersion() {
		return GetterUtil.getDouble(
			this.<Double>getColumnOriginalValue("version"));
	}

	@JSON
	@Override
	public boolean getMinorEdit() {
		return _minorEdit;
	}

	@JSON
	@Override
	public boolean isMinorEdit() {
		return _minorEdit;
	}

	@Override
	public void setMinorEdit(boolean minorEdit) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minorEdit = minorEdit;
	}

	@JSON
	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_content = content;
	}

	@JSON
	@Override
	public String getSummary() {
		if (_summary == null) {
			return "";
		}
		else {
			return _summary;
		}
	}

	@Override
	public void setSummary(String summary) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_summary = summary;
	}

	@JSON
	@Override
	public String getFormat() {
		if (_format == null) {
			return "";
		}
		else {
			return _format;
		}
	}

	@Override
	public void setFormat(String format) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_format = format;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalFormat() {
		return getColumnOriginalValue("format");
	}

	@JSON
	@Override
	public boolean getHead() {
		return _head;
	}

	@JSON
	@Override
	public boolean isHead() {
		return _head;
	}

	@Override
	public void setHead(boolean head) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_head = head;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalHead() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("head"));
	}

	@JSON
	@Override
	public String getParentTitle() {
		if (_parentTitle == null) {
			return "";
		}
		else {
			return _parentTitle;
		}
	}

	@Override
	public void setParentTitle(String parentTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentTitle = parentTitle;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalParentTitle() {
		return getColumnOriginalValue("parentTitle");
	}

	@JSON
	@Override
	public String getRedirectTitle() {
		if (_redirectTitle == null) {
			return "";
		}
		else {
			return _redirectTitle;
		}
	}

	@Override
	public void setRedirectTitle(String redirectTitle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_redirectTitle = redirectTitle;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalRedirectTitle() {
		return getColumnOriginalValue("redirectTitle");
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public long getContainerModelId() {
		return getResourcePrimKey();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_resourcePrimKey = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getTitle());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(WikiPage.class.getName()));
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
				getTrashHandler(getModelClassName());

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
				getTrashHandler(getModelClassName());

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), WikiPage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public WikiPage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, WikiPage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		WikiPageImpl wikiPageImpl = new WikiPageImpl();

		wikiPageImpl.setMvccVersion(getMvccVersion());
		wikiPageImpl.setUuid(getUuid());
		wikiPageImpl.setPageId(getPageId());
		wikiPageImpl.setResourcePrimKey(getResourcePrimKey());
		wikiPageImpl.setGroupId(getGroupId());
		wikiPageImpl.setCompanyId(getCompanyId());
		wikiPageImpl.setUserId(getUserId());
		wikiPageImpl.setUserName(getUserName());
		wikiPageImpl.setCreateDate(getCreateDate());
		wikiPageImpl.setModifiedDate(getModifiedDate());
		wikiPageImpl.setExternalReferenceCode(getExternalReferenceCode());
		wikiPageImpl.setNodeId(getNodeId());
		wikiPageImpl.setTitle(getTitle());
		wikiPageImpl.setVersion(getVersion());
		wikiPageImpl.setMinorEdit(isMinorEdit());
		wikiPageImpl.setContent(getContent());
		wikiPageImpl.setSummary(getSummary());
		wikiPageImpl.setFormat(getFormat());
		wikiPageImpl.setHead(isHead());
		wikiPageImpl.setParentTitle(getParentTitle());
		wikiPageImpl.setRedirectTitle(getRedirectTitle());
		wikiPageImpl.setLastPublishDate(getLastPublishDate());
		wikiPageImpl.setStatus(getStatus());
		wikiPageImpl.setStatusByUserId(getStatusByUserId());
		wikiPageImpl.setStatusByUserName(getStatusByUserName());
		wikiPageImpl.setStatusDate(getStatusDate());

		wikiPageImpl.resetOriginalValues();

		return wikiPageImpl;
	}

	@Override
	public WikiPage cloneWithOriginalValues() {
		WikiPageImpl wikiPageImpl = new WikiPageImpl();

		wikiPageImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		wikiPageImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		wikiPageImpl.setPageId(this.<Long>getColumnOriginalValue("pageId"));
		wikiPageImpl.setResourcePrimKey(
			this.<Long>getColumnOriginalValue("resourcePrimKey"));
		wikiPageImpl.setGroupId(this.<Long>getColumnOriginalValue("groupId"));
		wikiPageImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		wikiPageImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		wikiPageImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		wikiPageImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		wikiPageImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		wikiPageImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		wikiPageImpl.setNodeId(this.<Long>getColumnOriginalValue("nodeId"));
		wikiPageImpl.setTitle(this.<String>getColumnOriginalValue("title"));
		wikiPageImpl.setVersion(this.<Double>getColumnOriginalValue("version"));
		wikiPageImpl.setMinorEdit(
			this.<Boolean>getColumnOriginalValue("minorEdit"));
		wikiPageImpl.setContent(this.<String>getColumnOriginalValue("content"));
		wikiPageImpl.setSummary(this.<String>getColumnOriginalValue("summary"));
		wikiPageImpl.setFormat(this.<String>getColumnOriginalValue("format"));
		wikiPageImpl.setHead(this.<Boolean>getColumnOriginalValue("head"));
		wikiPageImpl.setParentTitle(
			this.<String>getColumnOriginalValue("parentTitle"));
		wikiPageImpl.setRedirectTitle(
			this.<String>getColumnOriginalValue("redirectTitle"));
		wikiPageImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		wikiPageImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));
		wikiPageImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		wikiPageImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		wikiPageImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return wikiPageImpl;
	}

	@Override
	public int compareTo(WikiPage wikiPage) {
		int value = 0;

		if (getNodeId() < wikiPage.getNodeId()) {
			value = -1;
		}
		else if (getNodeId() > wikiPage.getNodeId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getTitle().compareToIgnoreCase(wikiPage.getTitle());

		if (value != 0) {
			return value;
		}

		if (getVersion() < wikiPage.getVersion()) {
			value = -1;
		}
		else if (getVersion() > wikiPage.getVersion()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WikiPage)) {
			return false;
		}

		WikiPage wikiPage = (WikiPage)object;

		long primaryKey = wikiPage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<WikiPage> toCacheModel() {
		WikiPageCacheModel wikiPageCacheModel = new WikiPageCacheModel();

		wikiPageCacheModel.mvccVersion = getMvccVersion();

		wikiPageCacheModel.uuid = getUuid();

		String uuid = wikiPageCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			wikiPageCacheModel.uuid = null;
		}

		wikiPageCacheModel.pageId = getPageId();

		wikiPageCacheModel.resourcePrimKey = getResourcePrimKey();

		wikiPageCacheModel.groupId = getGroupId();

		wikiPageCacheModel.companyId = getCompanyId();

		wikiPageCacheModel.userId = getUserId();

		wikiPageCacheModel.userName = getUserName();

		String userName = wikiPageCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			wikiPageCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			wikiPageCacheModel.createDate = createDate.getTime();
		}
		else {
			wikiPageCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			wikiPageCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			wikiPageCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		wikiPageCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode = wikiPageCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			wikiPageCacheModel.externalReferenceCode = null;
		}

		wikiPageCacheModel.nodeId = getNodeId();

		wikiPageCacheModel.title = getTitle();

		String title = wikiPageCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			wikiPageCacheModel.title = null;
		}

		wikiPageCacheModel.version = getVersion();

		wikiPageCacheModel.minorEdit = isMinorEdit();

		wikiPageCacheModel.content = getContent();

		String content = wikiPageCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			wikiPageCacheModel.content = null;
		}

		wikiPageCacheModel.summary = getSummary();

		String summary = wikiPageCacheModel.summary;

		if ((summary != null) && (summary.length() == 0)) {
			wikiPageCacheModel.summary = null;
		}

		wikiPageCacheModel.format = getFormat();

		String format = wikiPageCacheModel.format;

		if ((format != null) && (format.length() == 0)) {
			wikiPageCacheModel.format = null;
		}

		wikiPageCacheModel.head = isHead();

		wikiPageCacheModel.parentTitle = getParentTitle();

		String parentTitle = wikiPageCacheModel.parentTitle;

		if ((parentTitle != null) && (parentTitle.length() == 0)) {
			wikiPageCacheModel.parentTitle = null;
		}

		wikiPageCacheModel.redirectTitle = getRedirectTitle();

		String redirectTitle = wikiPageCacheModel.redirectTitle;

		if ((redirectTitle != null) && (redirectTitle.length() == 0)) {
			wikiPageCacheModel.redirectTitle = null;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			wikiPageCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			wikiPageCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		wikiPageCacheModel.status = getStatus();

		wikiPageCacheModel.statusByUserId = getStatusByUserId();

		wikiPageCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = wikiPageCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			wikiPageCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			wikiPageCacheModel.statusDate = statusDate.getTime();
		}
		else {
			wikiPageCacheModel.statusDate = Long.MIN_VALUE;
		}

		return wikiPageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((WikiPage)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<WikiPage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<WikiPage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WikiPage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((WikiPage)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, WikiPage>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					WikiPage.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _pageId;
	private long _resourcePrimKey;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _externalReferenceCode;
	private long _nodeId;
	private String _title;
	private double _version;
	private boolean _minorEdit;
	private String _content;
	private String _summary;
	private String _format;
	private boolean _head;
	private String _parentTitle;
	private String _redirectTitle;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<WikiPage, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((WikiPage)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("pageId", _pageId);
		_columnOriginalValues.put("resourcePrimKey", _resourcePrimKey);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("nodeId", _nodeId);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("minorEdit", _minorEdit);
		_columnOriginalValues.put("content", _content);
		_columnOriginalValues.put("summary", _summary);
		_columnOriginalValues.put("format", _format);
		_columnOriginalValues.put("head", _head);
		_columnOriginalValues.put("parentTitle", _parentTitle);
		_columnOriginalValues.put("redirectTitle", _redirectTitle);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("pageId", 4L);

		columnBitmasks.put("resourcePrimKey", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("externalReferenceCode", 1024L);

		columnBitmasks.put("nodeId", 2048L);

		columnBitmasks.put("title", 4096L);

		columnBitmasks.put("version", 8192L);

		columnBitmasks.put("minorEdit", 16384L);

		columnBitmasks.put("content", 32768L);

		columnBitmasks.put("summary", 65536L);

		columnBitmasks.put("format", 131072L);

		columnBitmasks.put("head", 262144L);

		columnBitmasks.put("parentTitle", 524288L);

		columnBitmasks.put("redirectTitle", 1048576L);

		columnBitmasks.put("lastPublishDate", 2097152L);

		columnBitmasks.put("status", 4194304L);

		columnBitmasks.put("statusByUserId", 8388608L);

		columnBitmasks.put("statusByUserName", 16777216L);

		columnBitmasks.put("statusDate", 33554432L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private WikiPage _escapedModel;

}