/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.wiki.internal.exportimport.portlet.preferences.processor.WikiCommentsAndRatingsExporterImporterCapability;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class WikiExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(WikiExportImportPortletPreferencesProcessor.class);
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _portletDisplayTemplateExporter;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _portletDisplayTemplateImporter;
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _referencedStagedModelImporter;
    @Reference
    private WikiCommentsAndRatingsExporterImporterCapability _wikiCommentsAndRatingsExporterImporterCapability;
    @Reference
    private WikiNodeLocalService _wikiNodeLocalService;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet)")
    private PortletDataHandler _wikiPortletDataHandler;

    public List<Capability> getExportCapabilities() {
        return ListUtil.fromArray((Object[])new Capability[]{this._portletDisplayTemplateExporter, this._wikiCommentsAndRatingsExporterImporterCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.fromArray((Object[])new Capability[]{this._wikiCommentsAndRatingsExporterImporterCapability, this._referencedStagedModelImporter, this._portletDisplayTemplateImporter});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!this._exportImportHelper.isExportPortletData(portletDataContext) || !portletDataContext.getBooleanParameter(this._wikiPortletDataHandler.getNamespace(), "wiki-pages")) {
            return portletPreferences;
        }
        try {
            portletDataContext.addPortletPermissions("com.liferay.wiki");
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
            portletDataException.setType(18);
            throw portletDataException;
        }
        try {
            String portletId = portletDataContext.getPortletId();
            ExportActionableDynamicQuery nodeActionableDynamicQuery = this._wikiNodeLocalService.getExportActionableDynamicQuery(portletDataContext);
            nodeActionableDynamicQuery.setPerformActionMethod(wikiNode -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)wikiNode));
            nodeActionableDynamicQuery.performActions();
            String[] pageActionableDynamicQuery = this._wikiPageLocalService.getExportActionableDynamicQuery(portletDataContext);
            pageActionableDynamicQuery.setPerformActionMethod(wikiPage -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)wikiPage));
            pageActionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
            portletDataException.setType(11);
            throw portletDataException;
        }
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        String hiddenNodeNames = portletPreferences.getValue("hiddenNodes", null);
        for (String hiddenNodeName : StringUtil.split((String)hiddenNodeNames)) {
            this._exportNode(portletDataContext, group, hiddenNodeName);
        }
        String visibleNodeNames = portletPreferences.getValue("visibleNodes", null);
        for (String visibleNodeName : StringUtil.split((String)visibleNodeNames)) {
            this._exportNode(portletDataContext, group, visibleNodeName);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!portletDataContext.getBooleanParameter(this._wikiPortletDataHandler.getNamespace(), "wiki-pages")) {
            return portletPreferences;
        }
        try {
            portletDataContext.importPortletPermissions("com.liferay.wiki");
        }
        catch (PortalException portalException) {
            PortletDataException portletDataException = new PortletDataException((Throwable)portalException);
            portletDataException.setPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
            portletDataException.setType(20);
            throw portletDataException;
        }
        Element nodesElement = portletDataContext.getImportDataGroupElement(WikiNode.class);
        List nodeElements = nodesElement.elements();
        for (Element nodeElement : nodeElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)nodeElement);
        }
        Element pagesElement = portletDataContext.getImportDataGroupElement(WikiPage.class);
        List pageElements = pagesElement.elements();
        for (Element pageElement : pageElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)pageElement);
        }
        return portletPreferences;
    }

    private void _exportNode(PortletDataContext portletDataContext, Group group, String nodeName) throws PortletDataException {
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet(portletDataContext.getPortletId())) {
            return;
        }
        WikiNode node = this._wikiNodeLocalService.fetchNode(portletDataContext.getScopeGroupId(), nodeName);
        if (node == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to export referenced wiki node " + nodeName));
            }
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)node);
    }
}

