/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.model.WikiPage;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class})
public class CycleDetectorWikiPageModelListener
extends BaseModelListener<WikiPage> {
    public void onBeforeCreate(WikiPage model) throws ModelListenerException {
        if (this._isCycleDetectedInWikiPagesGraph(model)) {
            throw new ModelListenerException("Unable to create wiki page " + model.getTitle() + " because a cycle was detected");
        }
    }

    public void onBeforeUpdate(WikiPage originalModel, WikiPage model) throws ModelListenerException {
        if (this._isCycleDetectedInWikiPagesGraph(model)) {
            throw new ModelListenerException("Unable to update wiki page " + model.getTitle() + " because a cycle was detected");
        }
    }

    private boolean _isCycleDetectedInWikiPagesGraph(WikiPage wikiPage) {
        String title = wikiPage.getTitle();
        if (Validator.isBlank((String)title)) {
            return false;
        }
        title = title.trim();
        for (WikiPage parentPage = wikiPage; parentPage != null; parentPage = parentPage.fetchParentPage()) {
            String parentTitle = parentPage.getParentTitle();
            if (Validator.isBlank((String)parentTitle)) {
                return false;
            }
            if (!StringUtil.equalsIgnoreCase((String)title, (String)(parentTitle = parentTitle.trim()))) continue;
            return true;
        }
        return false;
    }
}

