/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class WikiNodeIndexer
extends BaseIndexer<WikiNode> {
    public static final String CLASS_NAME = WikiNode.class.getName();
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(WikiNodeIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private WikiNodeLocalService _wikiNodeLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;

    public WikiNodeIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(false);
        this.setPermissionAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._wikiNodeModelResourcePermission.contains(permissionChecker, (ClassedModel)this._wikiNodeLocalService.getNode(entryClassPK), "VIEW");
    }

    protected void doDelete(WikiNode wikiNode) throws Exception {
        this.deleteDocument(wikiNode.getCompanyId(), "UID=" + this.uidFactory.getUID((ClassedModel)wikiNode));
    }

    protected Document doGetDocument(WikiNode wikiNode) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)wikiNode);
        this.uidFactory.setUID((ClassedModel)wikiNode, document);
        document.addText("description", wikiNode.getDescription());
        String title = wikiNode.getName();
        if (wikiNode.isInTrash()) {
            title = this._trashHelper.getOriginalTitle(title);
        }
        document.addText("title", title);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._wikiNodeLocalService.getNode(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexEntries(companyId);
    }

    protected void doReindex(WikiNode wikiNode) throws Exception {
        Document document = this.getDocument(wikiNode);
        if (wikiNode.isInTrash()) {
            this._deleteDocument(wikiNode);
            return;
        }
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), wikiNode.getCompanyId(), document, this.isCommitImmediately());
    }

    private void _deleteDocument(WikiNode wikiNode) throws Exception {
        this._indexWriterHelper.deleteDocument(this.getSearchEngineId(), wikiNode.getCompanyId(), this.uidFactory.getUID((ClassedModel)wikiNode), this.isCommitImmediately());
    }

    private void _reindexEntries(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._wikiNodeLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(property.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(node -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(node)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index wiki node " + node.getNodeId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

