/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.BaseModelResourcePermissionWrapper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.WorkflowedModelPermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.util.PropsValues;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageModel;
import com.liferay.wiki.service.WikiPageLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.wiki.model.WikiPage"}, service={ModelResourcePermission.class})
public class WikiPageModelResourcePermissionWrapper
extends BaseModelResourcePermissionWrapper<WikiPage> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.wiki)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference
    private WorkflowPermission _workflowPermission;

    protected ModelResourcePermission<WikiPage> doGetModelResourcePermission() {
        return ModelResourcePermissionFactory.create(WikiPage.class, WikiPageModel::getResourcePrimKey, resourcePrimKey -> {
            WikiPage page = this._wikiPageLocalService.fetchPage(resourcePrimKey.longValue());
            if (page == null) {
                return this._wikiPageLocalService.getPageByPageId(resourcePrimKey.longValue());
            }
            return page;
        }, (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_wiki_web_portlet_WikiPortlet", WikiPageModel::getResourcePrimKey));
            consumer.accept(new WorkflowedModelPermissionLogic(this._workflowPermission, modelResourcePermission, this._groupLocalService, WikiPageModel::getResourcePrimKey));
            consumer.accept((permissionChecker, name, page, actionId) -> {
                if (page.isDraft() && actionId.equals("DELETE") && page.getStatusByUserId() == permissionChecker.getUserId()) {
                    return true;
                }
                return null;
            });
            consumer.accept(new RedirectPageDynamicInheritanceModelResourcePermissionLogic());
        });
    }

    private class RedirectPageDynamicInheritanceModelResourcePermissionLogic
    implements ModelResourcePermissionLogic<WikiPage> {
        private RedirectPageDynamicInheritanceModelResourcePermissionLogic() {
        }

        public Boolean contains(PermissionChecker permissionChecker, String name, WikiPage page, String actionId) throws PortalException {
            if (!actionId.equals("VIEW")) {
                return null;
            }
            WikiPage redirectPage = page.fetchRedirectPage();
            if (redirectPage != null) {
                page = redirectPage;
            }
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                if (!WikiPageModelResourcePermissionWrapper.this._wikiNodeModelResourcePermission.contains(permissionChecker, (ClassedModel)page.getNode(), "VIEW")) {
                    return false;
                }
                while (page != null) {
                    if (!this._hasPermission(permissionChecker, page, "VIEW")) {
                        return false;
                    }
                    page = page.fetchParentPage();
                }
                return true;
            }
            return this._hasPermission(permissionChecker, page, "VIEW");
        }

        private boolean _hasPermission(PermissionChecker permissionChecker, WikiPage page, String actionId) {
            return permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUserId(), actionId) || permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
        }
    }
}

