/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.verify;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.wiki.service"}, service={VerifyProcess.class})
public class WikiServiceVerifyProcess
extends VerifyProcess {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.wiki.service)(release.schema.version>=2.3.0))")
    private Release _release;
    @Reference
    private Staging _staging;

    protected void doVerify() throws Exception {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-157670"))) {
            return;
        }
        this.updateStagedPortletNames();
    }

    protected void updateStagedPortletNames() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (typeSettingsUnicodeProperties == null) {
                return;
            }
            String propertyKey = this._staging.getStagedPortletId("com_liferay_wiki_web_portlet_WikiPortlet");
            String propertyValue = typeSettingsUnicodeProperties.getProperty(propertyKey);
            if (Validator.isNull((String)propertyValue)) {
                return;
            }
            typeSettingsUnicodeProperties.remove((Object)propertyKey);
            propertyKey = this._staging.getStagedPortletId("com_liferay_wiki_web_portlet_WikiAdminPortlet");
            typeSettingsUnicodeProperties.put(propertyKey, propertyValue);
            group.setTypeSettingsProperties(typeSettingsUnicodeProperties);
            this._groupLocalService.updateGroup(group);
        });
        groupActionableDynamicQuery.performActions();
    }
}

