/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class WikiPageVersionConstraintResolver
implements ConstraintResolver<WikiPage> {
    @Reference
    protected WikiPageLocalService wikiPageLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-wiki-page-version";
    }

    public Class<WikiPage> getModelClass() {
        return WikiPage.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-wiki-page-version-was-updated-to-latest";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"resourcePrimKey", "nodeId", "version"};
    }

    public void resolveConflict(ConstraintResolverContext<WikiPage> constraintResolverContext) throws PortalException {
        WikiPage ctPage = (WikiPage)constraintResolverContext.getSourceCTModel();
        WikiPage prodPage = (WikiPage)constraintResolverContext.getInTarget(() -> this.wikiPageLocalService.getLatestPage(ctPage.getResourcePrimKey(), -1, false));
        ctPage.setVersion(MathUtil.format((double)(prodPage.getVersion() + 0.1), (int)1, (int)1));
        this.wikiPageLocalService.updateWikiPage(ctPage);
        CTPersistence ctPersistence = this.wikiPageLocalService.getCTPersistence();
        ctPersistence.flush();
        if (ctPage.isHead()) {
            prodPage.setHead(false);
            this.wikiPageLocalService.updateWikiPage(prodPage);
            ctPersistence.flush();
        }
    }
}

