/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.engine;

import com.liferay.diff.DiffHtml;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.WikiFormatException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiEngineRenderer.class})
public class WikiEngineRendererImpl
implements WikiEngineRenderer {
    private static final Pattern _editPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE_EDIT\\$\\](.*?)\\[\\$END_PAGE_TITLE_EDIT\\$\\]");
    private static final Pattern _viewPageURLPattern = Pattern.compile("\\[\\$BEGIN_PAGE_TITLE\\$\\](.*?)\\[\\$END_PAGE_TITLE\\$\\]");
    private BundleContext _bundleContext;
    @Reference
    private DiffHtml _diffHtml;
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<?, ?> _portalCache;
    private ServiceTrackerMap<String, List<WikiEngine>> _serviceTrackerMap;

    public String convert(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException, WikiFormatException {
        WikiEngine wikiEngine = this.fetchWikiEngine(page.getFormat());
        if (wikiEngine == null) {
            throw new WikiFormatException();
        }
        LiferayPortletURL liferayViewPageURL = (LiferayPortletURL)viewPageURL;
        LiferayPortletURL liferayEditPageURL = (LiferayPortletURL)editPageURL;
        String content = wikiEngine.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        String editPageURLString = "";
        if (editPageURL != null) {
            liferayEditPageURL.setParameter("title", "__REPLACEMENT__", false);
            editPageURLString = editPageURL.toString();
            editPageURLString = StringUtil.replace((String)editPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        Matcher matcher = _editPageURLPattern.matcher(content);
        content = this._convertURLs(editPageURLString, matcher);
        String viewPageURLString = "";
        if (viewPageURL != null) {
            liferayViewPageURL.setParameter("title", "__REPLACEMENT__", false);
            viewPageURLString = viewPageURL.toString();
            viewPageURLString = StringUtil.replace((String)viewPageURLString, (String)"__REPLACEMENT__", (String)"$1");
        }
        matcher = _viewPageURLPattern.matcher(content);
        content = this._convertURLs(viewPageURLString, matcher);
        content = this._replaceAttachments(content, page.getTitle(), attachmentURLPrefix);
        return content;
    }

    public String diffHtml(WikiPage sourcePage, WikiPage targetPage, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws Exception {
        String sourceContent = "";
        String targetContent = "";
        if (sourcePage != null) {
            sourceContent = this.convert(sourcePage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        if (targetPage != null) {
            targetContent = this.convert(targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        return this._diffHtml.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
    }

    public WikiEngine fetchWikiEngine(String format) {
        List wikiEngines = (List)this._serviceTrackerMap.getService((Object)format);
        if (wikiEngines == null) {
            return null;
        }
        return (WikiEngine)wikiEngines.get(0);
    }

    public Collection<String> getFormats() {
        return this._serviceTrackerMap.keySet();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._portalCache = this._multiVMPool.getPortalCache(WikiPageDisplay.class.getName());
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, WikiEngine.class, null, (serviceReference, emitter) -> {
            WikiEngine wikiEngine = (WikiEngine)this._bundleContext.getService(serviceReference);
            try {
                emitter.emit((Object)wikiEngine.getFormat());
            }
            finally {
                this._bundleContext.ungetService(serviceReference);
            }
        }, (ServiceTrackerMapListener)new ServiceTrackerMapListener<String, WikiEngine, List<WikiEngine>>(){

            public void keyEmitted(ServiceTrackerMap<String, List<WikiEngine>> serviceTrackerMap, String key, WikiEngine serviceWikiEngine, List<WikiEngine> contentWikiEngines) {
                WikiEngineRendererImpl.this._portalCache.removeAll();
            }

            public void keyRemoved(ServiceTrackerMap<String, List<WikiEngine>> serviceTrackerMap, String key, WikiEngine serviceWikiEngine, List<WikiEngine> contentWikiEngines) {
                WikiEngineRendererImpl.this._portalCache.removeAll();
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _convertURLs(String url, Matcher matcher) {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = null;
            if (matcher.groupCount() >= 1) {
                String encodedTitle = URLCodec.encodeURL((String)HtmlUtil.unescape((String)matcher.group(1)));
                replacement = StringUtil.replace((String)url, (String)"$1", (String)encodedTitle);
            } else {
                replacement = url;
            }
            matcher.appendReplacement(sb, replacement);
        }
        sb = matcher.appendTail(sb);
        return sb.toString();
    }

    private String _replaceAttachments(String content, String title, String attachmentURLPrefix) {
        content = StringUtil.replace((String)content, (String)"[$WIKI_PAGE_NAME$]", (String)title);
        content = StringUtil.replace((String)content, (String)"[$ATTACHMENT_URL_PREFIX$]", (String)attachmentURLPrefix);
        return content;
    }
}

