/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search;

import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.capabilities.RelatedModelCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"related.entry.indexer.class.name=com.liferay.wiki.model.WikiPage"}, service={RelatedEntryIndexer.class})
public class WikiPageRelatedEntryIndexer
extends BaseRelatedEntryIndexer {
    private static final Log _log = LogFactoryUtil.getLog(WikiPageRelatedEntryIndexer.class);
    @Reference
    private WikiPageLocalService _wikiPageLocalService;

    public void addRelatedEntryFields(Document document, Object object) throws Exception {
        long classPK = 0L;
        if (object instanceof Comment) {
            Comment comment = (Comment)object;
            classPK = comment.getClassPK();
        } else if (object instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)object;
            RelatedModelCapability relatedModelCapability = (RelatedModelCapability)fileEntry.getRepositoryCapability(RelatedModelCapability.class);
            classPK = relatedModelCapability.getClassPK(fileEntry);
        }
        WikiPage page = null;
        try {
            page = this._wikiPageLocalService.getPage(classPK);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return;
        }
        document.addKeyword("nodeId", page.getNodeId());
    }
}

