/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search.spi.model.index.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingDocumentContributor;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.trash.TrashHelper;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.exception.WikiFormatException;
import com.liferay.wiki.model.WikiPage;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.wiki.model.WikiPage"}, service={ModelDocumentContributor.class})
public class WikiPageModelDocumentContributor
implements ModelDocumentContributor<WikiPage> {
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(WikiPageModelDocumentContributor.class);
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private TextEmbeddingDocumentContributor _textEmbeddingDocumentContributor;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private WikiEngineRenderer _wikiEngineRenderer;

    public void contribute(Document document, WikiPage wikiPage) {
        String content;
        block4: {
            this.uidFactory.setUID((ClassedModel)wikiPage, document);
            content = null;
            try {
                content = this._htmlParser.extractText(this._wikiEngineRenderer.convert(wikiPage, null, null, null));
                document.addText("content", content);
            }
            catch (PageContentException | WikiFormatException exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Unable to get wiki engine for " + wikiPage.getFormat()), exception);
            }
        }
        document.addKeyword("nodeId", wikiPage.getNodeId());
        String title = wikiPage.getTitle();
        if (wikiPage.isInTrash()) {
            title = this._trashHelper.getOriginalTitle(title);
        }
        document.addText("title", title);
        for (Locale locale : this._language.getAvailableLocales(wikiPage.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(this._localization.getLocalizedName("content", languageId), content);
            document.addText(this._localization.getLocalizedName("title", languageId), title);
            this._textEmbeddingDocumentContributor.contribute(document, languageId, (BaseModel)wikiPage, StringBundler.concat((String[])new String[]{wikiPage.getTitle(), ".", " ", content}));
        }
        document.addNumber("versionCount", GetterUtil.getDouble((Object)wikiPage.getVersion()));
    }
}

