/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class WikiNodeStagedModelDataHandler
extends BaseStagedModelDataHandler<WikiNode> {
    public static final String[] CLASS_NAMES = new String[]{WikiNode.class.getName()};
    @Reference
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private WikiNodeLocalService _wikiNodeLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        WikiNode wikiNode = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (wikiNode != null) {
            this.deleteStagedModel(wikiNode);
        }
    }

    public void deleteStagedModel(WikiNode node) throws PortalException {
        this._wikiNodeLocalService.deleteNode(node);
    }

    public WikiNode fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._wikiNodeLocalService.fetchWikiNodeByUuidAndGroupId(uuid, groupId);
    }

    public List<WikiNode> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._wikiNodeLocalService.getWikiNodesByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        Element nodeElement = portletDataContext.getExportDataElement((ClassedModel)node);
        portletDataContext.addClassedModel(nodeElement, ExportImportPathUtil.getModelPath((StagedModel)node), (ClassedModel)node);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long nodeId) throws Exception {
        WikiNode existingNode = (WikiNode)this.fetchMissingReference(uuid, groupId);
        if (existingNode == null) {
            return;
        }
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        nodeIds.put(nodeId, existingNode.getNodeId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        long userId = portletDataContext.getUserId(node.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)node);
        WikiNode importedNode = null;
        WikiNode existingNode = this.fetchStagedModelByUuidAndGroupId(node.getUuid(), portletDataContext.getScopeGroupId());
        String nodeName = node.getName();
        WikiNode nodeWithSameName = this._wikiNodeLocalService.fetchNode(portletDataContext.getScopeGroupId(), nodeName);
        if (portletDataContext.isDataStrategyMirror()) {
            if (existingNode == null) {
                if (nodeWithSameName != null) {
                    nodeName = this.getNodeName(portletDataContext, node, nodeName, 2);
                }
                serviceContext.setUuid(node.getUuid());
                importedNode = this._wikiNodeLocalService.addNode(node.getExternalReferenceCode(), userId, nodeName, node.getDescription(), serviceContext);
            } else {
                String uuid = existingNode.getUuid();
                if (nodeWithSameName != null && !uuid.equals(nodeWithSameName.getUuid())) {
                    nodeName = this.getNodeName(portletDataContext, node, nodeName, 2);
                }
                importedNode = this._wikiNodeLocalService.updateNode(existingNode.getNodeId(), nodeName, node.getDescription(), serviceContext);
            }
        } else {
            String initialNodeName = this._wikiGroupServiceConfiguration.initialNodeName();
            importedNode = existingNode != null && initialNodeName.equals(existingNode.getName()) ? this._wikiNodeLocalService.updateNode(existingNode.getNodeId(), nodeName, node.getDescription(), serviceContext) : this._wikiNodeLocalService.addNode(node.getExternalReferenceCode(), userId, this.getNodeName(portletDataContext, node, nodeName, 2), node.getDescription(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)node, (ClassedModel)importedNode);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        WikiNode existingNode = this.fetchStagedModelByUuidAndGroupId(node.getUuid(), portletDataContext.getScopeGroupId());
        if (existingNode == null || !existingNode.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)WikiNode.class.getName());
        if (trashHandler.isRestorable(existingNode.getNodeId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(node.getUserUuid()), existingNode.getNodeId());
        }
    }

    protected String getNodeName(PortletDataContext portletDataContext, WikiNode node, String name, int count) throws Exception {
        WikiNode existingNode = this._wikiNodeLocalService.fetchNode(portletDataContext.getScopeGroupId(), name);
        if (existingNode == null) {
            return name;
        }
        String nodeName = node.getName();
        return this.getNodeName(portletDataContext, node, StringBundler.concat((Object[])new Object[]{nodeName, " ", count}), ++count);
    }

    @Reference(unbind="-")
    protected void setWikiNodeLocalService(WikiNodeLocalService wikiNodeLocalService) {
        this._wikiNodeLocalService = wikiNodeLocalService;
    }
}

