/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.model.WikiPage;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class})
public class CycleDetectorWikiPageModelListener
extends BaseModelListener<WikiPage> {
    public void onBeforeCreate(WikiPage model) throws ModelListenerException {
        if (this.isCycleDetectedInWikiPagesGraph(model)) {
            throw new ModelListenerException("Unable to create wiki page " + model.getTitle() + " because a cycle was detected");
        }
    }

    public void onBeforeUpdate(WikiPage model) throws ModelListenerException {
        if (this.isCycleDetectedInWikiPagesGraph(model)) {
            throw new ModelListenerException("Unable to update wiki page " + model.getTitle() + " because a cycle was detected");
        }
    }

    protected boolean isCycleDetectedInWikiPagesGraph(WikiPage wikiPage) {
        String title2 = wikiPage.getTitle();
        if (Validator.isBlank((String)title2)) {
            return false;
        }
        title2 = title2.trim();
        for (WikiPage parentPage = wikiPage; parentPage != null; parentPage = parentPage.fetchParentPage()) {
            String parentTitle = parentPage.getParentTitle();
            if (Validator.isBlank((String)parentTitle)) {
                return false;
            }
            if (!StringUtil.equalsIgnoreCase((String)title2, (String)(parentTitle = parentTitle.trim()))) continue;
            return true;
        }
        return false;
    }
}

