/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class WikiPageResourceUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateWikiPageResources();
    }

    protected long getGroupId(long resourcePrimKey) throws Exception {
        long groupId = 0L;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId from WikiPage where resourcePrimKey = ?");){
            preparedStatement.setLong(1, resourcePrimKey);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    groupId = resultSet.getLong("groupId");
                }
            }
        }
        return groupId;
    }

    protected void updateWikiPageResources() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select resourcePrimKey from WikiPageResource");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                this.runSQL(StringBundler.concat((Object[])new Object[]{"update WikiPageResource set groupId = ", this.getGroupId(resourcePrimKey), " where resourcePrimKey = ", resourcePrimKey}));
            }
        }
    }
}

