/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.base.WikiPageResourceLocalServiceBaseImpl;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.wiki.model.WikiPageResource"}, service={AopService.class})
public class WikiPageResourceLocalServiceImpl
extends WikiPageResourceLocalServiceBaseImpl {
    public WikiPageResource addPageResource(long groupId, long nodeId, String title2) {
        long pageResourcePrimKey = this.counterLocalService.increment();
        WikiPageResource pageResource = this.wikiPageResourcePersistence.create(pageResourcePrimKey);
        pageResource.setGroupId(groupId);
        pageResource.setNodeId(nodeId);
        pageResource.setTitle(title2);
        return (WikiPageResource)this.wikiPageResourcePersistence.update((BaseModel)pageResource);
    }

    public void deletePageResource(long nodeId, String title2) throws PortalException {
        this.wikiPageResourcePersistence.removeByN_T(nodeId, title2);
    }

    public WikiPageResource fetchPageResource(long nodeId, String title2) {
        return this.wikiPageResourcePersistence.fetchByN_T(nodeId, title2);
    }

    public WikiPageResource fetchPageResource(String uuid) {
        return this.wikiPageResourcePersistence.fetchByUuid_First(uuid, null);
    }

    public WikiPageResource getPageResource(long pageResourcePrimKey) throws PortalException {
        return this.wikiPageResourcePersistence.findByPrimaryKey(pageResourcePrimKey);
    }

    public WikiPageResource getPageResource(long nodeId, String title2) throws PortalException {
        return this.wikiPageResourcePersistence.findByN_T(nodeId, title2);
    }

    public long getPageResourcePrimKey(long groupId, long nodeId, String title2) {
        WikiPageResource pageResource = this.wikiPageResourcePersistence.fetchByN_T(nodeId, title2);
        if (pageResource == null) {
            pageResource = this.wikiPageResourceLocalService.addPageResource(groupId, nodeId, title2);
        }
        return pageResource.getResourcePrimKey();
    }
}

