/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import com.liferay.rss.util.RSSUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.wiki.configuration.WikiGroupServiceOverriddenConfiguration;
import com.liferay.wiki.engine.WikiEngineRenderer;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.base.WikiPageServiceBaseImpl;
import com.liferay.wiki.util.comparator.PageCreateDateComparator;
import java.io.File;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=wiki", "json.web.service.context.path=WikiPage"}, service={AopService.class})
public class WikiPageServiceImpl
extends WikiPageServiceBaseImpl {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference
    private RSSExporter _rssExporter;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private SyndModelFactory _syndModelFactory;
    @Reference
    private WikiEngineRenderer _wikiEngineRenderer;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiNode)")
    private ModelResourcePermission<WikiNode> _wikiNodeModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;

    public WikiPage addPage(long nodeId, String title2, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(this.getUserId(), nodeId, title2, content, summary, minorEdit, serviceContext);
    }

    @Deprecated
    public WikiPage addPage(long nodeId, String title2, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(this.getUserId(), nodeId, title2, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
    }

    public WikiPage addPage(String externalReferenceCode, long nodeId, String title2, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(externalReferenceCode, this.getUserId(), nodeId, title2, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
    }

    public FileEntry addPageAttachment(long nodeId, String title2, String fileName, File file, String mimeType) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.addPageAttachment(this.getUserId(), nodeId, title2, fileName, file, mimeType);
    }

    public FileEntry addPageAttachment(long nodeId, String title2, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.addPageAttachment(this.getUserId(), nodeId, title2, fileName, inputStream, mimeType);
    }

    public List<FileEntry> addPageAttachments(long nodeId, String title2, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.addPageAttachments(this.getUserId(), nodeId, title2, inputStreamOVPs);
    }

    public FileEntry addTempFileEntry(long nodeId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.addTempFileEntry(node.getGroupId(), this.getUserId(), folderName, fileName, inputStream, mimeType);
    }

    public void changeParent(long nodeId, String title2, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.wikiPageLocalService.getPage(nodeId, title2, null), "UPDATE");
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.changeParent(this.getUserId(), nodeId, title2, newParentTitle, serviceContext);
    }

    public void copyPageAttachments(long templateNodeId, String templateTitle, long nodeId, String title2) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.copyPageAttachments(this.getUserId(), templateNodeId, templateTitle, nodeId, title2);
    }

    public void deletePage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title2, true, null);
        if (page == null) {
            return;
        }
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPageLocalService.deletePage(page);
    }

    public void deletePageAttachment(long nodeId, String title2, String fileName) throws PortalException {
        WikiPage page = this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title2, true, null);
        if (page == null) {
            return;
        }
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPageLocalService.deletePageAttachment(nodeId, title2, fileName);
    }

    public void deletePageAttachments(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_First(nodeId, title2, null);
        if (page == null) {
            return;
        }
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPageLocalService.deletePageAttachments(nodeId, title2);
    }

    public void deleteTempFileEntry(long nodeId, String folderName, String fileName) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "ADD_ATTACHMENT");
        this.wikiPageLocalService.deleteTempFileEntry(node.getGroupId(), this.getUserId(), folderName, fileName);
    }

    public void deleteTrashPageAttachments(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_First(nodeId, title2, null);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPageLocalService.deleteTrashPageAttachments(nodeId, title2);
    }

    public void discardDraft(long nodeId, String title2, double version) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_V(nodeId, title2, version);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPagePersistence.remove((BaseModel)page);
    }

    public WikiPage fetchLatestPageByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        WikiPage page = this.wikiPageLocalService.fetchLatestPageByExternalReferenceCode(groupId, externalReferenceCode);
        if (page != null) {
            this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        }
        return page;
    }

    public WikiPage fetchPage(long nodeId, String title2, double version) throws PortalException {
        WikiPage page = this.wikiPageLocalService.fetchPage(nodeId, title2, version);
        if (page != null) {
            this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        }
        return page;
    }

    public List<WikiPage> getChildren(long groupId, long nodeId, boolean head2, String parentTitle) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiPagePersistence.filterFindByG_N_H_P_S(groupId, nodeId, head2, parentTitle, 0);
    }

    public WikiPage getDraftPage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getDraftPage(nodeId, title2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        return page;
    }

    public WikiPage getLatestPageByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        WikiPage wikiPage = this.wikiPageLocalService.getLatestPageByExternalReferenceCode(groupId, externalReferenceCode);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)wikiPage, "VIEW");
        return wikiPage;
    }

    public List<WikiPage> getNodePages(long nodeId, int max) throws PortalException {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        block0: while (pages.size() < max && listNotExhausted) {
            List pageList = this.wikiPageLocalService.getPages(nodeId, true, lastIntervalStart, lastIntervalStart + max);
            lastIntervalStart += max;
            listNotExhausted = pageList.size() == max;
            for (WikiPage page : pageList) {
                if (pages.size() >= max) continue block0;
                if (!this._wikiPageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)page, "VIEW")) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        List<WikiPage> pages = this.getNodePages(nodeId, max);
        return this.exportToRSS(node.getName(), node.getDescription(), type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, pages, false, null);
    }

    public List<WikiPage> getOrphans(WikiNode node) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "VIEW");
        List pages = this.wikiPagePersistence.filterFindByG_N_H_S(node.getGroupId(), node.getNodeId(), true, 0);
        return this.wikiPageLocalService.getOrphans(pages);
    }

    public WikiPage getPage(long pageId) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(pageId);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        return page;
    }

    public WikiPage getPage(long groupId, long nodeId, String title2) throws PortalException {
        List pages = this.wikiPagePersistence.filterFindByG_N_T_H(groupId, nodeId, title2, true, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("{nodeId=");
        sb.append(nodeId);
        sb.append(", title=");
        sb.append(title2);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public WikiPage getPage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(nodeId, title2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        return page;
    }

    public WikiPage getPage(long nodeId, String title2, Boolean head2) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(nodeId, title2, head2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        return page;
    }

    public WikiPage getPage(long nodeId, String title2, double version) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(nodeId, title2, version);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        return page;
    }

    public List<WikiPage> getPages(long groupId, long nodeId, boolean head2, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (status == -1) {
            return this.wikiPagePersistence.filterFindByG_N_H(groupId, nodeId, head2, start, end, orderByComparator);
        }
        return this.wikiPagePersistence.filterFindByG_N_H_S(groupId, nodeId, head2, status, start, end, orderByComparator);
    }

    public List<WikiPage> getPages(long groupId, long nodeId, boolean head2, long userId, boolean includeOwner, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner);
        queryDefinition.setEnd(end);
        queryDefinition.setOrderByComparator(orderByComparator);
        queryDefinition.setStart(start);
        return this.wikiPageFinder.filterFindByG_N_H_S(groupId, nodeId, head2, queryDefinition);
    }

    public List<WikiPage> getPages(long groupId, long userId, long nodeId, int status, int start, int end) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (userId > 0L) {
            return this.wikiPagePersistence.filterFindByG_U_N_S(groupId, userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.filterFindByG_N_S(groupId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public int getPagesCount(long groupId, long nodeId, boolean head2) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiPagePersistence.filterCountByG_N_H_S(groupId, nodeId, head2, 0);
    }

    public int getPagesCount(long groupId, long nodeId, boolean head2, long userId, boolean includeOwner, int status) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, includeOwner);
        return this.wikiPageFinder.filterCountByG_N_H_S(groupId, nodeId, head2, queryDefinition);
    }

    public int getPagesCount(long groupId, long userId, long nodeId, int status) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        if (userId > 0L) {
            return this.wikiPagePersistence.filterCountByG_U_N_S(groupId, userId, nodeId, status);
        }
        return this.wikiPagePersistence.filterCountByG_N_S(groupId, nodeId, status);
    }

    public String getPagesRSS(long nodeId, String title2, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, Locale locale) throws PortalException {
        WikiPage page = this.wikiPageLocalService.fetchPage(nodeId, title2);
        if (page == null) {
            this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        } else {
            this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "VIEW");
        }
        List pages = this.wikiPageLocalService.getPages(nodeId, title2, 0, max, (OrderByComparator)new PageCreateDateComparator(true));
        return this.exportToRSS(title2, title2, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, pages, true, locale);
    }

    public List<WikiPage> getRecentChanges(long groupId, long nodeId, int start, int end) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.add(3, -1);
        return this.wikiPageFinder.findByModifiedDate(groupId, nodeId, new Timestamp(calendar.getTimeInMillis()), false, start, end);
    }

    public int getRecentChangesCount(long groupId, long nodeId) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        Calendar calendar = CalendarFactoryUtil.getCalendar();
        calendar.add(3, -1);
        return this.wikiPageFinder.countByModifiedDate(groupId, nodeId, calendar.getTime(), false);
    }

    public String[] getTempFileNames(long nodeId, String folderName) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)node, "ADD_ATTACHMENT");
        return this.wikiPageLocalService.getTempFileNames(node.getGroupId(), this.getUserId(), folderName);
    }

    public FileEntry movePageAttachmentToTrash(long nodeId, String title2, String fileName) throws PortalException {
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.wikiPageLocalService.getPage(nodeId, title2), "DELETE");
        return this.wikiPageLocalService.movePageAttachmentToTrash(this.getUserId(), nodeId, title2, fileName);
    }

    public WikiPage movePageToTrash(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPagePersistence.fetchByN_T_H_First(nodeId, title2, true, null);
        if (page == null) {
            return null;
        }
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        return this.wikiPageLocalService.movePageToTrash(this.getUserId(), page);
    }

    public WikiPage movePageToTrash(long nodeId, String title2, double version) throws PortalException {
        WikiPage page = this.wikiPagePersistence.findByN_T_V(nodeId, title2, version);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        return this.wikiPageLocalService.movePageToTrash(this.getUserId(), page);
    }

    public void renamePage(long nodeId, String title2, String newTitle, ServiceContext serviceContext) throws PortalException {
        WikiPage page = this.wikiPageLocalService.fetchPage(nodeId, title2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "UPDATE");
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.renamePage(this.getUserId(), nodeId, title2, newTitle, serviceContext);
    }

    public void restorePageAttachmentFromTrash(long nodeId, String title2, String fileName) throws PortalException {
        this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.restorePageAttachmentFromTrash(this.getUserId(), nodeId, title2, fileName);
    }

    public void restorePageFromTrash(long resourcePrimKey) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(resourcePrimKey);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "DELETE");
        this.wikiPageLocalService.restorePageFromTrash(this.getUserId(), page);
    }

    public WikiPage revertPage(long nodeId, String title2, double version, ServiceContext serviceContext) throws PortalException {
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.wikiPageLocalService.getPage(nodeId, title2, version), "UPDATE");
        return this.wikiPageLocalService.revertPage(this.getUserId(), nodeId, title2, version, serviceContext);
    }

    public void subscribePage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(nodeId, title2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "SUBSCRIBE");
        this._subscriptionLocalService.addSubscription(this.getUserId(), page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long nodeId, String title2) throws PortalException {
        WikiPage page = this.wikiPageLocalService.getPage(nodeId, title2);
        this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "SUBSCRIBE");
        this._subscriptionLocalService.deleteSubscription(this.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public WikiPage updatePage(long nodeId, String title2, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        WikiPage page = this.wikiPageLocalService.fetchPage(nodeId, title2);
        if (page == null) {
            this._wikiNodeModelResourcePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        } else {
            this._wikiPageModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)page, "UPDATE");
        }
        return this.wikiPageLocalService.updatePage(this.getUserId(), nodeId, title2, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, List<WikiPage> pages, boolean diff, Locale locale) throws PortalException {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(description);
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        WikiPage latestPage = null;
        StringBundler sb = new StringBundler(6);
        for (WikiPage page : pages) {
            String value;
            SyndEntry syndEntry = this._syndModelFactory.createSyndEntry();
            syndEntry.setAuthor(this._portal.getUserName((BaseModel)page));
            SyndContent syndContent = this._syndModelFactory.createSyndContent();
            syndContent.setType("html");
            sb.setIndex(0);
            sb.append(entryURL);
            if (entryURL.endsWith("/")) {
                sb.append(URLCodec.encodeURL((String)page.getTitle()));
            }
            if (diff) {
                if (latestPage != null || pages.size() == 1) {
                    sb.append("?");
                    sb.append(this._portal.getPortletNamespace("com_liferay_wiki_web_portlet_WikiPortlet"));
                    sb.append("version=");
                    sb.append(page.getVersion());
                    value = null;
                    if (latestPage == null) {
                        value = this._wikiEngineRenderer.convert(page, null, null, attachmentURLPrefix);
                    } else {
                        try {
                            value = this._wikiEngineRenderer.diffHtml(latestPage, page, null, null, attachmentURLPrefix);
                        }
                        catch (PortalException portalException) {
                            throw portalException;
                        }
                        catch (SystemException systemException) {
                            throw systemException;
                        }
                        catch (Exception exception) {
                            throw new SystemException((Throwable)exception);
                        }
                    }
                    syndContent.setValue(value);
                    syndEntry.setDescription(syndContent);
                    syndEntries.add(syndEntry);
                }
            } else {
                value = null;
                if (displayStyle.equals("abstract")) {
                    WikiGroupServiceOverriddenConfiguration wikiGroupServiceOverriddenConfiguration = (WikiGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(WikiGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(page.getGroupId(), "com.liferay.wiki"));
                    value = StringUtil.shorten((String)HtmlUtil.extractText((String)page.getContent()), (int)wikiGroupServiceOverriddenConfiguration.rssAbstractLength(), (String)"");
                } else {
                    value = displayStyle.equals("title") ? "" : this._wikiEngineRenderer.convert(page, null, null, attachmentURLPrefix);
                }
                syndContent.setValue(value);
                syndEntry.setDescription(syndContent);
                syndEntries.add(syndEntry);
            }
            syndEntry.setLink(sb.toString());
            syndEntry.setPublishedDate(page.getCreateDate());
            String title2 = page.getTitle() + " " + page.getVersion();
            if (page.isMinorEdit()) {
                title2 = title2 + StringBundler.concat((String[])new String[]{" ", "(", LanguageUtil.get((Locale)locale, (String)"minor-edit"), ")"});
            }
            syndEntry.setTitle(title2);
            syndEntry.setUpdatedDate(page.getModifiedDate());
            syndEntry.setUri(sb.toString());
            latestPage = page;
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink syndLinkSelf = this._syndModelFactory.createSyndLink();
        syndLinks.add(syndLinkSelf);
        syndLinkSelf.setHref(feedURL);
        syndLinkSelf.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return this._rssExporter.export(syndFeed);
    }
}

