/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.impl.WikiPageImpl;
import com.liferay.wiki.service.persistence.WikiPageFinder;
import com.liferay.wiki.service.persistence.impl.WikiPageFinderBaseImpl;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WikiPageFinder.class})
public class WikiPageFinderImpl
extends WikiPageFinderBaseImpl
implements WikiPageFinder {
    public static final String COUNT_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".countByCreateDate";
    public static final String COUNT_BY_MODIFIED_DATE = WikiPageFinder.class.getName() + ".countByModifiedDate";
    public static final String COUNT_BY_G_N_H_S = WikiPageFinder.class.getName() + ".countByG_N_H_S";
    public static final String FIND_BY_RESOURCE_PRIM_KEY = WikiPageFinder.class.getName() + ".findByResourcePrimKey";
    public static final String FIND_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".findByCreateDate";
    public static final String FIND_BY_MODIFIED_DATE = WikiPageFinder.class.getName() + ".findByModifiedDate";
    public static final String FIND_BY_NO_ASSETS = WikiPageFinder.class.getName() + ".findByNoAssets";
    public static final String FIND_BY_G_N_H_S = WikiPageFinder.class.getName() + ".findByG_N_H_S";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private Portal _portal;

    public int countByCreateDate(long groupId, long nodeId, Date createDate, boolean before) {
        return this.countByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before);
    }

    public int countByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, createDate, before, false);
    }

    public int countByModifiedDate(long groupId, long nodeId, Date modifiedDate, boolean before) {
        return this.doCountByModifiedDate(groupId, nodeId, new Timestamp(modifiedDate.getTime()), before, false);
    }

    public int countByModifiedDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before) {
        return this.doCountByModifiedDate(groupId, nodeId, modifiedDate, before, false);
    }

    public int countByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition) {
        return this.doCountByG_N_H_S(groupId, nodeId, head2, queryDefinition, false);
    }

    public int filterCountByCreateDate(long groupId, long nodeId, Date createDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, true);
    }

    public int filterCountByCreateDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before) {
        return this.doCountByCreateDate(groupId, nodeId, modifiedDate, before, true);
    }

    public int filterCountByModifiedDate(long groupId, long nodeId, Date modifiedDate, boolean before) {
        return this.doCountByModifiedDate(groupId, nodeId, new Timestamp(modifiedDate.getTime()), before, true);
    }

    public int filterCountByModifiedDate(long groupId, long nodeId, Timestamp createDate, boolean before) {
        return this.doCountByModifiedDate(groupId, nodeId, createDate, before, true);
    }

    public int filterCountByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition) {
        return this.doCountByG_N_H_S(groupId, nodeId, head2, queryDefinition, true);
    }

    public List<WikiPage> filterFindByCreateDate(long groupId, long nodeId, Date createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, start, end, true);
    }

    public List<WikiPage> filterFindByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, createDate, before, start, end, true);
    }

    public List<WikiPage> filterFindByModifiedDate(long groupId, long nodeId, Date modifiedDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, new Timestamp(modifiedDate.getTime()), before, start, end, true);
    }

    public List<WikiPage> filterFindByModifiedDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, modifiedDate, before, start, end, true);
    }

    public List<WikiPage> filterFindByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition) {
        return this.doFindByG_N_H_S(groupId, nodeId, head2, queryDefinition, true);
    }

    public WikiPage findByResourcePrimKey(long resourcePrimKey) throws NoSuchPageException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_RESOURCE_PRIM_KEY);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(resourcePrimKey);
            List pages = sqlQuery.list();
            if (!pages.isEmpty()) {
                WikiPage wikiPage = (WikiPage)pages.get(0);
                return wikiPage;
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(3);
        sb.append("No WikiPage exists with the key {resourcePrimKey");
        sb.append(resourcePrimKey);
        sb.append("}");
        throw new NoSuchPageException(sb.toString());
    }

    public List<WikiPage> findByCreateDate(long groupId, long nodeId, Date createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, new Timestamp(createDate.getTime()), before, start, end, false);
    }

    public List<WikiPage> findByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end) {
        return this.doFindByCreateDate(groupId, nodeId, createDate, before, start, end, false);
    }

    public List<WikiPage> findByModifiedDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before, int start, int end) {
        return this.doFindByModifiedDate(groupId, nodeId, modifiedDate, before, start, end, false);
    }

    public List<WikiPage> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_NO_ASSETS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(WikiPage.class));
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiPage> findByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition) {
        return this.doFindByG_N_H_S(groupId, nodeId, head2, queryDefinition, false);
    }

    protected int doCountByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_CREATE_DATE);
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(createDate);
            queryPos.add(true);
            queryPos.add(0);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByModifiedDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_MODIFIED_DATE);
            String modifiedDateComparator = ">";
            if (before) {
                modifiedDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$MODIFIED_DATE_COMPARATOR$]", (String)modifiedDateComparator);
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(modifiedDate);
            queryPos.add(true);
            queryPos.add(0);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_N_H_S, queryDefinition, "WikiPage");
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(head2);
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            queryPos.add(queryDefinition.getStatus());
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<WikiPage> doFindByCreateDate(long groupId, long nodeId, Timestamp createDate, boolean before, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_CREATE_DATE);
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(createDate);
            queryPos.add(true);
            queryPos.add(0);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<WikiPage> doFindByModifiedDate(long groupId, long nodeId, Timestamp modifiedDate, boolean before, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_MODIFIED_DATE);
            String modifiedDateComparator = ">";
            if (before) {
                modifiedDateComparator = "<";
            }
            sql = StringUtil.replace((String)sql, (String)"[$MODIFIED_DATE_COMPARATOR$]", (String)modifiedDateComparator);
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(modifiedDate);
            queryPos.add(true);
            queryPos.add(0);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<WikiPage> doFindByG_N_H_S(long groupId, long nodeId, boolean head2, QueryDefinition<WikiPage> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_N_H_S, queryDefinition, "WikiPage");
            if (inlineSQLHelper) {
                sql = this._inlineSQLHelper.replacePermissionCheck(sql, WikiPage.class.getName(), "WikiPage.resourcePrimKey", groupId);
            }
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator("WikiPage"));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(nodeId);
            queryPos.add(head2);
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

