/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.OutputSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributesOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;
    private final Map<String, String> map;

    public AttributesOutputSegment(Attributes attributes, boolean bl) {
        this(attributes, attributes.getMap(bl));
    }

    public AttributesOutputSegment(Attributes attributes, Map<String, String> map2) {
        if (map2 == null || attributes == null) {
            throw new IllegalArgumentException("both arguments must be non-null");
        }
        this.begin = attributes.getBegin();
        this.end = attributes.getEnd();
        this.map = map2;
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        Attributes.appendHTML(writer, this.map);
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        Attributes.appendHTML(appendable, this.map);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return (this.end - this.begin) * 2;
    }

    @Override
    public String toString() {
        return Attributes.generateHTML(this.map);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(p").append(this.begin).append("-p").append(this.end).append("):");
        try {
            this.appendTo(stringBuilder);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringBuilder.toString();
    }
}

