/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;

public class Renderer
implements CharStreamSource {
    private final Segment rootSegment;
    private int maxLineLength = 76;
    private String newLine = "\r\n";
    private boolean includeHyperlinkURLs = true;
    private boolean decorateFontStyles = false;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private int blockIndentSize = 4;
    private int listIndentSize = 6;
    private char[] listBullets = new char[]{'*', 'o', '+', '#'};
    private String tableCellSeparator = " \t";

    public Renderer(Segment segment) {
        this.rootSegment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    public void appendTo(Appendable appendable) throws IOException {
        new Processor(this, this.rootSegment, this.getMaxLineLength(), this.getNewLine(), this.getIncludeHyperlinkURLs(), this.getDecorateFontStyles(), this.getConvertNonBreakingSpaces(), this.getBlockIndentSize(), this.getListIndentSize(), this.getListBullets(), this.getTableCellSeparator()).appendTo(appendable);
    }

    public long getEstimatedMaximumOutputLength() {
        return this.rootSegment.length();
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public Renderer setMaxLineLength(int n) {
        this.maxLineLength = n;
        return this;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public Renderer setNewLine(String string) {
        this.newLine = string;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.rootSegment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    public Renderer setIncludeHyperlinkURLs(boolean bl) {
        this.includeHyperlinkURLs = bl;
        return this;
    }

    public boolean getIncludeHyperlinkURLs() {
        return this.includeHyperlinkURLs;
    }

    public String renderHyperlinkURL(StartTag startTag) {
        String string = startTag.getAttributeValue("href");
        if (string == null || string.equals("#") || string.startsWith("javascript:")) {
            return null;
        }
        return '<' + string + '>';
    }

    public Renderer setDecorateFontStyles(boolean bl) {
        this.decorateFontStyles = bl;
        return this;
    }

    public boolean getDecorateFontStyles() {
        return this.decorateFontStyles;
    }

    public Renderer setConvertNonBreakingSpaces(boolean bl) {
        this.convertNonBreakingSpaces = bl;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public Renderer setBlockIndentSize(int n) {
        this.blockIndentSize = n;
        return this;
    }

    public int getBlockIndentSize() {
        return this.blockIndentSize;
    }

    public Renderer setListIndentSize(int n) {
        this.listIndentSize = n;
        return this;
    }

    public int getListIndentSize() {
        return this.listIndentSize;
    }

    public Renderer setListBullets(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("listBullets argument must be an array of at least one character");
        }
        this.listBullets = cArray;
        return this;
    }

    public char[] getListBullets() {
        return this.listBullets;
    }

    public Renderer setTableCellSeparator(String string) {
        this.tableCellSeparator = string;
        return this;
    }

    public String getTableCellSeparator() {
        return this.tableCellSeparator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Processor {
        private final Renderer renderer;
        private final Segment rootSegment;
        private final Source source;
        private final int maxLineLength;
        private final String newLine;
        private final boolean includeHyperlinkURLs;
        private final boolean decorateFontStyles;
        private final boolean convertNonBreakingSpaces;
        private final int blockIndentSize;
        private final int listIndentSize;
        private final char[] listBullets;
        private final String tableCellSeparator;
        private Appendable appendable;
        private int renderedIndex;
        private boolean atStartOfLine;
        private int col;
        private int blockIndentLevel;
        private int listIndentLevel;
        private int blockVerticalMargin;
        private boolean preformatted;
        private boolean lastCharWhiteSpace;
        private boolean ignoreInitialWhitespace;
        private boolean bullet;
        private int listBulletNumber;
        private static final int NO_MARGIN = -1;
        private static final int UNORDERED_LIST = -1;
        private static Map<String, ElementHandler> ELEMENT_HANDLERS = new HashMap<String, ElementHandler>();

        public Processor(Renderer renderer, Segment segment, int n, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, char[] cArray, String string2) {
            this.renderer = renderer;
            this.rootSegment = segment;
            this.source = segment.source;
            this.maxLineLength = n;
            this.newLine = string;
            this.includeHyperlinkURLs = bl;
            this.decorateFontStyles = bl2;
            this.convertNonBreakingSpaces = bl3;
            this.blockIndentSize = n2;
            this.listIndentSize = n3;
            this.listBullets = cArray;
            this.tableCellSeparator = string2;
        }

        public void appendTo(Appendable appendable) throws IOException {
            this.reset();
            this.appendable = appendable;
            this.appendSegmentProcessingChildElements(this.rootSegment.begin, this.rootSegment.end, this.rootSegment.getChildElements());
        }

        private void reset() {
            this.renderedIndex = 0;
            this.atStartOfLine = true;
            this.col = 0;
            this.blockIndentLevel = 0;
            this.listIndentLevel = 0;
            this.blockVerticalMargin = -1;
            this.preformatted = false;
            this.ignoreInitialWhitespace = false;
            this.lastCharWhiteSpace = false;
            this.bullet = false;
        }

        private void appendElementContent(Element element) throws IOException {
            int n = element.getContentEnd();
            if (element.isEmpty() || this.renderedIndex >= n) {
                return;
            }
            int n2 = element.getStartTag().end;
            this.appendSegmentProcessingChildElements(Math.max(this.renderedIndex, n2), n, element.getChildElements());
        }

        private void appendSegmentProcessingChildElements(int n, int n2, List<Element> list) throws IOException {
            int n3 = n;
            for (Element element : list) {
                if (n3 >= element.end) continue;
                if (n3 < element.begin) {
                    this.appendSegmentRemovingTags(n3, element.begin);
                }
                Processor.getElementHandler(element).process(this, element);
                n3 = Math.max(this.renderedIndex, element.end);
            }
            if (n3 < n2) {
                this.appendSegmentRemovingTags(n3, n2);
            }
        }

        private static ElementHandler getElementHandler(Element element) {
            if (element.getStartTag().getStartTagType().isServerTag()) {
                return RemoveElementHandler.INSTANCE;
            }
            ElementHandler elementHandler = ELEMENT_HANDLERS.get(element.getName());
            return elementHandler != null ? elementHandler : StandardInlineElementHandler.INSTANCE;
        }

        private void appendSegmentRemovingTags(int n, int n2) throws IOException {
            Tag tag;
            int n3 = n;
            while ((tag = this.source.getNextTag(n3)) != null && tag.begin < n2) {
                this.appendSegment(n3, tag.begin);
                n3 = tag.end;
            }
            this.appendSegment(n3, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendSegment(int n, int n2) throws IOException {
            assert (n <= n2);
            if (n < this.renderedIndex) {
                n = this.renderedIndex;
            }
            if (n >= n2) {
                return;
            }
            try {
                if (this.preformatted) {
                    this.appendPreformattedSegment(n, n2);
                } else {
                    this.appendNonPreformattedSegment(n, n2);
                }
            }
            finally {
                if (this.renderedIndex < n2) {
                    this.renderedIndex = n2;
                }
            }
        }

        private void appendPreformattedSegment(int n, int n2) throws IOException {
            assert (n < n2);
            assert (n >= this.renderedIndex);
            if (this.isStartOfBlock()) {
                this.appendBlockVerticalMargin();
            }
            String string = CharacterReference.decode(this.source.subSequence(n, n2), false, this.convertNonBreakingSpaces);
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == '\n') {
                    this.newLine();
                    continue;
                }
                if (c == '\r') {
                    this.newLine();
                    int n3 = j + 1;
                    if (n3 == string.length()) break;
                    if (string.charAt(n3) != '\n') continue;
                    ++j;
                    continue;
                }
                this.append(c);
            }
        }

        private void appendNonPreformattedSegment(int n, int n2) throws IOException {
            assert (n < n2);
            assert (n >= this.renderedIndex);
            String string = CharacterReference.decodeCollapseWhiteSpace(this.source.subSequence(n, n2), this.convertNonBreakingSpaces);
            if (string.length() == 0) {
                if (!this.ignoreInitialWhitespace) {
                    this.lastCharWhiteSpace = true;
                }
                return;
            }
            if (this.isStartOfBlock()) {
                this.appendBlockVerticalMargin();
            } else if (this.lastCharWhiteSpace || Segment.isWhiteSpace(this.source.charAt(n)) && !this.ignoreInitialWhitespace) {
                this.append(' ');
            }
            int n3 = 0;
            int n4 = 0;
            this.ignoreInitialWhitespace = false;
            this.lastCharWhiteSpace = false;
            while (true) {
                if (n4 < string.length() && (string.charAt(n4) != ' ' || n4 + 1 < string.length() && string.charAt(n4 + 1) == '>' || n4 + 6 < string.length() && string.startsWith("From ", n4 + 1))) {
                    ++n4;
                    continue;
                }
                if (this.col + n4 - n3 + 1 >= this.maxLineLength) {
                    if (this.lastCharWhiteSpace && (this.blockIndentLevel | this.listIndentLevel) == 0) {
                        this.append(' ');
                    }
                    this.startNewLine(0);
                } else if (this.lastCharWhiteSpace) {
                    this.append(' ');
                }
                this.append(string, n3, n4);
                if (n4 == string.length()) break;
                this.lastCharWhiteSpace = true;
                n3 = ++n4;
            }
            this.lastCharWhiteSpace = Segment.isWhiteSpace(this.source.charAt(n2 - 1));
        }

        private boolean isStartOfBlock() {
            return this.blockVerticalMargin != -1;
        }

        private void appendBlockVerticalMargin() throws IOException {
            assert (this.blockVerticalMargin != -1);
            this.startNewLine(this.blockVerticalMargin);
            this.blockVerticalMargin = -1;
        }

        private void blockBoundary(int n) throws IOException {
            if (this.blockVerticalMargin < n) {
                this.blockVerticalMargin = n;
            }
        }

        private void startNewLine(int n) throws IOException {
            int n2 = n + (this.atStartOfLine ? 0 : 1);
            for (int j = 0; j < n2; ++j) {
                this.appendable.append(this.newLine);
            }
            this.atStartOfLine = true;
            this.ignoreInitialWhitespace = false;
            this.lastCharWhiteSpace = false;
        }

        private void newLine() throws IOException {
            this.appendable.append(this.newLine);
            this.atStartOfLine = true;
            this.ignoreInitialWhitespace = false;
            this.lastCharWhiteSpace = false;
        }

        private void appendIndent() throws IOException {
            int n;
            for (n = this.blockIndentLevel * this.blockIndentSize; n > 0; --n) {
                this.appendable.append(' ');
            }
            if (this.bullet) {
                for (n = (this.listIndentLevel - 1) * this.listIndentSize; n > 0; --n) {
                    this.appendable.append(' ');
                }
                if (this.listBulletNumber == -1) {
                    for (n = this.listIndentSize - 2; n > 0; --n) {
                        this.appendable.append(' ');
                    }
                    this.appendable.append(this.listBullets[(this.listIndentLevel - 1) % this.listBullets.length]).append(' ');
                } else {
                    String string = Integer.toString(this.listBulletNumber);
                    for (int j = this.listIndentSize - string.length() - 2; j > 0; --j) {
                        this.appendable.append(' ');
                    }
                    this.appendable.append(string).append(". ");
                }
                this.bullet = false;
            } else {
                for (n = this.listIndentLevel * this.listIndentSize; n > 0; --n) {
                    this.appendable.append(' ');
                }
            }
            this.col = this.blockIndentLevel * this.blockIndentSize + this.listIndentLevel * this.listIndentSize;
            this.atStartOfLine = false;
        }

        private Processor append(char c) throws IOException {
            if (this.atStartOfLine) {
                this.appendIndent();
            }
            this.appendable.append(c);
            ++this.col;
            return this;
        }

        private Processor append(String string) throws IOException {
            if (this.atStartOfLine) {
                this.appendIndent();
            }
            this.appendable.append(string);
            this.col += string.length();
            return this;
        }

        private void append(CharSequence charSequence, int n, int n2) throws IOException {
            if (this.atStartOfLine) {
                this.appendIndent();
            }
            for (int j = n; j < n2; ++j) {
                this.appendable.append(charSequence.charAt(j));
            }
            this.col += n2 - n;
        }

        static {
            ELEMENT_HANDLERS.put("a", A_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("address", StandardBlockElementHandler.INSTANCE_0_0);
            ELEMENT_HANDLERS.put("applet", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("b", FontStyleElementHandler.INSTANCE_B);
            ELEMENT_HANDLERS.put("blockquote", StandardBlockElementHandler.INSTANCE_1_1_INDENT);
            ELEMENT_HANDLERS.put("br", BR_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("button", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("caption", StandardBlockElementHandler.INSTANCE_0_0);
            ELEMENT_HANDLERS.put("center", StandardBlockElementHandler.INSTANCE_1_1);
            ELEMENT_HANDLERS.put("code", FontStyleElementHandler.INSTANCE_CODE);
            ELEMENT_HANDLERS.put("dd", StandardBlockElementHandler.INSTANCE_0_0_INDENT);
            ELEMENT_HANDLERS.put("dir", ListElementHandler.INSTANCE_UL);
            ELEMENT_HANDLERS.put("div", StandardBlockElementHandler.INSTANCE_0_0);
            ELEMENT_HANDLERS.put("dt", StandardBlockElementHandler.INSTANCE_0_0);
            ELEMENT_HANDLERS.put("em", FontStyleElementHandler.INSTANCE_I);
            ELEMENT_HANDLERS.put("fieldset", StandardBlockElementHandler.INSTANCE_1_1);
            ELEMENT_HANDLERS.put("form", StandardBlockElementHandler.INSTANCE_1_1);
            ELEMENT_HANDLERS.put("h1", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("h2", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("h3", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("h4", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("h5", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("h6", StandardBlockElementHandler.INSTANCE_2_1);
            ELEMENT_HANDLERS.put("head", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("hr", HR_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("i", FontStyleElementHandler.INSTANCE_I);
            ELEMENT_HANDLERS.put("legend", StandardBlockElementHandler.INSTANCE_0_0);
            ELEMENT_HANDLERS.put("li", LI_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("menu", ListElementHandler.INSTANCE_UL);
            ELEMENT_HANDLERS.put("map", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("noframes", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("noscript", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("ol", ListElementHandler.INSTANCE_OL);
            ELEMENT_HANDLERS.put("p", StandardBlockElementHandler.INSTANCE_1_1);
            ELEMENT_HANDLERS.put("pre", PRE_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("script", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("select", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("strong", FontStyleElementHandler.INSTANCE_B);
            ELEMENT_HANDLERS.put("style", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("textarea", RemoveElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("td", TD_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("th", TD_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("tr", TR_ElementHandler.INSTANCE);
            ELEMENT_HANDLERS.put("u", FontStyleElementHandler.INSTANCE_U);
            ELEMENT_HANDLERS.put("ul", ListElementHandler.INSTANCE_UL);
        }

        private static class TR_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new TR_ElementHandler();

            private TR_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.blockBoundary(0);
                processor.appendElementContent(element);
                processor.blockBoundary(0);
            }
        }

        private static class TD_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new TD_ElementHandler();

            private TD_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                if (!processor.isStartOfBlock()) {
                    processor.append(processor.tableCellSeparator);
                }
                processor.lastCharWhiteSpace = false;
                processor.appendElementContent(element);
            }
        }

        private static class PRE_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new PRE_ElementHandler();

            private PRE_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.blockBoundary(1);
                boolean bl = processor.preformatted;
                processor.preformatted = true;
                processor.appendElementContent(element);
                processor.preformatted = bl;
                processor.blockBoundary(1);
            }
        }

        private static class LI_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new LI_ElementHandler();

            private LI_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                if (processor.listBulletNumber != -1) {
                    processor.listBulletNumber++;
                }
                processor.bullet = true;
                processor.blockBoundary(0);
                processor.appendBlockVerticalMargin();
                processor.appendIndent();
                processor.ignoreInitialWhitespace = true;
                processor.appendElementContent(element);
                processor.bullet = false;
                processor.blockBoundary(0);
            }
        }

        private static class ListElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE_OL = new ListElementHandler(0);
            public static final ElementHandler INSTANCE_UL = new ListElementHandler(-1);
            private final int initialListBulletNumber;

            public ListElementHandler(int n) {
                this.initialListBulletNumber = n;
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.blockBoundary(0);
                int n = processor.listBulletNumber;
                processor.listBulletNumber = this.initialListBulletNumber;
                processor.listIndentLevel++;
                processor.appendElementContent(element);
                processor.listIndentLevel--;
                processor.listBulletNumber = n;
                processor.blockBoundary(0);
            }
        }

        private static class HR_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new HR_ElementHandler();

            private HR_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.blockBoundary(0);
                processor.appendBlockVerticalMargin();
                for (int j = 0; j < 72; ++j) {
                    processor.append('-');
                }
                processor.blockBoundary(0);
            }
        }

        private static class BR_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new BR_ElementHandler();

            private BR_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.newLine();
                processor.blockBoundary(0);
            }
        }

        private static class A_ElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new A_ElementHandler();

            private A_ElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.appendElementContent(element);
                if (!processor.includeHyperlinkURLs) {
                    return;
                }
                String string = processor.renderer.renderHyperlinkURL(element.getStartTag());
                if (string == null) {
                    return;
                }
                int n = string.length() + 1;
                if (processor.col + n >= processor.maxLineLength) {
                    processor.startNewLine(0);
                } else {
                    processor.append(' ');
                }
                processor.append(string);
                processor.lastCharWhiteSpace = true;
            }
        }

        private static class StandardBlockElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE_0_0 = new StandardBlockElementHandler(0, 0, false);
            public static final ElementHandler INSTANCE_1_1 = new StandardBlockElementHandler(1, 1, false);
            public static final ElementHandler INSTANCE_2_1 = new StandardBlockElementHandler(2, 1, false);
            public static final ElementHandler INSTANCE_0_0_INDENT = new StandardBlockElementHandler(0, 0, true);
            public static final ElementHandler INSTANCE_1_1_INDENT = new StandardBlockElementHandler(1, 1, true);
            private final int topMargin;
            private final int bottomMargin;
            private final boolean indent;

            public StandardBlockElementHandler(int n, int n2, boolean bl) {
                this.topMargin = n;
                this.bottomMargin = n2;
                this.indent = bl;
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.blockBoundary(this.topMargin);
                if (this.indent) {
                    processor.blockIndentLevel++;
                }
                processor.appendElementContent(element);
                if (this.indent) {
                    processor.blockIndentLevel--;
                }
                processor.blockBoundary(this.bottomMargin);
            }
        }

        private static class FontStyleElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE_B = new FontStyleElementHandler('*');
            public static final ElementHandler INSTANCE_I = new FontStyleElementHandler('/');
            public static final ElementHandler INSTANCE_U = new FontStyleElementHandler('_');
            public static final ElementHandler INSTANCE_CODE = new FontStyleElementHandler('|');
            private final char decorationChar;

            public FontStyleElementHandler(char c) {
                this.decorationChar = c;
            }

            public void process(Processor processor, Element element) throws IOException {
                if (processor.decorateFontStyles) {
                    if (processor.lastCharWhiteSpace) {
                        processor.append(' ');
                        processor.lastCharWhiteSpace = false;
                    }
                    processor.append(this.decorationChar);
                    processor.appendElementContent(element);
                    if (processor.decorateFontStyles) {
                        processor.append(this.decorationChar);
                    }
                } else {
                    processor.appendElementContent(element);
                }
            }
        }

        private static class StandardInlineElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new StandardInlineElementHandler();

            private StandardInlineElementHandler() {
            }

            public void process(Processor processor, Element element) throws IOException {
                processor.appendElementContent(element);
            }
        }

        private static class RemoveElementHandler
        implements ElementHandler {
            public static final ElementHandler INSTANCE = new RemoveElementHandler();

            private RemoveElementHandler() {
            }

            public void process(Processor processor, Element element) {
            }
        }

        private static interface ElementHandler {
            public void process(Processor var1, Element var2) throws IOException;
        }
    }
}

