/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.NodeIterator;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;
    private static Map<String, AttributeIncludeChecker> map = TextExtractor.initDefaultAttributeIncludeCheckerMap();
    private static AttributeIncludeChecker ALWAYS_INCLUDE = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return true;
        }
    };
    private static AttributeIncludeChecker INCLUDE_IF_NAME_ATTRIBUTE_PRESENT = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return startTag.getAttributes().get("name") != null;
        }
    };

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        appendable.append(this.toString());
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    @Override
    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean bl) {
        this.convertNonBreakingSpaces = bl;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean bl) {
        this.includeAttributes = bl;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public boolean includeAttribute(StartTag startTag, Attribute attribute) {
        AttributeIncludeChecker attributeIncludeChecker = map.get(attribute.getKey());
        if (attributeIncludeChecker == null) {
            return false;
        }
        return attributeIncludeChecker.includeAttribute(startTag, attribute);
    }

    public TextExtractor setExcludeNonHTMLElements(boolean bl) {
        this.excludeNonHTMLElements = bl;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private static Map<String, AttributeIncludeChecker> initDefaultAttributeIncludeCheckerMap() {
        HashMap<String, AttributeIncludeChecker> hashMap = new HashMap<String, AttributeIncludeChecker>();
        hashMap.put("title", ALWAYS_INCLUDE);
        hashMap.put("alt", ALWAYS_INCLUDE);
        hashMap.put("label", ALWAYS_INCLUDE);
        hashMap.put("summary", ALWAYS_INCLUDE);
        hashMap.put("content", INCLUDE_IF_NAME_ATTRIBUTE_PRESENT);
        hashMap.put("href", ALWAYS_INCLUDE);
        return hashMap;
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean bl, boolean bl2, boolean bl3) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = bl;
            this.includeAttributes = bl2;
            this.excludeNonHTMLElements = bl3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.segment.length());
            Object object2 = new NodeIterator(this.segment);
            while (((NodeIterator)object2).hasNext()) {
                Segment segment = ((NodeIterator)object2).next();
                if (segment instanceof Tag) {
                    Tag tag = (Tag)segment;
                    if (tag.getTagType().isServerTag()) {
                        Element element = tag.getElement();
                        if (element == null || element.getEnd() <= tag.getEnd()) continue;
                        ((NodeIterator)object2).skipToPos(element.getEnd());
                        continue;
                    }
                    if (tag.getTagType() == StartTagType.NORMAL) {
                        StartTag startTag = (StartTag)tag;
                        if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                            ((NodeIterator)object2).skipToPos(startTag.getElement().getEnd());
                            continue;
                        }
                        if (this.includeAttributes) {
                            for (Attribute attribute : startTag.getAttributes()) {
                                if (!TextExtractor.this.includeAttribute(startTag, attribute)) continue;
                                stringBuilder.append(' ').append(attribute.getValueSegment()).append(' ');
                            }
                        }
                    }
                    if (tag.getName() != "br" && HTMLElements.getInlineLevelElementNames().contains(tag.getName())) continue;
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append(segment);
            }
            object2 = CharacterReference.decodeCollapseWhiteSpace(stringBuilder, this.convertNonBreakingSpaces);
            return object2;
        }
    }

    private static interface AttributeIncludeChecker {
        public boolean includeAttribute(StartTag var1, Attribute var2);
    }
}

