/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.htmlparser.jericho.Config;

public final class Util {
    private static final int BUFFER_SIZE = 2048;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        try {
            int n;
            char[] cArray = new char[2048];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = reader.read(cArray, 0, 2048)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void outputCSVLine(Writer writer, String[] stringArray) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                if (string == Config.ColumnValueTrue || string == Config.ColumnValueFalse) {
                    writer.write(string);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, string);
                    writer.write(34);
                }
            }
            if (++n == stringArray.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String string) throws IOException {
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            writer.write(c);
            if (c != '\"') continue;
            writer.write(c);
        }
    }

    static char[] getConcatenatedCharArray(String string, String string2) {
        char[] cArray = new char[string.length() + string2.length()];
        string.getChars(0, string.length(), cArray, 0);
        string2.getChars(0, string2.length(), cArray, string.length());
        return cArray;
    }
}

