/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NFAToDFAConverter;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.IntStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Interpreter;

public class DFA {
    public static final int REACHABLE_UNKNOWN = -2;
    public static final int REACHABLE_BUSY = -1;
    public static final int REACHABLE_NO = 0;
    public static final int REACHABLE_YES = 1;
    public static final int MAX_STATES_PER_ALT_IN_DFA = 450;
    public static int MAX_TIME_PER_DFA_CREATION = 1000;
    public static int MAX_STATE_TRANSITIONS_FOR_TABLE = 65534;
    public DFAState startState;
    public int decisionNumber = 0;
    public NFAState decisionNFAStartState;
    public String description;
    protected Map uniqueStates = new HashMap();
    protected Vector states = new Vector();
    protected int stateCounter = 0;
    protected int numberOfStates = 0;
    protected int user_k = -1;
    protected int max_k = -1;
    protected boolean reduced = true;
    protected boolean cyclic = false;
    protected List unreachableAlts;
    protected int nAlts = 0;
    protected DFAState[] altToAcceptState;
    protected IntSet recursiveAltSet = new IntervalSet();
    public NFA nfa;
    protected NFAToDFAConverter nfaConverter;
    public DecisionProbe probe = new DecisionProbe(this);
    protected long conversionStartTime;
    public Map edgeTransitionClassMap = new LinkedHashMap();
    protected int edgeTransitionClass = 0;
    public List specialStates;
    public List specialStateSTs;
    public Vector accept;
    public Vector eot;
    public Vector eof;
    public Vector min;
    public Vector max;
    public Vector special;
    public Vector transition;
    public Vector transitionEdgeTables;
    protected int uniqueCompressedSpecialStateNum = 0;

    public DFA(int n, NFAState nFAState) {
        this.decisionNumber = n;
        this.decisionNFAStartState = nFAState;
        this.nfa = nFAState.nfa;
        this.nAlts = this.nfa.grammar.getNumberOfAltsForDecisionNFA(nFAState);
        this.initAltRelatedInfo();
        this.nfaConverter = new NFAToDFAConverter(this);
        this.nfaConverter.convert();
        this.verify();
        if (!this.probe.isDeterministic() || this.probe.analysisAborted() || this.probe.analysisOverflowed()) {
            this.probe.issueWarnings();
        }
        this.resetStateNumbersToBeContiguous();
        if (Tool.internalOption_PrintDFA) {
            System.out.println("DFA d=" + n);
            FASerializer fASerializer = new FASerializer(this.nfa.grammar);
            String string = fASerializer.serialize(this.startState);
            System.out.println(string);
        }
    }

    public void resetStateNumbersToBeContiguous() {
        if (this.getUserMaxLookahead() > 0) {
            return;
        }
        int n = 0;
        for (int j = 0; j <= this.getMaxStateNumber(); ++j) {
            boolean bl;
            DFAState dFAState = this.getState(j);
            if (dFAState == null) continue;
            boolean bl2 = bl = dFAState.stateNumber < j;
            if (bl) continue;
            dFAState.stateNumber = n++;
        }
        if (n != this.getNumberOfStates()) {
            ErrorManager.internalError("DFA " + this.decisionNumber + ": " + this.decisionNFAStartState.getDescription() + " num unique states " + this.getNumberOfStates() + "!= num renumbered states " + n);
        }
    }

    public List getJavaCompressedAccept() {
        return this.getRunLengthEncoding(this.accept);
    }

    public List getJavaCompressedEOT() {
        return this.getRunLengthEncoding(this.eot);
    }

    public List getJavaCompressedEOF() {
        return this.getRunLengthEncoding(this.eof);
    }

    public List getJavaCompressedMin() {
        return this.getRunLengthEncoding(this.min);
    }

    public List getJavaCompressedMax() {
        return this.getRunLengthEncoding(this.max);
    }

    public List getJavaCompressedSpecial() {
        return this.getRunLengthEncoding(this.special);
    }

    public List getJavaCompressedTransition() {
        if (this.transition == null || this.transition.size() == 0) {
            return null;
        }
        ArrayList<List> arrayList = new ArrayList<List>(this.transition.size());
        for (int j = 0; j < this.transition.size(); ++j) {
            Vector vector = (Vector)this.transition.elementAt(j);
            arrayList.add(this.getRunLengthEncoding(vector));
        }
        return arrayList;
    }

    public List getRunLengthEncoding(List list) {
        int n;
        if (list == null || list.size() == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            return arrayList;
        }
        int n2 = Math.max(2, list.size() / 2);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        Integer n3 = Utils.integer(-1);
        for (int j = 0; j < list.size(); j += n) {
            Integer n4 = (Integer)list.get(j);
            if (n4 == null) {
                n4 = n3;
            }
            n = 0;
            for (int k = j; k < list.size(); ++k) {
                Integer n5 = (Integer)list.get(k);
                if (n5 == null) {
                    n5 = n3;
                }
                if (!n4.equals(n5)) break;
                ++n;
            }
            arrayList.add(DFA.encodeIntAsCharEscape((char)n));
            arrayList.add(DFA.encodeIntAsCharEscape((char)n4.intValue()));
        }
        return arrayList;
    }

    public void createStateTables(CodeGenerator codeGenerator) {
        this.description = this.getNFADecisionStartState().getDescription();
        this.description = codeGenerator.target.getTargetStringLiteralFromString(this.description);
        this.special = new Vector(this.getNumberOfStates());
        this.special.setSize(this.getNumberOfStates());
        this.specialStates = new ArrayList();
        this.specialStateSTs = new ArrayList();
        this.accept = new Vector(this.getNumberOfStates());
        this.accept.setSize(this.getNumberOfStates());
        this.eot = new Vector(this.getNumberOfStates());
        this.eot.setSize(this.getNumberOfStates());
        this.eof = new Vector(this.getNumberOfStates());
        this.eof.setSize(this.getNumberOfStates());
        this.min = new Vector(this.getNumberOfStates());
        this.min.setSize(this.getNumberOfStates());
        this.max = new Vector(this.getNumberOfStates());
        this.max.setSize(this.getNumberOfStates());
        this.transition = new Vector(this.getNumberOfStates());
        this.transition.setSize(this.getNumberOfStates());
        this.transitionEdgeTables = new Vector(this.getNumberOfStates());
        this.transitionEdgeTables.setSize(this.getNumberOfStates());
        Iterator<Object> iterator = null;
        iterator = this.getUserMaxLookahead() > 0 ? this.states.iterator() : this.getUniqueStates().values().iterator();
        while (iterator.hasNext()) {
            DFAState dFAState = (DFAState)iterator.next();
            if (dFAState == null) continue;
            if (dFAState.isAcceptState()) {
                this.accept.set(dFAState.stateNumber, Utils.integer(dFAState.getUniquelyPredictedAlt()));
                continue;
            }
            this.createMinMaxTables(dFAState);
            this.createTransitionTableEntryForState(dFAState);
            this.createSpecialTable(dFAState);
            this.createEOTAndEOFTables(dFAState);
        }
        for (int j = 0; j < this.specialStates.size(); ++j) {
            DFAState dFAState = (DFAState)this.specialStates.get(j);
            StringTemplate stringTemplate = codeGenerator.generateSpecialState(dFAState);
            this.specialStateSTs.add(stringTemplate);
        }
    }

    protected void createMinMaxTables(DFAState dFAState) {
        int n = 65535;
        int n2 = -3;
        for (int j = 0; j < dFAState.getNumberOfTransitions(); ++j) {
            Transition transition = dFAState.transition(j);
            Label label2 = transition.label;
            if (label2.isAtom()) {
                if (label2.getAtom() < 0) continue;
                if (label2.getAtom() < n) {
                    n = label2.getAtom();
                }
                if (label2.getAtom() <= n2) continue;
                n2 = label2.getAtom();
                continue;
            }
            if (!label2.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label2.getSet();
            int n3 = intervalSet.getMinElement();
            if (n3 < n && n3 >= 0) {
                n = intervalSet.getMinElement();
            }
            if (intervalSet.getMaxElement() <= n2) continue;
            n2 = intervalSet.getMaxElement();
        }
        if (n2 < 0) {
            n = 0;
            n2 = 0;
        }
        this.min.set(dFAState.stateNumber, Utils.integer((char)n));
        this.max.set(dFAState.stateNumber, Utils.integer((char)n2));
        if (n2 < 0 || n > 65534 || n < 0) {
            ErrorManager.internalError("messed up: min=" + this.min + ", max=" + this.max);
        }
    }

    protected void createTransitionTableEntryForState(DFAState dFAState) {
        int n = (Integer)this.max.get(dFAState.stateNumber);
        int n2 = (Integer)this.min.get(dFAState.stateNumber);
        Vector<Integer> vector = new Vector<Integer>(n - n2 + 1);
        vector.setSize(n - n2 + 1);
        this.transition.set(dFAState.stateNumber, vector);
        for (int j = 0; j < dFAState.getNumberOfTransitions(); ++j) {
            Transition transition = dFAState.transition(j);
            Label label2 = transition.label;
            if (label2.isAtom() && label2.getAtom() >= 0) {
                int n3 = label2.getAtom() - n2;
                vector.set(n3, Utils.integer(transition.target.stateNumber));
                continue;
            }
            if (!label2.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label2.getSet();
            int[] nArray = intervalSet.toArray();
            for (int k = 0; k < nArray.length; ++k) {
                if (nArray[k] < 0) continue;
                int n4 = nArray[k] - n2;
                vector.set(n4, Utils.integer(transition.target.stateNumber));
            }
        }
        Integer n5 = (Integer)this.edgeTransitionClassMap.get(vector);
        if (n5 != null) {
            this.transitionEdgeTables.set(dFAState.stateNumber, n5);
        } else {
            n5 = Utils.integer(this.edgeTransitionClass);
            this.transitionEdgeTables.set(dFAState.stateNumber, n5);
            this.edgeTransitionClassMap.put(vector, n5);
            ++this.edgeTransitionClass;
        }
    }

    protected void createEOTAndEOFTables(DFAState dFAState) {
        for (int j = 0; j < dFAState.getNumberOfTransitions(); ++j) {
            Transition transition = dFAState.transition(j);
            Label label2 = transition.label;
            if (label2.isAtom()) {
                if (label2.getAtom() == -2) {
                    this.eot.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                    continue;
                }
                if (label2.getAtom() != -1) continue;
                this.eof.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                continue;
            }
            if (!label2.isSet()) continue;
            IntervalSet intervalSet = (IntervalSet)label2.getSet();
            int[] nArray = intervalSet.toArray();
            for (int k = 0; k < nArray.length; ++k) {
                if (nArray[k] == -2) {
                    this.eot.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
                    continue;
                }
                if (nArray[k] != -1) continue;
                this.eof.set(dFAState.stateNumber, Utils.integer(transition.target.stateNumber));
            }
        }
    }

    protected void createSpecialTable(DFAState dFAState) {
        int n;
        boolean bl = false;
        for (n = 0; n < dFAState.getNumberOfTransitions(); ++n) {
            Transition transition = dFAState.transition(n);
            Label label2 = transition.label;
            if (!label2.isSemanticPredicate() && ((DFAState)transition.target).getGatedPredicatesInNFAConfigurations() == null) continue;
            bl = true;
            break;
        }
        n = (Integer)this.max.get(dFAState.stateNumber);
        int n2 = (Integer)this.min.get(dFAState.stateNumber);
        if (bl || n - n2 > MAX_STATE_TRANSITIONS_FOR_TABLE) {
            this.special.set(dFAState.stateNumber, Utils.integer(this.uniqueCompressedSpecialStateNum));
            ++this.uniqueCompressedSpecialStateNum;
            this.specialStates.add(dFAState);
        } else {
            this.special.set(dFAState.stateNumber, Utils.integer(-1));
        }
    }

    public static String encodeIntAsCharEscape(int n) {
        if (n <= 127) {
            return "\\" + Integer.toOctalString(n);
        }
        String string = Integer.toHexString(n | 0x10000).substring(1, 5);
        return "\\u" + string;
    }

    public int predict(IntStream intStream) {
        Interpreter interpreter = new Interpreter(this.nfa.grammar, intStream);
        return interpreter.predict(this);
    }

    protected DFAState addState(DFAState dFAState) {
        if (this.getUserMaxLookahead() > 0) {
            return dFAState;
        }
        DFAState dFAState2 = (DFAState)this.uniqueStates.get(dFAState);
        if (dFAState2 != null) {
            return dFAState2;
        }
        this.uniqueStates.put(dFAState, dFAState);
        ++this.numberOfStates;
        return dFAState;
    }

    public void removeState(DFAState dFAState) {
        DFAState dFAState2 = (DFAState)this.uniqueStates.remove(dFAState);
        if (dFAState2 != null) {
            --this.numberOfStates;
        }
    }

    public Map getUniqueStates() {
        return this.uniqueStates;
    }

    public int getMaxStateNumber() {
        return this.states.size() - 1;
    }

    public DFAState getState(int n) {
        return (DFAState)this.states.get(n);
    }

    public void setState(int n, DFAState dFAState) {
        this.states.set(n, dFAState);
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public boolean isCyclic() {
        return this.cyclic && this.getUserMaxLookahead() == 0;
    }

    public boolean canInlineDecision() {
        return CodeGenerator.GEN_ACYCLIC_DFA_INLINE && !this.isCyclic() && !this.probe.isNonLLStarDecision();
    }

    public boolean isTokensRuleDecision() {
        if (this.nfa.grammar.type != 1) {
            return false;
        }
        NFAState nFAState = this.getNFADecisionStartState();
        NFAState nFAState2 = this.nfa.grammar.getRuleStartState("Tokens");
        NFAState nFAState3 = (NFAState)nFAState2.transition((int)0).target;
        return nFAState == nFAState3;
    }

    public int getUserMaxLookahead() {
        if (this.user_k >= 0) {
            return this.user_k;
        }
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        Object object2 = grammarAST.getOption("k");
        if (object2 == null) {
            this.user_k = this.nfa.grammar.getGrammarMaxLookahead();
            return this.user_k;
        }
        if (object2 instanceof Integer) {
            Integer n = (Integer)object2;
            this.user_k = n;
        } else if (object2.equals("*")) {
            this.user_k = 0;
        }
        return this.user_k;
    }

    public boolean getAutoBacktrackMode() {
        String string = (String)this.decisionNFAStartState.getAssociatedASTNode().getOption("backtrack");
        if (string == null) {
            string = (String)this.nfa.grammar.getOption("backtrack");
        }
        return string != null && string.equals("true");
    }

    public void setUserMaxLookahead(int n) {
        this.user_k = n;
    }

    public int getMaxLookaheadDepth() {
        if (this.isCyclic()) {
            return Integer.MAX_VALUE;
        }
        return this.max_k;
    }

    public List getUnreachableAlts() {
        return this.unreachableAlts;
    }

    public void verify() {
        if (!this.probe.nonLLStarDecision) {
            this.doesStateReachAcceptState(this.startState);
        }
    }

    protected boolean doesStateReachAcceptState(DFAState dFAState) {
        if (dFAState.isAcceptState()) {
            dFAState.setAcceptStateReachable(1);
            int n = dFAState.getUniquelyPredictedAlt();
            this.unreachableAlts.remove(Utils.integer(n));
            return true;
        }
        dFAState.setAcceptStateReachable(-1);
        boolean bl = false;
        for (int j = 0; j < dFAState.getNumberOfTransitions(); ++j) {
            Transition transition = dFAState.transition(j);
            DFAState dFAState2 = (DFAState)transition.target;
            int n = dFAState2.getAcceptStateReachable();
            if (n == -1) {
                this.cyclic = true;
                continue;
            }
            if (n == 1) {
                bl = true;
                continue;
            }
            if (n == 0 || !this.doesStateReachAcceptState(dFAState2)) continue;
            bl = true;
        }
        if (bl) {
            dFAState.setAcceptStateReachable(1);
        } else {
            dFAState.setAcceptStateReachable(0);
            this.reduced = false;
        }
        return bl;
    }

    public NFAState getNFADecisionStartState() {
        return this.decisionNFAStartState;
    }

    public DFAState getAcceptState(int n) {
        return this.altToAcceptState[n];
    }

    public void setAcceptState(int n, DFAState dFAState) {
        this.altToAcceptState[n] = dFAState;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDecisionNumber() {
        return this.decisionNFAStartState.getDecisionNumber();
    }

    public GrammarAST getDecisionASTNode() {
        return this.decisionNFAStartState.getAssociatedASTNode();
    }

    public boolean isGreedy() {
        GrammarAST grammarAST = this.nfa.grammar.getDecisionBlockAST(this.decisionNumber);
        String string = (String)grammarAST.getOption("greedy");
        return string == null || !string.equals("false");
    }

    public DFAState newState() {
        DFAState dFAState = new DFAState(this);
        dFAState.stateNumber = this.stateCounter++;
        this.states.setSize(dFAState.stateNumber + 1);
        this.states.set(dFAState.stateNumber, dFAState);
        return dFAState;
    }

    public int getNumberOfStates() {
        if (this.getUserMaxLookahead() > 0) {
            return this.states.size();
        }
        return this.numberOfStates;
    }

    public int getNumberOfAlts() {
        return this.nAlts;
    }

    public boolean analysisAborted() {
        return this.probe.analysisAborted();
    }

    protected void initAltRelatedInfo() {
        this.unreachableAlts = new LinkedList();
        for (int j = 1; j <= this.nAlts; ++j) {
            this.unreachableAlts.add(Utils.integer(j));
        }
        this.altToAcceptState = new DFAState[this.nAlts + 1];
    }

    public String toString() {
        FASerializer fASerializer = new FASerializer(this.nfa.grammar);
        if (this.startState == null) {
            return "";
        }
        return fASerializer.serialize(this.startState, false);
    }
}

