/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class RecognitionException
extends Exception {
    public transient IntStream input;
    public int index;
    public Token token;
    public Object node;
    public int c;
    public int line;
    public int charPositionInLine;
    public boolean approximateLineInfo;

    public RecognitionException() {
    }

    public RecognitionException(IntStream intStream) {
        this.input = intStream;
        this.index = intStream.index();
        if (intStream instanceof TokenStream) {
            this.token = ((TokenStream)intStream).LT(1);
            this.line = this.token.getLine();
            this.charPositionInLine = this.token.getCharPositionInLine();
        }
        if (intStream instanceof TreeNodeStream) {
            this.extractInformationFromTreeNodeStream(intStream);
        } else if (intStream instanceof CharStream) {
            this.c = intStream.LA(1);
            this.line = ((CharStream)intStream).getLine();
            this.charPositionInLine = ((CharStream)intStream).getCharPositionInLine();
        } else {
            this.c = intStream.LA(1);
        }
    }

    protected void extractInformationFromTreeNodeStream(IntStream intStream) {
        TreeNodeStream treeNodeStream = (TreeNodeStream)intStream;
        this.node = treeNodeStream.LT(1);
        TreeAdaptor treeAdaptor = treeNodeStream.getTreeAdaptor();
        Token token = treeAdaptor.getToken(this.node);
        if (token != null) {
            this.token = token;
            if (token.getLine() <= 0) {
                int n = -1;
                Object object2 = treeNodeStream.LT(n);
                while (object2 != null) {
                    Token token2 = treeAdaptor.getToken(object2);
                    if (token2 != null && token2.getLine() > 0) {
                        this.line = token2.getLine();
                        this.charPositionInLine = token2.getCharPositionInLine();
                        this.approximateLineInfo = true;
                        break;
                    }
                    object2 = treeNodeStream.LT(--n);
                }
            } else {
                this.line = token.getLine();
                this.charPositionInLine = token.getCharPositionInLine();
            }
        } else if (this.node instanceof Tree) {
            this.line = ((Tree)this.node).getLine();
            this.charPositionInLine = ((Tree)this.node).getCharPositionInLine();
            if (this.node instanceof CommonTree) {
                this.token = ((CommonTree)this.node).token;
            }
        } else {
            int n = treeAdaptor.getType(this.node);
            String string = treeAdaptor.getText(this.node);
            this.token = new CommonToken(n, string);
        }
    }

    public int getUnexpectedType() {
        if (this.input instanceof TokenStream) {
            return this.token.getType();
        }
        if (this.input instanceof TreeNodeStream) {
            TreeNodeStream treeNodeStream = (TreeNodeStream)this.input;
            TreeAdaptor treeAdaptor = treeNodeStream.getTreeAdaptor();
            return treeAdaptor.getType(this.node);
        }
        return this.c;
    }
}

