/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] nArray) {
        int n = nArray.length;
        if (n <= 1) {
            return 0.0;
        }
        double d = Stats.avg(nArray);
        double d2 = 0.0;
        for (int j = 0; j < n; ++j) {
            d2 += ((double)nArray[j] - d) * ((double)nArray[j] - d);
        }
        return Math.sqrt(d2 /= (double)(n - 1));
    }

    public static double avg(int[] nArray) {
        double d = 0.0;
        int n = nArray.length;
        if (n == 0) {
            return 0.0;
        }
        for (int j = 0; j < n; ++j) {
            d += (double)nArray[j];
        }
        if (d >= 0.0) {
            return d / (double)n;
        }
        return 0.0;
    }

    public static int min(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int j = 0; j < n2; ++j) {
            if (nArray[j] >= n) continue;
            n = nArray[j];
        }
        return n;
    }

    public static int max(int[] nArray) {
        int n = Integer.MIN_VALUE;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int j = 0; j < n2; ++j) {
            if (nArray[j] <= n) continue;
            n = nArray[j];
        }
        return n;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        for (int j = 0; j < n2; ++j) {
            n += nArray[j];
        }
        return n;
    }

    public static void writeReport(String string, String string2) throws IOException {
        String string3 = Stats.getAbsoluteFileName(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        file2.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        printStream.println(string2);
        printStream.close();
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public static String getAbsoluteFileName(String string) {
        return System.getProperty("user.home") + File.separator + ANTLRWORKS_DIR + File.separator + string;
    }
}

