/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;

public class CommonTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected int[] calls;
    protected int _sp = -1;
    protected Map tokenTypeToStreamIndexesMap;
    public static final Set INDEX_ALL = new HashSet();
    protected Set tokenTypesToReverseIndex = null;

    public CommonTreeNodeStream(Object object2) {
        this(new CommonTreeAdaptor(), object2);
    }

    public CommonTreeNodeStream(TreeAdaptor treeAdaptor, Object object2) {
        this(treeAdaptor, object2, 100);
    }

    public CommonTreeNodeStream(TreeAdaptor treeAdaptor, Object object2, int n) {
        this.root = object2;
        this.adaptor = treeAdaptor;
        this.nodes = new ArrayList(n);
        this.down = treeAdaptor.create(2, "DOWN");
        this.up = treeAdaptor.create(3, "UP");
        this.eof = treeAdaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    protected void fillBuffer(Object object2) {
        boolean bl = this.adaptor.isNil(object2);
        if (!bl) {
            this.nodes.add(object2);
            this.fillReverseIndex(object2, this.nodes.size() - 1);
        }
        int n = this.adaptor.getChildCount(object2);
        if (!bl && n > 0) {
            this.addNavigationNode(2);
        }
        for (int j = 0; j < n; ++j) {
            Object object3 = this.adaptor.getChild(object2, j);
            this.fillBuffer(object3);
        }
        if (!bl && n > 0) {
            this.addNavigationNode(3);
        }
    }

    protected void fillReverseIndex(Object object2, int n) {
        if (this.tokenTypesToReverseIndex == null) {
            return;
        }
        if (this.tokenTypeToStreamIndexesMap == null) {
            this.tokenTypeToStreamIndexesMap = new HashMap();
        }
        int n2 = this.adaptor.getType(object2);
        Integer n3 = new Integer(n2);
        if (this.tokenTypesToReverseIndex != INDEX_ALL && !this.tokenTypesToReverseIndex.contains(n3)) {
            return;
        }
        Integer n4 = new Integer(n);
        ArrayList<Integer> arrayList = (ArrayList<Integer>)this.tokenTypeToStreamIndexesMap.get(n3);
        if (arrayList == null) {
            arrayList = new ArrayList<Integer>();
            arrayList.add(n4);
            this.tokenTypeToStreamIndexesMap.put(n3, arrayList);
        } else if (!arrayList.contains(n4)) {
            arrayList.add(n4);
        }
    }

    public void reverseIndex(int n) {
        if (this.tokenTypesToReverseIndex == null) {
            this.tokenTypesToReverseIndex = new HashSet();
        } else if (this.tokenTypesToReverseIndex == INDEX_ALL) {
            return;
        }
        this.tokenTypesToReverseIndex.add(new Integer(n));
    }

    public void reverseIndex(Set set) {
        this.tokenTypesToReverseIndex = set;
    }

    public int getNodeIndex(Object object2) {
        if (this.tokenTypeToStreamIndexesMap == null) {
            return this.getNodeIndexLinearly(object2);
        }
        int n = this.adaptor.getType(object2);
        Integer n2 = new Integer(n);
        ArrayList arrayList = (ArrayList)this.tokenTypeToStreamIndexesMap.get(n2);
        if (arrayList == null) {
            return this.getNodeIndexLinearly(object2);
        }
        for (int j = 0; j < arrayList.size(); ++j) {
            Integer n3 = (Integer)arrayList.get(j);
            Object object3 = this.get(n3);
            if (object3 != object2) continue;
            return n3;
        }
        return -1;
    }

    protected int getNodeIndexLinearly(Object object2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int j = 0; j < this.nodes.size(); ++j) {
            Object e = this.nodes.get(j);
            if (e != object2) continue;
            return j;
        }
        return -1;
    }

    protected void addNavigationNode(int n) {
        Object object2 = null;
        object2 = n == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(object2);
    }

    public Object get(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(n);
    }

    public Object LT(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        if (this.p + n - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + n - 1);
    }

    protected Object LB(int n) {
        if (n == 0) {
            return null;
        }
        if (this.p - n < 0) {
            return null;
        }
        return this.nodes.get(this.p - n);
    }

    public Object getTreeSource() {
        return this.root;
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.tokens = tokenStream;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean bl) {
        this.uniqueNavigationNodes = bl;
    }

    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    public int LA(int n) {
        return this.adaptor.getType(this.LT(n));
    }

    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int n) {
    }

    public int index() {
        return this.p;
    }

    public void rewind(int n) {
        this.seek(n);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int n) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = n;
    }

    public void push(int n) {
        if (this.calls == null) {
            this.calls = new int[10];
        } else if (this._sp + 1 >= this.calls.length) {
            int[] nArray = new int[this.calls.length * 2];
            System.arraycopy(this.calls, 0, nArray, 0, this.calls.length);
            this.calls = nArray;
        }
        this.calls[++this._sp] = this.p;
        this.seek(n);
    }

    public int pop() {
        int n = this.calls[this._sp--];
        this.seek(n);
        return n;
    }

    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    public String toString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < this.nodes.size(); ++j) {
            Object e = this.nodes.get(j);
            stringBuffer.append(" ");
            stringBuffer.append(this.adaptor.getType(e));
        }
        return stringBuffer.toString();
    }

    public String toString(Object object2, Object object3) {
        String string;
        int n;
        if (object2 == null || object3 == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        System.out.println("stop: " + object3);
        if (object2 instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)object2).getToken() + ", ");
        } else {
            System.out.println(object2);
        }
        if (object3 instanceof CommonTree) {
            System.out.println(((CommonTree)object3).getToken());
        } else {
            System.out.println(object3);
        }
        if (this.tokens != null) {
            int n2 = this.adaptor.getTokenStartIndex(object2);
            int n3 = this.adaptor.getTokenStopIndex(object3);
            if (this.adaptor.getType(object3) == 3) {
                n3 = this.adaptor.getTokenStopIndex(object2);
            } else if (this.adaptor.getType(object3) == -1) {
                n3 = this.size() - 2;
            }
            return this.tokens.toString(n2, n3);
        }
        Object var3_4 = null;
        for (n = 0; n < this.nodes.size() && (var3_4 = this.nodes.get(n)) != object2; ++n) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        var3_4 = this.nodes.get(n);
        while (var3_4 != object3) {
            string = this.adaptor.getText(var3_4);
            if (string == null) {
                string = " " + String.valueOf(this.adaptor.getType(var3_4));
            }
            stringBuffer.append(string);
            var3_4 = this.nodes.get(++n);
        }
        string = this.adaptor.getText(object3);
        if (string == null) {
            string = " " + String.valueOf(this.adaptor.getType(object3));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected class StreamIterator
    implements Iterator {
        int i = 0;

        protected StreamIterator() {
        }

        public boolean hasNext() {
            return this.i < CommonTreeNodeStream.this.nodes.size();
        }

        public Object next() {
            int n;
            if ((n = this.i++) < CommonTreeNodeStream.this.nodes.size()) {
                return CommonTreeNodeStream.this.nodes.get(n);
            }
            return CommonTreeNodeStream.this.eof;
        }

        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

