/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.HashMap;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.stringtemplate.StringTemplate;

public class DOTTreeGenerator {
    public static StringTemplate _treeST = new StringTemplate("digraph {\n  ordering=out;\n  ranksep=.4;\n  node [shape=plaintext, fixedsize=true, fontsize=11, fontname=\"Courier\",\n        width=.25, height=.25];\n  edge [arrowsize=.5]\n  $nodes$\n  $edges$\n}\n");
    public static StringTemplate _nodeST = new StringTemplate("$name$ [label=\"$text$\"];\n");
    public static StringTemplate _edgeST = new StringTemplate("$parent$ -> $child$ // \"$parentText$\" -> \"$childText$\"\n");
    HashMap nodeToNumberMap = new HashMap();
    int nodeNumber = 0;

    public StringTemplate toDOT(Object object2, TreeAdaptor treeAdaptor, StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        StringTemplate stringTemplate3 = stringTemplate.getInstanceOf();
        this.nodeNumber = 0;
        this.toDOTDefineNodes(object2, treeAdaptor, stringTemplate3);
        this.nodeNumber = 0;
        this.toDOTDefineEdges(object2, treeAdaptor, stringTemplate3);
        return stringTemplate3;
    }

    public StringTemplate toDOT(Object object2, TreeAdaptor treeAdaptor) {
        return this.toDOT(object2, treeAdaptor, _treeST, _edgeST);
    }

    public StringTemplate toDOT(Tree tree) {
        return this.toDOT(tree, new CommonTreeAdaptor());
    }

    protected void toDOTDefineNodes(Object object2, TreeAdaptor treeAdaptor, StringTemplate stringTemplate) {
        if (object2 == null) {
            return;
        }
        int n = treeAdaptor.getChildCount(object2);
        if (n == 0) {
            return;
        }
        StringTemplate stringTemplate2 = this.getNodeST(treeAdaptor, object2);
        stringTemplate.setAttribute("nodes", stringTemplate2);
        for (int j = 0; j < n; ++j) {
            Object object3 = treeAdaptor.getChild(object2, j);
            StringTemplate stringTemplate3 = this.getNodeST(treeAdaptor, object3);
            stringTemplate.setAttribute("nodes", stringTemplate3);
            this.toDOTDefineNodes(object3, treeAdaptor, stringTemplate);
        }
    }

    protected void toDOTDefineEdges(Object object2, TreeAdaptor treeAdaptor, StringTemplate stringTemplate) {
        if (object2 == null) {
            return;
        }
        int n = treeAdaptor.getChildCount(object2);
        if (n == 0) {
            return;
        }
        String string = "n" + this.getNodeNumber(object2);
        String string2 = treeAdaptor.getText(object2);
        for (int j = 0; j < n; ++j) {
            Object object3 = treeAdaptor.getChild(object2, j);
            String string3 = treeAdaptor.getText(object3);
            String string4 = "n" + this.getNodeNumber(object3);
            StringTemplate stringTemplate2 = _edgeST.getInstanceOf();
            stringTemplate2.setAttribute("parent", string);
            stringTemplate2.setAttribute("child", string4);
            stringTemplate2.setAttribute("parentText", string2);
            stringTemplate2.setAttribute("childText", string3);
            stringTemplate.setAttribute("edges", stringTemplate2);
            this.toDOTDefineEdges(object3, treeAdaptor, stringTemplate);
        }
    }

    protected StringTemplate getNodeST(TreeAdaptor treeAdaptor, Object object2) {
        String string = treeAdaptor.getText(object2);
        StringTemplate stringTemplate = _nodeST.getInstanceOf();
        String string2 = "n" + this.getNodeNumber(object2);
        stringTemplate.setAttribute("name", string2);
        if (string != null) {
            string = string.replaceAll("\"", "\\\\\"");
        }
        stringTemplate.setAttribute("text", string);
        return stringTemplate;
    }

    protected int getNodeNumber(Object object2) {
        Integer n = (Integer)this.nodeToNumberMap.get(object2);
        if (n != null) {
            return n;
        }
        this.nodeToNumberMap.put(object2, new Integer(this.nodeNumber));
        ++this.nodeNumber;
        return this.nodeNumber - 1;
    }
}

