/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateWriter;

public class AutoIndentWriter
implements StringTemplateWriter {
    public static final String newline = System.getProperty("line.separator");
    protected List indents = new ArrayList();
    protected int[] anchors = new int[10];
    protected int anchors_sp = -1;
    protected Writer out = null;
    protected boolean atStartOfLine = true;
    protected int charPosition = 0;
    protected int lineWidth = -1;
    protected int charPositionOfStartOfExpr = 0;

    public AutoIndentWriter(Writer writer) {
        this.out = writer;
        this.indents.add(null);
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void pushIndentation(String string) {
        this.indents.add(string);
    }

    public String popIndentation() {
        return (String)this.indents.remove(this.indents.size() - 1);
    }

    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] nArray = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, nArray, 0, this.anchors.length - 1);
            this.anchors = nArray;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int getIndentationWidth() {
        int n = 0;
        for (int j = 0; j < this.indents.size(); ++j) {
            String string = (String)this.indents.get(j);
            if (string == null) continue;
            n += string.length();
        }
        return n;
    }

    public int write(String string) throws IOException {
        int n = 0;
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (c == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -1;
            } else if (this.atStartOfLine) {
                n += this.indent();
                this.atStartOfLine = false;
            }
            ++n;
            this.out.write(c);
            ++this.charPosition;
        }
        return n;
    }

    public int writeSeparator(String string) throws IOException {
        return this.write(string);
    }

    public int write(String string, String string2) throws IOException {
        int n = this.writeWrapSeparator(string2);
        return n + this.write(string);
    }

    public int writeWrapSeparator(String string) throws IOException {
        int n = 0;
        if (this.lineWidth != -1 && string != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == '\n') {
                    ++n;
                    this.out.write(c);
                    this.charPosition = 0;
                    int n2 = this.getIndentationWidth();
                    int n3 = 0;
                    if (this.anchors_sp >= 0) {
                        n3 = this.anchors[this.anchors_sp];
                    }
                    if (n3 > n2) {
                        n += this.indent(n3);
                        continue;
                    }
                    n += this.indent();
                    continue;
                }
                ++n;
                this.out.write(c);
                ++this.charPosition;
            }
        }
        return n;
    }

    public int indent() throws IOException {
        int n = 0;
        for (int j = 0; j < this.indents.size(); ++j) {
            String string = (String)this.indents.get(j);
            if (string == null) continue;
            n += string.length();
            this.out.write(string);
        }
        this.charPosition += n;
        return n;
    }

    public int indent(int n) throws IOException {
        for (int j = 1; j <= n; ++j) {
            this.out.write(32);
        }
        this.charPosition += n;
        return n;
    }
}

