/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.List;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.RevisionVisitor;

public class ChangeDelta
extends Delta {
    ChangeDelta() {
    }

    public ChangeDelta(Chunk orig, Chunk rev) {
        this.init(orig, rev);
    }

    public void verify(List target) throws PatchFailedException {
        if (!this.original.verify(target)) {
            throw new PatchFailedException();
        }
        if (this.original.first() > target.size()) {
            throw new PatchFailedException("original.first() > target.size()");
        }
    }

    public void applyTo(List target) {
        this.original.applyDelete(target);
        this.revised.applyAdd(this.original.first(), target);
    }

    public void toString(StringBuffer s2) {
        this.original.rangeString(s2);
        s2.append("c");
        this.revised.rangeString(s2);
        s2.append(Diff.NL);
        this.original.toString(s2, "< ", "\n");
        s2.append("---");
        s2.append(Diff.NL);
        this.revised.toString(s2, "> ", "\n");
    }

    public void toRCSString(StringBuffer s2, String EOL) {
        s2.append("d");
        s2.append(this.original.rcsfrom());
        s2.append(" ");
        s2.append(this.original.size());
        s2.append(EOL);
        s2.append("a");
        s2.append(this.original.rcsto());
        s2.append(" ");
        s2.append(this.revised.size());
        s2.append(EOL);
        this.revised.toString(s2, "", EOL);
    }

    public void accept(RevisionVisitor visitor) {
        visitor.visit(this);
    }
}

