/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.wiki.test.util.WikiTestUtil;

public class WikiPageTrashHandlerTestUtil {
    private static final int _NODE_NAME_MAX_LENGTH = 75;
    private static final String _PAGE_TITLE = RandomTestUtil.randomString((int)255, (RandomizerBumper[])new RandomizerBumper[0]);

    public static BaseModel<?> addBaseModelWithWorkflow(BaseModel<?> parentBaseModel, boolean approved, ServiceContext serviceContext) throws Exception {
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setWorkflowAction(2);
        return WikiTestUtil.addPage(TestPropsValues.getUserId(), serviceContext.getScopeGroupId(), (Long)parentBaseModel.getPrimaryKeyObj(), WikiPageTrashHandlerTestUtil.getSearchKeywords(), approved);
    }

    public static BaseModel<?> getBaseModel(long primaryKey) throws Exception {
        return WikiPageLocalServiceUtil.getPageByPageId((long)primaryKey);
    }

    public static Class<?> getBaseModelClass() {
        return WikiPage.class;
    }

    public static String getBaseModelName(ClassedModel classedModel) {
        WikiPage page = (WikiPage)classedModel;
        return page.getTitle();
    }

    public static int getNotInTrashBaseModelsCount(BaseModel<?> parentBaseModel) throws Exception {
        return WikiPageLocalServiceUtil.getPagesCount((long)((Long)parentBaseModel.getPrimaryKeyObj()), (boolean)true, (int)-1);
    }

    public static BaseModel<?> getParentBaseModel(Group group, ServiceContext serviceContext) throws Exception {
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setWorkflowAction(0);
        return WikiNodeLocalServiceUtil.addNode((long)TestPropsValues.getUserId(), (String)RandomTestUtil.randomString((int)75, (RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (ServiceContext)serviceContext);
    }

    public static String getSearchKeywords() {
        return _PAGE_TITLE;
    }

    public static long getTrashEntryClassPK(ClassedModel classedModel) {
        WikiPage page = (WikiPage)classedModel;
        return page.getResourcePrimKey();
    }

    public static void moveBaseModelToTrash(long primaryKey) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPageByPageId((long)primaryKey);
        WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)page.getNodeId(), (String)page.getTitle());
    }

    public static void moveParentBaseModelToTrash(long primaryKey) throws Exception {
        WikiNodeLocalServiceUtil.moveNodeToTrash((long)TestPropsValues.getUserId(), (long)primaryKey);
    }

    public static BaseModel<?> updateBaseModel(long primaryKey, ServiceContext serviceContext) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPageByPageId((long)primaryKey);
        serviceContext = (ServiceContext)serviceContext.clone();
        return WikiPageLocalServiceUtil.updatePage((long)TestPropsValues.getUserId(), (long)page.getNodeId(), (String)page.getTitle(), (double)page.getVersion(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)false, (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
    }
}

