/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.test.util;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.test.log.LogCapture;
import com.liferay.portal.test.log.LoggerTestUtil;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Map;

public class WikiTestUtil {
    public static WikiNode addDefaultNode(long groupId) throws Exception {
        WorkflowThreadLocal.setEnabled((boolean)true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        serviceContext.setWorkflowAction(2);
        serviceContext = (ServiceContext)serviceContext.clone();
        return WikiNodeLocalServiceUtil.addDefaultNode((long)TestPropsValues.getUserId(), (ServiceContext)serviceContext);
    }

    public static WikiNode addNode(long groupId) throws Exception {
        return WikiTestUtil.addNode(TestPropsValues.getUserId(), groupId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((int)50, (RandomizerBumper[])new RandomizerBumper[0]));
    }

    public static WikiNode addNode(long userId, long groupId, String name, String description) throws Exception {
        WorkflowThreadLocal.setEnabled((boolean)true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        serviceContext.setWorkflowAction(2);
        serviceContext = (ServiceContext)serviceContext.clone();
        return WikiNodeLocalServiceUtil.addNode((long)userId, (String)name, (String)description, (ServiceContext)serviceContext);
    }

    public static WikiPage addPage(long groupId, long nodeId, boolean approved) throws Exception {
        return WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), approved);
    }

    public static WikiPage addPage(long userId, long groupId, long nodeId, String title, boolean approved) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        serviceContext.setCommand("add");
        serviceContext.setLayoutFullURL("http://localhost");
        return WikiTestUtil.addPage(userId, nodeId, title, "content", approved, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiPage addPage(long userId, long nodeId, String title, String content, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            WikiPage page = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)title, (String)content, (String)"Summary", (boolean)false, (ServiceContext)serviceContext);
            if (approved) {
                page = WikiTestUtil.updateStatus(page, serviceContext);
            }
            WikiPage wikiPage = page;
            return wikiPage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiPage addPage(long userId, long nodeId, String title, String content, String parentTitle, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setCommand("add");
            serviceContext.setWorkflowAction(2);
            WikiPage page = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)title, (double)1.0, (String)content, (String)"Summary", (boolean)false, (String)"creole", (boolean)true, (String)parentTitle, null, (ServiceContext)serviceContext);
            if (approved) {
                page = WikiTestUtil.updateStatus(page, serviceContext);
            }
            WikiPage wikiPage = page;
            return wikiPage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public static WikiPage[] addPageWithChangedParentPage(long groupId, long nodeId) throws Exception {
        WikiPage initialParentPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        WikiPage childPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), initialParentPage.getTitle(), true, serviceContext);
        WikiPage finalParentPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), true);
        WikiPageLocalServiceUtil.changeParent((long)TestPropsValues.getUserId(), (long)nodeId, (String)childPage.getTitle(), (String)finalParentPage.getTitle(), (ServiceContext)serviceContext);
        childPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)childPage.getTitle());
        initialParentPage = WikiPageLocalServiceUtil.getPageByPageId((long)initialParentPage.getPageId());
        finalParentPage = WikiPageLocalServiceUtil.getPageByPageId((long)finalParentPage.getPageId());
        return new WikiPage[]{childPage, finalParentPage, initialParentPage};
    }

    public static WikiPage[] addPageWithChildPageAndRedirectPage(long groupId, long nodeId) throws Exception {
        WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, "TestPage", true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, "TestChildPage", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "TestPage", true, serviceContext);
        WikiPageLocalServiceUtil.renamePage((long)TestPropsValues.getUserId(), (long)nodeId, (String)"TestPage", (String)"B", (ServiceContext)serviceContext);
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"B");
        WikiPage childPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"TestChildPage");
        WikiPage redirectPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"TestPage");
        return new WikiPage[]{page, childPage, redirectPage};
    }

    public static WikiPage[] addRenamedParentPageWithChildPageAndGrandchildPage(long groupId, long nodeId) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, "TestPage", true);
        WikiPage childPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, "TestChildPage", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "TestPage", true, serviceContext);
        WikiPage grandchildPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, "TestGrandchildPage", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "TestChildPage", true, serviceContext);
        WikiPageLocalServiceUtil.renamePage((long)TestPropsValues.getUserId(), (long)nodeId, (String)"TestPage", (String)"B", (ServiceContext)serviceContext);
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"B");
        WikiPage redirectPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"TestPage");
        childPage = WikiPageLocalServiceUtil.getPageByPageId((long)childPage.getPageId());
        grandchildPage = WikiPageLocalServiceUtil.getPageByPageId((long)grandchildPage.getPageId());
        return new WikiPage[]{page, redirectPage, childPage, grandchildPage};
    }

    public static WikiPage[] addRenamedTrashedPage(long groupId, long nodeId, boolean explicitlyRemoveRedirectPage) throws Exception {
        WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, "A", true);
        WikiPageLocalServiceUtil.renamePage((long)TestPropsValues.getUserId(), (long)nodeId, (String)"A", (String)"B", (ServiceContext)ServiceContextTestUtil.getServiceContext((long)groupId));
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"B");
        WikiPage redirectPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"A");
        if (explicitlyRemoveRedirectPage) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)nodeId, (String)"A");
        }
        WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)nodeId, (String)"B");
        page = WikiPageLocalServiceUtil.getPageByPageId((long)page.getPageId());
        redirectPage = WikiPageLocalServiceUtil.getPageByPageId((long)redirectPage.getPageId());
        return new WikiPage[]{page, redirectPage};
    }

    public static WikiPage[] addRenamedTrashedParentPage(long groupId, long nodeId, boolean explicitlyRemoveChildPage, boolean explicitlyRemoveRedirectPage) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, "A", true);
        WikiPageLocalServiceUtil.renamePage((long)TestPropsValues.getUserId(), (long)nodeId, (String)"A", (String)"B", (ServiceContext)serviceContext);
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"B");
        WikiPage redirectPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)"A");
        WikiPage childPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, "TestChildPage", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "B", true, serviceContext);
        if (explicitlyRemoveChildPage) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)nodeId, (String)"TestChildPage");
        }
        if (explicitlyRemoveRedirectPage) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)nodeId, (String)"A");
        }
        WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (long)nodeId, (String)"B");
        page = WikiPageLocalServiceUtil.getPageByPageId((long)page.getPageId());
        childPage = WikiPageLocalServiceUtil.getPageByPageId((long)childPage.getPageId());
        redirectPage = WikiPageLocalServiceUtil.getPageByPageId((long)redirectPage.getPageId());
        return new WikiPage[]{page, childPage, redirectPage};
    }

    public static WikiPage[] addTrashedPageWithChildPage(long groupId, long nodeId, boolean explicitlyRemoveChildPage) throws Exception {
        WikiPage page = WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, "TestPage", true);
        WikiPage childPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, "TestChildPage", RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "TestPage", true, ServiceContextTestUtil.getServiceContext((long)groupId));
        if (explicitlyRemoveChildPage) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (WikiPage)childPage);
        }
        WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (WikiPage)page);
        page = WikiPageLocalServiceUtil.getPageByPageId((long)page.getPageId());
        childPage = WikiPageLocalServiceUtil.getPageByPageId((long)childPage.getPageId());
        return new WikiPage[]{page, childPage};
    }

    public static WikiPage[] addTrashedParentPageWithChildPageAndGrandchildPage(long groupId, long nodeId, boolean explicitMoveChildToTrash, boolean explicitMoveParentToTrash) throws Exception {
        WikiPage parentPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), groupId, nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), true);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)groupId);
        WikiPage childPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), parentPage.getTitle(), true, serviceContext);
        WikiPage grandchildPage = WikiTestUtil.addPage(TestPropsValues.getUserId(), nodeId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), childPage.getTitle(), true, serviceContext);
        if (explicitMoveChildToTrash) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (WikiPage)childPage);
        }
        if (explicitMoveParentToTrash) {
            WikiPageLocalServiceUtil.movePageToTrash((long)TestPropsValues.getUserId(), (WikiPage)parentPage);
        }
        parentPage = WikiPageLocalServiceUtil.getPageByPageId((long)parentPage.getPageId());
        childPage = WikiPageLocalServiceUtil.getPageByPageId((long)childPage.getPageId());
        grandchildPage = WikiPageLocalServiceUtil.getPageByPageId((long)grandchildPage.getPageId());
        return new WikiPage[]{parentPage, childPage, grandchildPage};
    }

    public static File addWikiAttachment(long userId, long nodeId, String title, Class<?> clazz) throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]) + ".docx";
        return WikiTestUtil.addWikiAttachment(userId, nodeId, title, fileName, clazz);
    }

    public static File addWikiAttachment(long userId, long nodeId, String title, String fileName, Class<?> clazz) throws Exception {
        try (LogCapture logCapture = LoggerTestUtil.configureLog4JLogger((String)"org.apache.xmlbeans.impl.common.SAXHelper", (String)LoggerTestUtil.WARN);){
            byte[] fileBytes = FileUtil.getBytes(clazz, (String)"dependencies/OSX_Test.docx");
            File file = null;
            if (ArrayUtil.isNotEmpty((byte[])fileBytes)) {
                file = FileUtil.createTempFile((byte[])fileBytes);
            }
            String mimeType = MimeTypesUtil.getExtensionContentType((String)"docx");
            WikiPageLocalServiceUtil.addPageAttachment((long)userId, (long)nodeId, (String)title, (String)fileName, (File)file, (String)mimeType);
            File file2 = file;
            return file2;
        }
    }

    public static WikiPage copyPage(WikiPage page, boolean approved, ServiceContext serviceContext) throws Exception {
        WikiPage copyPage = WikiTestUtil.addPage(page.getUserId(), page.getNodeId(), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), page.getContent(), approved, serviceContext);
        WikiPageLocalServiceUtil.copyPageAttachments((long)page.getUserId(), (long)page.getNodeId(), (String)page.getTitle(), (long)copyPage.getNodeId(), (String)copyPage.getTitle());
        return copyPage;
    }

    public static void populateNotificationsServiceContext(ServiceContext serviceContext, String command) throws Exception {
        serviceContext.setAttribute("entryURL", (Serializable)((Object)"http://localhost"));
        if (Validator.isNotNull((String)command)) {
            serviceContext.setCommand(command);
        }
        serviceContext.setLayoutFullURL("http://localhost");
    }

    public static WikiPage updatePage(WikiPage page) throws Exception {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)page.getGroupId());
        serviceContext.setCommand("update");
        serviceContext.setLayoutFullURL("http://localhost");
        return WikiTestUtil.updatePage(page, page.getUserId(), page.getTitle(), RandomTestUtil.randomString((int)50, (RandomizerBumper[])new RandomizerBumper[0]), true, serviceContext);
    }

    public static WikiPage updatePage(WikiPage page, long userId, String content, ServiceContext serviceContext) throws Exception {
        return WikiTestUtil.updatePage(page, userId, page.getTitle(), content, true, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiPage updatePage(WikiPage page, long userId, String title, String content, boolean approved, ServiceContext serviceContext) throws Exception {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            page = WikiPageLocalServiceUtil.updatePage((long)userId, (long)page.getNodeId(), (String)title, (double)page.getVersion(), (String)content, (String)page.getSummary(), (boolean)false, (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
            if (approved) {
                page = WikiTestUtil.updateStatus(page, serviceContext);
            }
            WikiPage wikiPage = page;
            return wikiPage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    protected static WikiPage updateStatus(WikiPage page, ServiceContext serviceContext) throws Exception {
        return WikiPageLocalServiceUtil.updateStatus((long)page.getUserId(), (WikiPage)page, (int)0, (ServiceContext)serviceContext, (Map)HashMapBuilder.put((Object)"url", (Object)"http://localhost").build());
    }
}

