/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.uad.constants.WikiUADConstants;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWikiPageUADAnonymizer
extends DynamicQueryUADAnonymizer<WikiPage> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected WikiPageLocalService wikiPageLocalService;

    public void autoAnonymize(WikiPage wikiPage, long userId, User anonymousUser) throws PortalException {
        if (wikiPage.getUserId() == userId) {
            wikiPage.setUserId(anonymousUser.getUserId());
            wikiPage.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(wikiPage, anonymousUser);
        }
        if (wikiPage.getStatusByUserId() == userId) {
            wikiPage.setStatusByUserId(anonymousUser.getUserId());
            wikiPage.setStatusByUserName(anonymousUser.getFullName());
        }
        this.wikiPageLocalService.updateWikiPage(wikiPage);
    }

    public void delete(WikiPage wikiPage) throws PortalException {
        this.wikiPageLocalService.deletePage(wikiPage);
    }

    public Class<WikiPage> getTypeClass() {
        return WikiPage.class;
    }

    protected void autoAnonymizeAssetEntry(WikiPage wikiPage, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(wikiPage);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.wikiPageLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return WikiUADConstants.USER_ID_FIELD_NAMES_WIKI_PAGE;
    }

    protected AssetEntry fetchAssetEntry(WikiPage wikiPage) {
        return this.assetEntryLocalService.fetchEntry(WikiPage.class.getName(), wikiPage.getPageId());
    }
}

