/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.uad.constants.WikiUADConstants;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWikiNodeUADAnonymizer
extends DynamicQueryUADAnonymizer<WikiNode> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected WikiNodeLocalService wikiNodeLocalService;

    public void autoAnonymize(WikiNode wikiNode, long userId, User anonymousUser) throws PortalException {
        if (wikiNode.getUserId() == userId) {
            wikiNode.setUserId(anonymousUser.getUserId());
            wikiNode.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(wikiNode, anonymousUser);
        }
        if (wikiNode.getStatusByUserId() == userId) {
            wikiNode.setStatusByUserId(anonymousUser.getUserId());
            wikiNode.setStatusByUserName(anonymousUser.getFullName());
        }
        this.wikiNodeLocalService.updateWikiNode(wikiNode);
    }

    public void delete(WikiNode wikiNode) throws PortalException {
        this.wikiNodeLocalService.deleteNode(wikiNode);
    }

    public Class<WikiNode> getTypeClass() {
        return WikiNode.class;
    }

    protected void autoAnonymizeAssetEntry(WikiNode wikiNode, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(wikiNode);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.wikiNodeLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return WikiUADConstants.USER_ID_FIELD_NAMES_WIKI_NODE;
    }

    protected AssetEntry fetchAssetEntry(WikiNode wikiNode) {
        return this.assetEntryLocalService.fetchEntry(WikiNode.class.getName(), wikiNode.getNodeId());
    }
}

