/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.wiki.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.uad.constants.WikiUADConstants;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the wiki node UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link WikiNodeUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseWikiNodeUADAnonymizer
	extends DynamicQueryUADAnonymizer<WikiNode> {

	@Override
	public void autoAnonymize(
			WikiNode wikiNode, long userId, User anonymousUser)
		throws PortalException {

		if (wikiNode.getUserId() == userId) {
			wikiNode.setUserId(anonymousUser.getUserId());
			wikiNode.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(wikiNode, anonymousUser);
		}

		if (wikiNode.getStatusByUserId() == userId) {
			wikiNode.setStatusByUserId(anonymousUser.getUserId());
			wikiNode.setStatusByUserName(anonymousUser.getFullName());
		}

		wikiNodeLocalService.updateWikiNode(wikiNode);
	}

	@Override
	public void delete(WikiNode wikiNode) throws PortalException {
		wikiNodeLocalService.deleteNode(wikiNode);
	}

	@Override
	public Class<WikiNode> getTypeClass() {
		return WikiNode.class;
	}

	protected void autoAnonymizeAssetEntry(
		WikiNode wikiNode, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(wikiNode);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return wikiNodeLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return WikiUADConstants.USER_ID_FIELD_NAMES_WIKI_NODE;
	}

	protected AssetEntry fetchAssetEntry(WikiNode wikiNode) {
		return assetEntryLocalService.fetchEntry(
			WikiNode.class.getName(), wikiNode.getNodeId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected WikiNodeLocalService wikiNodeLocalService;

}