/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the WSRPConsumerPortlet service. Represents a row in the &quot;WSRP_WSRPConsumerPortlet&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.wsrp.model.impl.WSRPConsumerPortletModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.wsrp.model.impl.WSRPConsumerPortletImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WSRPConsumerPortlet
 * @generated
 */
@ProviderType
public interface WSRPConsumerPortletModel
	extends BaseModel<WSRPConsumerPortlet>, ShardedModel, StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a wsrp consumer portlet model instance should use the {@link WSRPConsumerPortlet} interface instead.
	 */

	/**
	 * Returns the primary key of this wsrp consumer portlet.
	 *
	 * @return the primary key of this wsrp consumer portlet
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this wsrp consumer portlet.
	 *
	 * @param primaryKey the primary key of this wsrp consumer portlet
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this wsrp consumer portlet.
	 *
	 * @return the uuid of this wsrp consumer portlet
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this wsrp consumer portlet.
	 *
	 * @param uuid the uuid of this wsrp consumer portlet
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the wsrp consumer portlet ID of this wsrp consumer portlet.
	 *
	 * @return the wsrp consumer portlet ID of this wsrp consumer portlet
	 */
	public long getWsrpConsumerPortletId();

	/**
	 * Sets the wsrp consumer portlet ID of this wsrp consumer portlet.
	 *
	 * @param wsrpConsumerPortletId the wsrp consumer portlet ID of this wsrp consumer portlet
	 */
	public void setWsrpConsumerPortletId(long wsrpConsumerPortletId);

	/**
	 * Returns the company ID of this wsrp consumer portlet.
	 *
	 * @return the company ID of this wsrp consumer portlet
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this wsrp consumer portlet.
	 *
	 * @param companyId the company ID of this wsrp consumer portlet
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this wsrp consumer portlet.
	 *
	 * @return the create date of this wsrp consumer portlet
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this wsrp consumer portlet.
	 *
	 * @param createDate the create date of this wsrp consumer portlet
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this wsrp consumer portlet.
	 *
	 * @return the modified date of this wsrp consumer portlet
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this wsrp consumer portlet.
	 *
	 * @param modifiedDate the modified date of this wsrp consumer portlet
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the wsrp consumer ID of this wsrp consumer portlet.
	 *
	 * @return the wsrp consumer ID of this wsrp consumer portlet
	 */
	public long getWsrpConsumerId();

	/**
	 * Sets the wsrp consumer ID of this wsrp consumer portlet.
	 *
	 * @param wsrpConsumerId the wsrp consumer ID of this wsrp consumer portlet
	 */
	public void setWsrpConsumerId(long wsrpConsumerId);

	/**
	 * Returns the name of this wsrp consumer portlet.
	 *
	 * @return the name of this wsrp consumer portlet
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this wsrp consumer portlet.
	 *
	 * @param name the name of this wsrp consumer portlet
	 */
	public void setName(String name);

	/**
	 * Returns the portlet handle of this wsrp consumer portlet.
	 *
	 * @return the portlet handle of this wsrp consumer portlet
	 */
	@AutoEscape
	public String getPortletHandle();

	/**
	 * Sets the portlet handle of this wsrp consumer portlet.
	 *
	 * @param portletHandle the portlet handle of this wsrp consumer portlet
	 */
	public void setPortletHandle(String portletHandle);

	/**
	 * Returns the last publish date of this wsrp consumer portlet.
	 *
	 * @return the last publish date of this wsrp consumer portlet
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this wsrp consumer portlet.
	 *
	 * @param lastPublishDate the last publish date of this wsrp consumer portlet
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(WSRPConsumerPortlet wsrpConsumerPortlet);

	@Override
	public int hashCode();

	@Override
	public CacheModel<WSRPConsumerPortlet> toCacheModel();

	@Override
	public WSRPConsumerPortlet toEscapedModel();

	@Override
	public WSRPConsumerPortlet toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}