/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.model;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * This class is a wrapper for {@link WSRPConsumer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WSRPConsumer
 * @generated
 */
public class WSRPConsumerWrapper
	implements ModelWrapper<WSRPConsumer>, WSRPConsumer {

	public WSRPConsumerWrapper(WSRPConsumer wsrpConsumer) {
		_wsrpConsumer = wsrpConsumer;
	}

	@Override
	public Class<?> getModelClass() {
		return WSRPConsumer.class;
	}

	@Override
	public String getModelClassName() {
		return WSRPConsumer.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("wsrpConsumerId", getWsrpConsumerId());
		attributes.put("companyId", getCompanyId());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("name", getName());
		attributes.put("url", getUrl());
		attributes.put("wsdl", getWsdl());
		attributes.put(
			"registrationContextString", getRegistrationContextString());
		attributes.put(
			"registrationPropertiesString", getRegistrationPropertiesString());
		attributes.put("forwardCookies", getForwardCookies());
		attributes.put("forwardHeaders", getForwardHeaders());
		attributes.put("markupCharacterSets", getMarkupCharacterSets());
		attributes.put("lastPublishDate", getLastPublishDate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long wsrpConsumerId = (Long)attributes.get("wsrpConsumerId");

		if (wsrpConsumerId != null) {
			setWsrpConsumerId(wsrpConsumerId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String url = (String)attributes.get("url");

		if (url != null) {
			setUrl(url);
		}

		String wsdl = (String)attributes.get("wsdl");

		if (wsdl != null) {
			setWsdl(wsdl);
		}

		String registrationContextString = (String)attributes.get(
			"registrationContextString");

		if (registrationContextString != null) {
			setRegistrationContextString(registrationContextString);
		}

		String registrationPropertiesString = (String)attributes.get(
			"registrationPropertiesString");

		if (registrationPropertiesString != null) {
			setRegistrationPropertiesString(registrationPropertiesString);
		}

		String forwardCookies = (String)attributes.get("forwardCookies");

		if (forwardCookies != null) {
			setForwardCookies(forwardCookies);
		}

		String forwardHeaders = (String)attributes.get("forwardHeaders");

		if (forwardHeaders != null) {
			setForwardHeaders(forwardHeaders);
		}

		String markupCharacterSets = (String)attributes.get(
			"markupCharacterSets");

		if (markupCharacterSets != null) {
			setMarkupCharacterSets(markupCharacterSets);
		}

		Date lastPublishDate = (Date)attributes.get("lastPublishDate");

		if (lastPublishDate != null) {
			setLastPublishDate(lastPublishDate);
		}
	}

	@Override
	public Object clone() {
		return new WSRPConsumerWrapper((WSRPConsumer)_wsrpConsumer.clone());
	}

	@Override
	public int compareTo(WSRPConsumer wsrpConsumer) {
		return _wsrpConsumer.compareTo(wsrpConsumer);
	}

	/**
	 * Returns the company ID of this wsrp consumer.
	 *
	 * @return the company ID of this wsrp consumer
	 */
	@Override
	public long getCompanyId() {
		return _wsrpConsumer.getCompanyId();
	}

	/**
	 * Returns the create date of this wsrp consumer.
	 *
	 * @return the create date of this wsrp consumer
	 */
	@Override
	public Date getCreateDate() {
		return _wsrpConsumer.getCreateDate();
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return _wsrpConsumer.getExpandoBridge();
	}

	/**
	 * Returns the forward cookies of this wsrp consumer.
	 *
	 * @return the forward cookies of this wsrp consumer
	 */
	@Override
	public String getForwardCookies() {
		return _wsrpConsumer.getForwardCookies();
	}

	/**
	 * Returns the forward headers of this wsrp consumer.
	 *
	 * @return the forward headers of this wsrp consumer
	 */
	@Override
	public String getForwardHeaders() {
		return _wsrpConsumer.getForwardHeaders();
	}

	/**
	 * Returns the last publish date of this wsrp consumer.
	 *
	 * @return the last publish date of this wsrp consumer
	 */
	@Override
	public Date getLastPublishDate() {
		return _wsrpConsumer.getLastPublishDate();
	}

	/**
	 * Returns the markup character sets of this wsrp consumer.
	 *
	 * @return the markup character sets of this wsrp consumer
	 */
	@Override
	public String getMarkupCharacterSets() {
		return _wsrpConsumer.getMarkupCharacterSets();
	}

	/**
	 * Returns the modified date of this wsrp consumer.
	 *
	 * @return the modified date of this wsrp consumer
	 */
	@Override
	public Date getModifiedDate() {
		return _wsrpConsumer.getModifiedDate();
	}

	/**
	 * Returns the name of this wsrp consumer.
	 *
	 * @return the name of this wsrp consumer
	 */
	@Override
	public String getName() {
		return _wsrpConsumer.getName();
	}

	/**
	 * Returns the primary key of this wsrp consumer.
	 *
	 * @return the primary key of this wsrp consumer
	 */
	@Override
	public long getPrimaryKey() {
		return _wsrpConsumer.getPrimaryKey();
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _wsrpConsumer.getPrimaryKeyObj();
	}

	@Override
	public oasis.names.tc.wsrp.v2.types.RegistrationContext
		getRegistrationContext() {

		return _wsrpConsumer.getRegistrationContext();
	}

	/**
	 * Returns the registration context string of this wsrp consumer.
	 *
	 * @return the registration context string of this wsrp consumer
	 */
	@Override
	public String getRegistrationContextString() {
		return _wsrpConsumer.getRegistrationContextString();
	}

	@Override
	public com.liferay.portal.kernel.util.UnicodeProperties
		getRegistrationProperties() {

		return _wsrpConsumer.getRegistrationProperties();
	}

	/**
	 * Returns the registration properties string of this wsrp consumer.
	 *
	 * @return the registration properties string of this wsrp consumer
	 */
	@Override
	public String getRegistrationPropertiesString() {
		return _wsrpConsumer.getRegistrationPropertiesString();
	}

	/**
	 * Returns the url of this wsrp consumer.
	 *
	 * @return the url of this wsrp consumer
	 */
	@Override
	public String getUrl() {
		return _wsrpConsumer.getUrl();
	}

	/**
	 * Returns the uuid of this wsrp consumer.
	 *
	 * @return the uuid of this wsrp consumer
	 */
	@Override
	public String getUuid() {
		return _wsrpConsumer.getUuid();
	}

	/**
	 * Returns the wsdl of this wsrp consumer.
	 *
	 * @return the wsdl of this wsrp consumer
	 */
	@Override
	public String getWsdl() {
		return _wsrpConsumer.getWsdl();
	}

	/**
	 * Returns the wsrp consumer ID of this wsrp consumer.
	 *
	 * @return the wsrp consumer ID of this wsrp consumer
	 */
	@Override
	public long getWsrpConsumerId() {
		return _wsrpConsumer.getWsrpConsumerId();
	}

	@Override
	public int hashCode() {
		return _wsrpConsumer.hashCode();
	}

	@Override
	public boolean isCachedModel() {
		return _wsrpConsumer.isCachedModel();
	}

	@Override
	public boolean isEscapedModel() {
		return _wsrpConsumer.isEscapedModel();
	}

	@Override
	public boolean isNew() {
		return _wsrpConsumer.isNew();
	}

	@Override
	public void persist() {
		_wsrpConsumer.persist();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_wsrpConsumer.setCachedModel(cachedModel);
	}

	/**
	 * Sets the company ID of this wsrp consumer.
	 *
	 * @param companyId the company ID of this wsrp consumer
	 */
	@Override
	public void setCompanyId(long companyId) {
		_wsrpConsumer.setCompanyId(companyId);
	}

	/**
	 * Sets the create date of this wsrp consumer.
	 *
	 * @param createDate the create date of this wsrp consumer
	 */
	@Override
	public void setCreateDate(Date createDate) {
		_wsrpConsumer.setCreateDate(createDate);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.kernel.model.BaseModel<?> baseModel) {

		_wsrpConsumer.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
		_wsrpConsumer.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		_wsrpConsumer.setExpandoBridgeAttributes(serviceContext);
	}

	/**
	 * Sets the forward cookies of this wsrp consumer.
	 *
	 * @param forwardCookies the forward cookies of this wsrp consumer
	 */
	@Override
	public void setForwardCookies(String forwardCookies) {
		_wsrpConsumer.setForwardCookies(forwardCookies);
	}

	/**
	 * Sets the forward headers of this wsrp consumer.
	 *
	 * @param forwardHeaders the forward headers of this wsrp consumer
	 */
	@Override
	public void setForwardHeaders(String forwardHeaders) {
		_wsrpConsumer.setForwardHeaders(forwardHeaders);
	}

	/**
	 * Sets the last publish date of this wsrp consumer.
	 *
	 * @param lastPublishDate the last publish date of this wsrp consumer
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_wsrpConsumer.setLastPublishDate(lastPublishDate);
	}

	/**
	 * Sets the markup character sets of this wsrp consumer.
	 *
	 * @param markupCharacterSets the markup character sets of this wsrp consumer
	 */
	@Override
	public void setMarkupCharacterSets(String markupCharacterSets) {
		_wsrpConsumer.setMarkupCharacterSets(markupCharacterSets);
	}

	/**
	 * Sets the modified date of this wsrp consumer.
	 *
	 * @param modifiedDate the modified date of this wsrp consumer
	 */
	@Override
	public void setModifiedDate(Date modifiedDate) {
		_wsrpConsumer.setModifiedDate(modifiedDate);
	}

	/**
	 * Sets the name of this wsrp consumer.
	 *
	 * @param name the name of this wsrp consumer
	 */
	@Override
	public void setName(String name) {
		_wsrpConsumer.setName(name);
	}

	@Override
	public void setNew(boolean n) {
		_wsrpConsumer.setNew(n);
	}

	/**
	 * Sets the primary key of this wsrp consumer.
	 *
	 * @param primaryKey the primary key of this wsrp consumer
	 */
	@Override
	public void setPrimaryKey(long primaryKey) {
		_wsrpConsumer.setPrimaryKey(primaryKey);
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		_wsrpConsumer.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public void setRegistrationContext(
		oasis.names.tc.wsrp.v2.types.RegistrationContext registrationContext) {

		_wsrpConsumer.setRegistrationContext(registrationContext);
	}

	/**
	 * Sets the registration context string of this wsrp consumer.
	 *
	 * @param registrationContextString the registration context string of this wsrp consumer
	 */
	@Override
	public void setRegistrationContextString(String registrationContextString) {
		_wsrpConsumer.setRegistrationContextString(registrationContextString);
	}

	@Override
	public void setRegistrationProperties(
		com.liferay.portal.kernel.util.UnicodeProperties
			registrationProperties) {

		_wsrpConsumer.setRegistrationProperties(registrationProperties);
	}

	/**
	 * Sets the registration properties string of this wsrp consumer.
	 *
	 * @param registrationPropertiesString the registration properties string of this wsrp consumer
	 */
	@Override
	public void setRegistrationPropertiesString(
		String registrationPropertiesString) {

		_wsrpConsumer.setRegistrationPropertiesString(
			registrationPropertiesString);
	}

	/**
	 * Sets the url of this wsrp consumer.
	 *
	 * @param url the url of this wsrp consumer
	 */
	@Override
	public void setUrl(String url) {
		_wsrpConsumer.setUrl(url);
	}

	/**
	 * Sets the uuid of this wsrp consumer.
	 *
	 * @param uuid the uuid of this wsrp consumer
	 */
	@Override
	public void setUuid(String uuid) {
		_wsrpConsumer.setUuid(uuid);
	}

	/**
	 * Sets the wsdl of this wsrp consumer.
	 *
	 * @param wsdl the wsdl of this wsrp consumer
	 */
	@Override
	public void setWsdl(String wsdl) {
		_wsrpConsumer.setWsdl(wsdl);
	}

	/**
	 * Sets the wsrp consumer ID of this wsrp consumer.
	 *
	 * @param wsrpConsumerId the wsrp consumer ID of this wsrp consumer
	 */
	@Override
	public void setWsrpConsumerId(long wsrpConsumerId) {
		_wsrpConsumer.setWsrpConsumerId(wsrpConsumerId);
	}

	@Override
	public com.liferay.portal.kernel.model.CacheModel<WSRPConsumer>
		toCacheModel() {

		return _wsrpConsumer.toCacheModel();
	}

	@Override
	public WSRPConsumer toEscapedModel() {
		return new WSRPConsumerWrapper(_wsrpConsumer.toEscapedModel());
	}

	@Override
	public String toString() {
		return _wsrpConsumer.toString();
	}

	@Override
	public WSRPConsumer toUnescapedModel() {
		return new WSRPConsumerWrapper(_wsrpConsumer.toUnescapedModel());
	}

	@Override
	public String toXmlString() {
		return _wsrpConsumer.toXmlString();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WSRPConsumerWrapper)) {
			return false;
		}

		WSRPConsumerWrapper wsrpConsumerWrapper = (WSRPConsumerWrapper)object;

		if (Objects.equals(_wsrpConsumer, wsrpConsumerWrapper._wsrpConsumer)) {
			return true;
		}

		return false;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return _wsrpConsumer.getStagedModelType();
	}

	@Override
	public WSRPConsumer getWrappedModel() {
		return _wsrpConsumer;
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return _wsrpConsumer.isEntityCacheEnabled();
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return _wsrpConsumer.isFinderCacheEnabled();
	}

	@Override
	public void resetOriginalValues() {
		_wsrpConsumer.resetOriginalValues();
	}

	private final WSRPConsumer _wsrpConsumer;

}