/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the WSRPProducer service. Represents a row in the &quot;WSRP_WSRPProducer&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.wsrp.model.impl.WSRPProducerModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.wsrp.model.impl.WSRPProducerImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WSRPProducer
 * @generated
 */
@ProviderType
public interface WSRPProducerModel
	extends BaseModel<WSRPProducer>, ShardedModel, StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a wsrp producer model instance should use the {@link WSRPProducer} interface instead.
	 */

	/**
	 * Returns the primary key of this wsrp producer.
	 *
	 * @return the primary key of this wsrp producer
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this wsrp producer.
	 *
	 * @param primaryKey the primary key of this wsrp producer
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this wsrp producer.
	 *
	 * @return the uuid of this wsrp producer
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this wsrp producer.
	 *
	 * @param uuid the uuid of this wsrp producer
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the wsrp producer ID of this wsrp producer.
	 *
	 * @return the wsrp producer ID of this wsrp producer
	 */
	public long getWsrpProducerId();

	/**
	 * Sets the wsrp producer ID of this wsrp producer.
	 *
	 * @param wsrpProducerId the wsrp producer ID of this wsrp producer
	 */
	public void setWsrpProducerId(long wsrpProducerId);

	/**
	 * Returns the group ID of this wsrp producer.
	 *
	 * @return the group ID of this wsrp producer
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this wsrp producer.
	 *
	 * @param groupId the group ID of this wsrp producer
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this wsrp producer.
	 *
	 * @return the company ID of this wsrp producer
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this wsrp producer.
	 *
	 * @param companyId the company ID of this wsrp producer
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this wsrp producer.
	 *
	 * @return the create date of this wsrp producer
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this wsrp producer.
	 *
	 * @param createDate the create date of this wsrp producer
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this wsrp producer.
	 *
	 * @return the modified date of this wsrp producer
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this wsrp producer.
	 *
	 * @param modifiedDate the modified date of this wsrp producer
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the name of this wsrp producer.
	 *
	 * @return the name of this wsrp producer
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this wsrp producer.
	 *
	 * @param name the name of this wsrp producer
	 */
	public void setName(String name);

	/**
	 * Returns the version of this wsrp producer.
	 *
	 * @return the version of this wsrp producer
	 */
	@AutoEscape
	public String getVersion();

	/**
	 * Sets the version of this wsrp producer.
	 *
	 * @param version the version of this wsrp producer
	 */
	public void setVersion(String version);

	/**
	 * Returns the portlet IDs of this wsrp producer.
	 *
	 * @return the portlet IDs of this wsrp producer
	 */
	@AutoEscape
	public String getPortletIds();

	/**
	 * Sets the portlet IDs of this wsrp producer.
	 *
	 * @param portletIds the portlet IDs of this wsrp producer
	 */
	public void setPortletIds(String portletIds);

	/**
	 * Returns the last publish date of this wsrp producer.
	 *
	 * @return the last publish date of this wsrp producer
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this wsrp producer.
	 *
	 * @param lastPublishDate the last publish date of this wsrp producer
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(WSRPProducer wsrpProducer);

	@Override
	public int hashCode();

	@Override
	public CacheModel<WSRPProducer> toCacheModel();

	@Override
	public WSRPProducer toEscapedModel();

	@Override
	public WSRPProducer toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}