/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.service;

import com.liferay.portal.kernel.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link WSRPProducerLocalService}.
 *
 * @author Brian Wing Shun Chan
 * @see WSRPProducerLocalService
 * @generated
 */
public class WSRPProducerLocalServiceWrapper
	implements ServiceWrapper<WSRPProducerLocalService>,
			   WSRPProducerLocalService {

	public WSRPProducerLocalServiceWrapper(
		WSRPProducerLocalService wsrpProducerLocalService) {

		_wsrpProducerLocalService = wsrpProducerLocalService;
	}

	@Override
	public com.liferay.wsrp.model.WSRPProducer addWSRPProducer(
			long userId, long groupId, String name, String version,
			String portletIds,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.addWSRPProducer(
			userId, groupId, name, version, portletIds, serviceContext);
	}

	@Override
	public com.liferay.wsrp.model.WSRPProducer addWSRPProducer(
			long userId, String name, String version, String portletIds,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.addWSRPProducer(
			userId, name, version, portletIds, serviceContext);
	}

	/**
	 * Adds the wsrp producer to the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect WSRPProducerLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param wsrpProducer the wsrp producer
	 * @return the wsrp producer that was added
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer addWSRPProducer(
		com.liferay.wsrp.model.WSRPProducer wsrpProducer) {

		return _wsrpProducerLocalService.addWSRPProducer(wsrpProducer);
	}

	/**
	 * Creates a new wsrp producer with the primary key. Does not add the wsrp producer to the database.
	 *
	 * @param wsrpProducerId the primary key for the new wsrp producer
	 * @return the new wsrp producer
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer createWSRPProducer(
		long wsrpProducerId) {

		return _wsrpProducerLocalService.createWSRPProducer(wsrpProducerId);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel deletePersistedModel(
			com.liferay.portal.kernel.model.PersistedModel persistedModel)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.deletePersistedModel(persistedModel);
	}

	/**
	 * Deletes the wsrp producer with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect WSRPProducerLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param wsrpProducerId the primary key of the wsrp producer
	 * @return the wsrp producer that was removed
	 * @throws PortalException if a wsrp producer with the primary key could not be found
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer deleteWSRPProducer(
			long wsrpProducerId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.deleteWSRPProducer(wsrpProducerId);
	}

	/**
	 * Deletes the wsrp producer from the database. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect WSRPProducerLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param wsrpProducer the wsrp producer
	 * @return the wsrp producer that was removed
	 * @throws PortalException
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer deleteWSRPProducer(
			com.liferay.wsrp.model.WSRPProducer wsrpProducer)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.deleteWSRPProducer(wsrpProducer);
	}

	@Override
	public void deleteWSRPProducers(long companyId)
		throws com.liferay.portal.kernel.exception.PortalException {

		_wsrpProducerLocalService.deleteWSRPProducers(companyId);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _wsrpProducerLocalService.dynamicQuery();
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _wsrpProducerLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.wsrp.model.impl.WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) {

		return _wsrpProducerLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.wsrp.model.impl.WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator<T> orderByComparator) {

		return _wsrpProducerLocalService.dynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _wsrpProducerLocalService.dynamicQueryCount(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
		com.liferay.portal.kernel.dao.orm.Projection projection) {

		return _wsrpProducerLocalService.dynamicQueryCount(
			dynamicQuery, projection);
	}

	@Override
	public com.liferay.wsrp.model.WSRPProducer fetchWSRPProducer(
		long wsrpProducerId) {

		return _wsrpProducerLocalService.fetchWSRPProducer(wsrpProducerId);
	}

	/**
	 * Returns the wsrp producer matching the UUID and group.
	 *
	 * @param uuid the wsrp producer's UUID
	 * @param groupId the primary key of the group
	 * @return the matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer
		fetchWSRPProducerByUuidAndGroupId(String uuid, long groupId) {

		return _wsrpProducerLocalService.fetchWSRPProducerByUuidAndGroupId(
			uuid, groupId);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery
		getActionableDynamicQuery() {

		return _wsrpProducerLocalService.getActionableDynamicQuery();
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery
		getExportActionableDynamicQuery(
			com.liferay.exportimport.kernel.lar.PortletDataContext
				portletDataContext) {

		return _wsrpProducerLocalService.getExportActionableDynamicQuery(
			portletDataContext);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		return _wsrpProducerLocalService.getIndexableActionableDynamicQuery();
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return _wsrpProducerLocalService.getOSGiServiceIdentifier();
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel getPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	 * Returns the wsrp producer with the primary key.
	 *
	 * @param wsrpProducerId the primary key of the wsrp producer
	 * @return the wsrp producer
	 * @throws PortalException if a wsrp producer with the primary key could not be found
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer getWSRPProducer(
			long wsrpProducerId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.getWSRPProducer(wsrpProducerId);
	}

	@Override
	public com.liferay.wsrp.model.WSRPProducer getWSRPProducer(
			String wsrpProducerUuid)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.getWSRPProducer(wsrpProducerUuid);
	}

	/**
	 * Returns the wsrp producer matching the UUID and group.
	 *
	 * @param uuid the wsrp producer's UUID
	 * @param groupId the primary key of the group
	 * @return the matching wsrp producer
	 * @throws PortalException if a matching wsrp producer could not be found
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer getWSRPProducerByUuidAndGroupId(
			String uuid, long groupId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.getWSRPProducerByUuidAndGroupId(
			uuid, groupId);
	}

	/**
	 * Returns a range of all the wsrp producers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.wsrp.model.impl.WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @return the range of wsrp producers
	 */
	@Override
	public java.util.List<com.liferay.wsrp.model.WSRPProducer> getWSRPProducers(
		int start, int end) {

		return _wsrpProducerLocalService.getWSRPProducers(start, end);
	}

	@Override
	public java.util.List<com.liferay.wsrp.model.WSRPProducer> getWSRPProducers(
		long companyId, int start, int end) {

		return _wsrpProducerLocalService.getWSRPProducers(
			companyId, start, end);
	}

	/**
	 * Returns all the wsrp producers matching the UUID and company.
	 *
	 * @param uuid the UUID of the wsrp producers
	 * @param companyId the primary key of the company
	 * @return the matching wsrp producers, or an empty list if no matches were found
	 */
	@Override
	public java.util.List<com.liferay.wsrp.model.WSRPProducer>
		getWSRPProducersByUuidAndCompanyId(String uuid, long companyId) {

		return _wsrpProducerLocalService.getWSRPProducersByUuidAndCompanyId(
			uuid, companyId);
	}

	/**
	 * Returns a range of wsrp producers matching the UUID and company.
	 *
	 * @param uuid the UUID of the wsrp producers
	 * @param companyId the primary key of the company
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the range of matching wsrp producers, or an empty list if no matches were found
	 */
	@Override
	public java.util.List<com.liferay.wsrp.model.WSRPProducer>
		getWSRPProducersByUuidAndCompanyId(
			String uuid, long companyId, int start, int end,
			com.liferay.portal.kernel.util.OrderByComparator
				<com.liferay.wsrp.model.WSRPProducer> orderByComparator) {

		return _wsrpProducerLocalService.getWSRPProducersByUuidAndCompanyId(
			uuid, companyId, start, end, orderByComparator);
	}

	/**
	 * Returns the number of wsrp producers.
	 *
	 * @return the number of wsrp producers
	 */
	@Override
	public int getWSRPProducersCount() {
		return _wsrpProducerLocalService.getWSRPProducersCount();
	}

	@Override
	public int getWSRPProducersCount(long companyId) {
		return _wsrpProducerLocalService.getWSRPProducersCount(companyId);
	}

	@Override
	public com.liferay.wsrp.model.WSRPProducer updateWSRPProducer(
			long wsrpProducerId, String name, String version, String portletIds)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _wsrpProducerLocalService.updateWSRPProducer(
			wsrpProducerId, name, version, portletIds);
	}

	/**
	 * Updates the wsrp producer in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * <p>
	 * <strong>Important:</strong> Inspect WSRPProducerLocalServiceImpl for overloaded versions of the method. If provided, use these entry points to the API, as the implementation logic may require the additional parameters defined there.
	 * </p>
	 *
	 * @param wsrpProducer the wsrp producer
	 * @return the wsrp producer that was updated
	 */
	@Override
	public com.liferay.wsrp.model.WSRPProducer updateWSRPProducer(
		com.liferay.wsrp.model.WSRPProducer wsrpProducer) {

		return _wsrpProducerLocalService.updateWSRPProducer(wsrpProducer);
	}

	@Override
	public WSRPProducerLocalService getWrappedService() {
		return _wsrpProducerLocalService;
	}

	@Override
	public void setWrappedService(
		WSRPProducerLocalService wsrpProducerLocalService) {

		_wsrpProducerLocalService = wsrpProducerLocalService;
	}

	private WSRPProducerLocalService _wsrpProducerLocalService;

}