/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.wsrp.service.persistence;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wsrp.model.WSRPProducer;

import java.io.Serializable;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

/**
 * The persistence utility for the wsrp producer service. This utility wraps <code>com.liferay.wsrp.service.persistence.impl.WSRPProducerPersistenceImpl</code> and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WSRPProducerPersistence
 * @generated
 */
public class WSRPProducerUtil {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#clearCache()
	 */
	public static void clearCache() {
		getPersistence().clearCache();
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#clearCache(com.liferay.portal.kernel.model.BaseModel)
	 */
	public static void clearCache(WSRPProducer wsrpProducer) {
		getPersistence().clearCache(wsrpProducer);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
	 */
	public static long countWithDynamicQuery(DynamicQuery dynamicQuery) {
		return getPersistence().countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#fetchByPrimaryKeys(Set)
	 */
	public static Map<Serializable, WSRPProducer> fetchByPrimaryKeys(
		Set<Serializable> primaryKeys) {

		return getPersistence().fetchByPrimaryKeys(primaryKeys);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
	 */
	public static List<WSRPProducer> findWithDynamicQuery(
		DynamicQuery dynamicQuery) {

		return getPersistence().findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
	 */
	public static List<WSRPProducer> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {

		return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
	 */
	public static List<WSRPProducer> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().findWithDynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#update(com.liferay.portal.kernel.model.BaseModel)
	 */
	public static WSRPProducer update(WSRPProducer wsrpProducer) {
		return getPersistence().update(wsrpProducer);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#update(com.liferay.portal.kernel.model.BaseModel, ServiceContext)
	 */
	public static WSRPProducer update(
		WSRPProducer wsrpProducer, ServiceContext serviceContext) {

		return getPersistence().update(wsrpProducer, serviceContext);
	}

	/**
	 * Returns all the wsrp producers where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @return the matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid(String uuid) {
		return getPersistence().findByUuid(uuid);
	}

	/**
	 * Returns a range of all the wsrp producers where uuid = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @return the range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid(
		String uuid, int start, int end) {

		return getPersistence().findByUuid(uuid, start, end);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where uuid = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid(
		String uuid, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().findByUuid(uuid, start, end, orderByComparator);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where uuid = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid(
		String uuid, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator,
		boolean useFinderCache) {

		return getPersistence().findByUuid(
			uuid, start, end, orderByComparator, useFinderCache);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByUuid_First(
			String uuid, OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_First(uuid, orderByComparator);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUuid_First(
		String uuid, OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByUuid_First(uuid, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByUuid_Last(
			String uuid, OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_Last(uuid, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUuid_Last(
		String uuid, OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByUuid_Last(uuid, orderByComparator);
	}

	/**
	 * Returns the wsrp producers before and after the current wsrp producer in the ordered set where uuid = &#63;.
	 *
	 * @param wsrpProducerId the primary key of the current wsrp producer
	 * @param uuid the uuid
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next wsrp producer
	 * @throws NoSuchProducerException if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer[] findByUuid_PrevAndNext(
			long wsrpProducerId, String uuid,
			OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_PrevAndNext(
			wsrpProducerId, uuid, orderByComparator);
	}

	/**
	 * Removes all the wsrp producers where uuid = &#63; from the database.
	 *
	 * @param uuid the uuid
	 */
	public static void removeByUuid(String uuid) {
		getPersistence().removeByUuid(uuid);
	}

	/**
	 * Returns the number of wsrp producers where uuid = &#63;.
	 *
	 * @param uuid the uuid
	 * @return the number of matching wsrp producers
	 */
	public static int countByUuid(String uuid) {
		return getPersistence().countByUuid(uuid);
	}

	/**
	 * Returns the wsrp producer where uuid = &#63; and groupId = &#63; or throws a <code>NoSuchProducerException</code> if it could not be found.
	 *
	 * @param uuid the uuid
	 * @param groupId the group ID
	 * @return the matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByUUID_G(String uuid, long groupId)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUUID_G(uuid, groupId);
	}

	/**
	 * Returns the wsrp producer where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	 *
	 * @param uuid the uuid
	 * @param groupId the group ID
	 * @return the matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUUID_G(String uuid, long groupId) {
		return getPersistence().fetchByUUID_G(uuid, groupId);
	}

	/**
	 * Returns the wsrp producer where uuid = &#63; and groupId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	 *
	 * @param uuid the uuid
	 * @param groupId the group ID
	 * @param useFinderCache whether to use the finder cache
	 * @return the matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUUID_G(
		String uuid, long groupId, boolean useFinderCache) {

		return getPersistence().fetchByUUID_G(uuid, groupId, useFinderCache);
	}

	/**
	 * Removes the wsrp producer where uuid = &#63; and groupId = &#63; from the database.
	 *
	 * @param uuid the uuid
	 * @param groupId the group ID
	 * @return the wsrp producer that was removed
	 */
	public static WSRPProducer removeByUUID_G(String uuid, long groupId)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().removeByUUID_G(uuid, groupId);
	}

	/**
	 * Returns the number of wsrp producers where uuid = &#63; and groupId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param groupId the group ID
	 * @return the number of matching wsrp producers
	 */
	public static int countByUUID_G(String uuid, long groupId) {
		return getPersistence().countByUUID_G(uuid, groupId);
	}

	/**
	 * Returns all the wsrp producers where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @return the matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid_C(String uuid, long companyId) {
		return getPersistence().findByUuid_C(uuid, companyId);
	}

	/**
	 * Returns a range of all the wsrp producers where uuid = &#63; and companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @return the range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid_C(
		String uuid, long companyId, int start, int end) {

		return getPersistence().findByUuid_C(uuid, companyId, start, end);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where uuid = &#63; and companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid_C(
		String uuid, long companyId, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().findByUuid_C(
			uuid, companyId, start, end, orderByComparator);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where uuid = &#63; and companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByUuid_C(
		String uuid, long companyId, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator,
		boolean useFinderCache) {

		return getPersistence().findByUuid_C(
			uuid, companyId, start, end, orderByComparator, useFinderCache);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByUuid_C_First(
			String uuid, long companyId,
			OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_C_First(
			uuid, companyId, orderByComparator);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUuid_C_First(
		String uuid, long companyId,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByUuid_C_First(
			uuid, companyId, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByUuid_C_Last(
			String uuid, long companyId,
			OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_C_Last(
			uuid, companyId, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByUuid_C_Last(
		String uuid, long companyId,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByUuid_C_Last(
			uuid, companyId, orderByComparator);
	}

	/**
	 * Returns the wsrp producers before and after the current wsrp producer in the ordered set where uuid = &#63; and companyId = &#63;.
	 *
	 * @param wsrpProducerId the primary key of the current wsrp producer
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next wsrp producer
	 * @throws NoSuchProducerException if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer[] findByUuid_C_PrevAndNext(
			long wsrpProducerId, String uuid, long companyId,
			OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByUuid_C_PrevAndNext(
			wsrpProducerId, uuid, companyId, orderByComparator);
	}

	/**
	 * Removes all the wsrp producers where uuid = &#63; and companyId = &#63; from the database.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 */
	public static void removeByUuid_C(String uuid, long companyId) {
		getPersistence().removeByUuid_C(uuid, companyId);
	}

	/**
	 * Returns the number of wsrp producers where uuid = &#63; and companyId = &#63;.
	 *
	 * @param uuid the uuid
	 * @param companyId the company ID
	 * @return the number of matching wsrp producers
	 */
	public static int countByUuid_C(String uuid, long companyId) {
		return getPersistence().countByUuid_C(uuid, companyId);
	}

	/**
	 * Returns all the wsrp producers where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @return the matching wsrp producers
	 */
	public static List<WSRPProducer> findByCompanyId(long companyId) {
		return getPersistence().findByCompanyId(companyId);
	}

	/**
	 * Returns a range of all the wsrp producers where companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @return the range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByCompanyId(
		long companyId, int start, int end) {

		return getPersistence().findByCompanyId(companyId, start, end);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByCompanyId(
		long companyId, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().findByCompanyId(
			companyId, start, end, orderByComparator);
	}

	/**
	 * Returns an ordered range of all the wsrp producers where companyId = &#63;.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param companyId the company ID
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of matching wsrp producers
	 */
	public static List<WSRPProducer> findByCompanyId(
		long companyId, int start, int end,
		OrderByComparator<WSRPProducer> orderByComparator,
		boolean useFinderCache) {

		return getPersistence().findByCompanyId(
			companyId, start, end, orderByComparator, useFinderCache);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByCompanyId_First(
			long companyId, OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByCompanyId_First(
			companyId, orderByComparator);
	}

	/**
	 * Returns the first wsrp producer in the ordered set where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the first matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByCompanyId_First(
		long companyId, OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByCompanyId_First(
			companyId, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer
	 * @throws NoSuchProducerException if a matching wsrp producer could not be found
	 */
	public static WSRPProducer findByCompanyId_Last(
			long companyId, OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByCompanyId_Last(
			companyId, orderByComparator);
	}

	/**
	 * Returns the last wsrp producer in the ordered set where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the last matching wsrp producer, or <code>null</code> if a matching wsrp producer could not be found
	 */
	public static WSRPProducer fetchByCompanyId_Last(
		long companyId, OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().fetchByCompanyId_Last(
			companyId, orderByComparator);
	}

	/**
	 * Returns the wsrp producers before and after the current wsrp producer in the ordered set where companyId = &#63;.
	 *
	 * @param wsrpProducerId the primary key of the current wsrp producer
	 * @param companyId the company ID
	 * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	 * @return the previous, current, and next wsrp producer
	 * @throws NoSuchProducerException if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer[] findByCompanyId_PrevAndNext(
			long wsrpProducerId, long companyId,
			OrderByComparator<WSRPProducer> orderByComparator)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByCompanyId_PrevAndNext(
			wsrpProducerId, companyId, orderByComparator);
	}

	/**
	 * Removes all the wsrp producers where companyId = &#63; from the database.
	 *
	 * @param companyId the company ID
	 */
	public static void removeByCompanyId(long companyId) {
		getPersistence().removeByCompanyId(companyId);
	}

	/**
	 * Returns the number of wsrp producers where companyId = &#63;.
	 *
	 * @param companyId the company ID
	 * @return the number of matching wsrp producers
	 */
	public static int countByCompanyId(long companyId) {
		return getPersistence().countByCompanyId(companyId);
	}

	/**
	 * Caches the wsrp producer in the entity cache if it is enabled.
	 *
	 * @param wsrpProducer the wsrp producer
	 */
	public static void cacheResult(WSRPProducer wsrpProducer) {
		getPersistence().cacheResult(wsrpProducer);
	}

	/**
	 * Caches the wsrp producers in the entity cache if it is enabled.
	 *
	 * @param wsrpProducers the wsrp producers
	 */
	public static void cacheResult(List<WSRPProducer> wsrpProducers) {
		getPersistence().cacheResult(wsrpProducers);
	}

	/**
	 * Creates a new wsrp producer with the primary key. Does not add the wsrp producer to the database.
	 *
	 * @param wsrpProducerId the primary key for the new wsrp producer
	 * @return the new wsrp producer
	 */
	public static WSRPProducer create(long wsrpProducerId) {
		return getPersistence().create(wsrpProducerId);
	}

	/**
	 * Removes the wsrp producer with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param wsrpProducerId the primary key of the wsrp producer
	 * @return the wsrp producer that was removed
	 * @throws NoSuchProducerException if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer remove(long wsrpProducerId)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().remove(wsrpProducerId);
	}

	public static WSRPProducer updateImpl(WSRPProducer wsrpProducer) {
		return getPersistence().updateImpl(wsrpProducer);
	}

	/**
	 * Returns the wsrp producer with the primary key or throws a <code>NoSuchProducerException</code> if it could not be found.
	 *
	 * @param wsrpProducerId the primary key of the wsrp producer
	 * @return the wsrp producer
	 * @throws NoSuchProducerException if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer findByPrimaryKey(long wsrpProducerId)
		throws com.liferay.wsrp.exception.NoSuchProducerException {

		return getPersistence().findByPrimaryKey(wsrpProducerId);
	}

	/**
	 * Returns the wsrp producer with the primary key or returns <code>null</code> if it could not be found.
	 *
	 * @param wsrpProducerId the primary key of the wsrp producer
	 * @return the wsrp producer, or <code>null</code> if a wsrp producer with the primary key could not be found
	 */
	public static WSRPProducer fetchByPrimaryKey(long wsrpProducerId) {
		return getPersistence().fetchByPrimaryKey(wsrpProducerId);
	}

	/**
	 * Returns all the wsrp producers.
	 *
	 * @return the wsrp producers
	 */
	public static List<WSRPProducer> findAll() {
		return getPersistence().findAll();
	}

	/**
	 * Returns a range of all the wsrp producers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @return the range of wsrp producers
	 */
	public static List<WSRPProducer> findAll(int start, int end) {
		return getPersistence().findAll(start, end);
	}

	/**
	 * Returns an ordered range of all the wsrp producers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of wsrp producers
	 */
	public static List<WSRPProducer> findAll(
		int start, int end, OrderByComparator<WSRPProducer> orderByComparator) {

		return getPersistence().findAll(start, end, orderByComparator);
	}

	/**
	 * Returns an ordered range of all the wsrp producers.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>WSRPProducerModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of wsrp producers
	 * @param end the upper bound of the range of wsrp producers (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @param useFinderCache whether to use the finder cache
	 * @return the ordered range of wsrp producers
	 */
	public static List<WSRPProducer> findAll(
		int start, int end, OrderByComparator<WSRPProducer> orderByComparator,
		boolean useFinderCache) {

		return getPersistence().findAll(
			start, end, orderByComparator, useFinderCache);
	}

	/**
	 * Removes all the wsrp producers from the database.
	 */
	public static void removeAll() {
		getPersistence().removeAll();
	}

	/**
	 * Returns the number of wsrp producers.
	 *
	 * @return the number of wsrp producers
	 */
	public static int countAll() {
		return getPersistence().countAll();
	}

	public static Set<String> getBadColumnNames() {
		return getPersistence().getBadColumnNames();
	}

	public static WSRPProducerPersistence getPersistence() {
		return _serviceTracker.getService();
	}

	private static ServiceTracker
		<WSRPProducerPersistence, WSRPProducerPersistence> _serviceTracker;

	static {
		Bundle bundle = FrameworkUtil.getBundle(WSRPProducerPersistence.class);

		ServiceTracker<WSRPProducerPersistence, WSRPProducerPersistence>
			serviceTracker =
				new ServiceTracker
					<WSRPProducerPersistence, WSRPProducerPersistence>(
						bundle.getBundleContext(),
						WSRPProducerPersistence.class, null);

		serviceTracker.open();

		_serviceTracker = serviceTracker;
	}

}