/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.xstream.configurator;

import aQute.bnd.annotation.ProviderType;
import com.liferay.exportimport.kernel.xstream.XStreamAliasRegistryUtil;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.xstream.configurator.XStreamConfigurator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@ProviderType
public class XStreamConfiguratorRegistryUtil {
    private static final XStreamConfiguratorRegistryUtil _instance = new XStreamConfiguratorRegistryUtil();
    private final BundleContext _bundleContext;
    private final ServiceTracker<XStreamConfigurator, XStreamConfigurator> _serviceTracker;
    private final Set<XStreamConfigurator> _xStreamConfigurators = new ConcurrentHashSet();

    public static ClassLoader getConfiguratorsClassLoader(ClassLoader masterClassLoader) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        Set<XStreamConfigurator> xStreamConfigurators = _instance._getXStreamConfigurators();
        for (XStreamConfigurator xStreamConfigurator : xStreamConfigurators) {
            Class clazz = xStreamConfigurator.getClass();
            classLoaders.add(clazz.getClassLoader());
        }
        Map aliases = XStreamAliasRegistryUtil.getAliases();
        if (MapUtil.isNotEmpty((Map)aliases)) {
            for (Class clazz : aliases.keySet()) {
                classLoaders.add(clazz.getClassLoader());
            }
        }
        return AggregateClassLoader.getAggregateClassLoader((ClassLoader)masterClassLoader, (ClassLoader[])classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }

    public static Set<XStreamConfigurator> getXStreamConfigurators() {
        return _instance._getXStreamConfigurators();
    }

    private XStreamConfiguratorRegistryUtil() {
        Bundle bundle = FrameworkUtil.getBundle(XStreamConfiguratorRegistryUtil.class);
        this._bundleContext = bundle.getBundleContext();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, XStreamConfigurator.class, (ServiceTrackerCustomizer)new XStreamConfiguratorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private Set<XStreamConfigurator> _getXStreamConfigurators() {
        return this._xStreamConfigurators;
    }

    private class XStreamConfiguratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<XStreamConfigurator, XStreamConfigurator> {
        private XStreamConfiguratorServiceTrackerCustomizer() {
        }

        public XStreamConfigurator addingService(ServiceReference<XStreamConfigurator> serviceReference) {
            XStreamConfigurator xStreamConfigurator = (XStreamConfigurator)XStreamConfiguratorRegistryUtil.this._bundleContext.getService(serviceReference);
            XStreamConfiguratorRegistryUtil.this._xStreamConfigurators.add(xStreamConfigurator);
            return xStreamConfigurator;
        }

        public void modifiedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
            this.removedService(serviceReference, xStreamConfigurator);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
            XStreamConfiguratorRegistryUtil.this._bundleContext.ungetService(serviceReference);
            XStreamConfiguratorRegistryUtil.this._xStreamConfigurators.remove(xStreamConfigurator);
        }
    }
}

