/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.xstream.configurator;

import com.liferay.exportimport.kernel.xstream.XStreamAliasRegistryUtil;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.xstream.configurator.XStreamConfigurator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class XStreamConfiguratorRegistryUtil {
    private static final AtomicLong _modifiedCount = new AtomicLong(0L);
    private static final ServiceTrackerList<XStreamConfigurator> _xStreamConfigurators;

    public static ClassLoader getConfiguratorsClassLoader(ClassLoader masterClassLoader) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (XStreamConfigurator xStreamConfigurator : _xStreamConfigurators) {
            Class clazz = xStreamConfigurator.getClass();
            classLoaders.add(clazz.getClassLoader());
        }
        Map aliases = XStreamAliasRegistryUtil.getAliases();
        if (!aliases.isEmpty()) {
            for (Class clazz : aliases.keySet()) {
                classLoaders.add(clazz.getClassLoader());
            }
        }
        return AggregateClassLoader.getAggregateClassLoader((ClassLoader)masterClassLoader, (ClassLoader[])classLoaders.toArray(new ClassLoader[0]));
    }

    public static long getModifiedCount() {
        return _modifiedCount.get();
    }

    public static List<XStreamConfigurator> getXStreamConfigurators() {
        return _xStreamConfigurators.toList();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(XStreamConfiguratorRegistryUtil.class);
        final BundleContext bundleContext = bundle.getBundleContext();
        _xStreamConfigurators = ServiceTrackerListFactory.open((BundleContext)bundleContext, XStreamConfigurator.class, null, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<XStreamConfigurator, XStreamConfigurator>(){

            public XStreamConfigurator addingService(ServiceReference<XStreamConfigurator> serviceReference) {
                _modifiedCount.getAndIncrement();
                return (XStreamConfigurator)bundleContext.getService(serviceReference);
            }

            public void modifiedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
            }

            public void removedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
                _modifiedCount.getAndIncrement();
                bundleContext.ungetService(serviceReference);
            }
        });
    }
}

