/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.util.comparator.CommerceInventoryWarehouseCityComparator;
import com.liferay.commerce.inventory.util.comparator.CommerceInventoryWarehouseItemQuantityComparator;
import com.liferay.commerce.inventory.util.comparator.CommerceInventoryWarehouseItemWarehouseNameComparator;
import com.liferay.commerce.inventory.util.comparator.CommerceInventoryWarehouseNameComparator;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentItem;
import com.liferay.commerce.util.comparator.CommerceAddressCreateDateComparator;
import com.liferay.commerce.util.comparator.CommerceAddressRestrictionCreateDateComparator;
import com.liferay.commerce.util.comparator.CommerceShipmentCreateDateComparator;
import com.liferay.commerce.util.comparator.CommerceShipmentExpectedDateComparator;
import com.liferay.commerce.util.comparator.CommerceShipmentIdComparator;
import com.liferay.commerce.util.comparator.CommerceShipmentItemCreateDateComparator;
import com.liferay.commerce.util.comparator.CommerceShipmentShippingDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.Validator;

public class CommerceUtil {
    public static long getCommerceAccountId(CommerceContext commerceContext) throws PortalException {
        if (commerceContext == null) {
            return -1L;
        }
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        if (accountEntry != null) {
            return accountEntry.getAccountEntryId();
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.isSignedIn()) {
            return 0L;
        }
        return -1L;
    }

    public static OrderByComparator<CommerceAddress> getCommerceAddressOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        CommerceAddressCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new CommerceAddressCreateDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static OrderByComparator<CommerceAddressRestriction> getCommerceAddressRestrictionOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        CommerceAddressRestrictionCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new CommerceAddressRestrictionCreateDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static Sort getCommerceAddressSort(String orderByCol, String orderByType) {
        boolean reverse = true;
        if (orderByType.equals("asc")) {
            reverse = false;
        }
        Sort sort = null;
        if (orderByCol.equals("create-date")) {
            sort = SortFactoryUtil.create((String)"createDate", (boolean)reverse);
        }
        return sort;
    }

    public static OrderByComparator<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        CommerceInventoryWarehouseItemWarehouseNameComparator orderByComparator = null;
        if (orderByCol.equals("name")) {
            orderByComparator = new CommerceInventoryWarehouseItemWarehouseNameComparator(orderByAsc);
        } else if (orderByCol.equals("quantity")) {
            orderByComparator = new CommerceInventoryWarehouseItemQuantityComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static OrderByComparator<CommerceInventoryWarehouse> getCommerceInventoryWarehouseOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        CommerceInventoryWarehouseCityComparator orderByComparator = null;
        if (orderByCol.equals("city")) {
            orderByComparator = new CommerceInventoryWarehouseCityComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new CommerceInventoryWarehouseNameComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static Sort getCommerceInventoryWarehouseSort(String orderByCol, String orderByType) {
        boolean reverse = true;
        if (orderByType.equals("asc")) {
            reverse = false;
        }
        Sort sort = null;
        if (orderByCol.equals("city")) {
            sort = SortFactoryUtil.create((String)"city", (int)3, (boolean)reverse);
        } else if (orderByCol.equals("name")) {
            sort = SortFactoryUtil.create((String)"name", (int)3, (boolean)reverse);
        }
        return sort;
    }

    public static Sort[] getCommerceOrderSorts(String orderByCol, String orderByType) {
        if (Validator.isNull((String)orderByCol) || Validator.isNull((String)orderByType)) {
            return SortFactoryUtil.getDefaultSorts();
        }
        boolean reverse = true;
        if (orderByType.equals("asc")) {
            reverse = false;
        }
        if (orderByCol.equals("create-date")) {
            return new Sort[]{SortFactoryUtil.create((String)"createDate_sortable", (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        if (orderByCol.equals("order-id")) {
            return new Sort[]{SortFactoryUtil.create((String)"entryClassPK_Number_sortable", (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        if (orderByCol.equals("total")) {
            return new Sort[]{SortFactoryUtil.create((String)"total_Number_sortable", (boolean)reverse), SortFactoryUtil.create(null, (int)0, (boolean)false)};
        }
        return SortFactoryUtil.getDefaultSorts();
    }

    public static OrderByComparator<CommerceShipmentItem> getCommerceShipmentItemOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        CommerceShipmentItemCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new CommerceShipmentItemCreateDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static OrderByComparator<CommerceShipment> getCommerceShipmentOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        if (orderByCol.equals("create-date")) {
            return new CommerceShipmentCreateDateComparator(orderByAsc);
        }
        if (orderByCol.equals("expected-delivery-date")) {
            return new CommerceShipmentExpectedDateComparator(orderByAsc);
        }
        if (orderByCol.equals("shipment-number")) {
            return new CommerceShipmentIdComparator(orderByAsc);
        }
        if (orderByCol.equals("shipping-date")) {
            return new CommerceShipmentShippingDateComparator(orderByAsc);
        }
        return null;
    }

    public static OrderByComparator<Country> getCountryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        OrderByComparator orderByComparator = null;
        if (orderByCol.equals("name")) {
            orderByComparator = OrderByComparatorFactoryUtil.create((String)"Country", (Object[])new Object[]{"name", orderByAsc});
        } else if (orderByCol.equals("priority")) {
            orderByComparator = OrderByComparatorFactoryUtil.create((String)"Country", (Object[])new Object[]{"position", orderByAsc});
        }
        return orderByComparator;
    }

    public static OrderByComparator<Region> getRegionOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        OrderByComparator orderByComparator = null;
        if (orderByCol.equals("name")) {
            orderByComparator = OrderByComparatorFactoryUtil.create((String)"Region", (Object[])new Object[]{"name", orderByAsc});
        } else if (orderByCol.equals("priority")) {
            orderByComparator = OrderByComparatorFactoryUtil.create((String)"Region", (Object[])new Object[]{"position", orderByAsc});
        }
        return orderByComparator;
    }
}

