/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.application.internal.permission;

import com.liferay.commerce.application.model.CommerceApplicationModel;
import com.liferay.commerce.application.permission.CommerceApplicationModelPermission;
import com.liferay.commerce.application.service.CommerceApplicationModelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceApplicationModelPermission.class})
public class CommerceApplicationModelPermissionImpl
implements CommerceApplicationModelPermission {
    @Reference
    private CommerceApplicationModelLocalService _commerceApplicationModelLocalService;

    public void check(PermissionChecker permissionChecker, CommerceApplicationModel commerceApplicationModel, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceApplicationModel, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceApplicationModel.class.getName(), commerceApplicationModel.getCommerceApplicationModelId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceApplicationModelId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceApplicationModelId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceApplicationModel.class.getName(), commerceApplicationModelId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceApplicationModel commerceApplicationModel, String actionId) {
        return this.contains(permissionChecker, commerceApplicationModel.getCommerceApplicationModelId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceApplicationModelId, String actionId) {
        CommerceApplicationModel commerceApplicationModel = this._commerceApplicationModelLocalService.fetchCommerceApplicationModel(commerceApplicationModelId);
        if (commerceApplicationModel == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceApplicationModel, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceApplicationModelIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceApplicationModelIds)) {
            return false;
        }
        for (long commerceApplicationModelId : commerceApplicationModelIds) {
            if (this.contains(permissionChecker, commerceApplicationModelId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceApplicationModel commerceApplicationModel, String actionId) {
        if (permissionChecker.isCompanyAdmin(commerceApplicationModel.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceApplicationModel.class.getName(), commerceApplicationModel.getCommerceApplicationModelId(), permissionChecker.getUserId(), actionId) && commerceApplicationModel.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceApplicationModel.class.getName(), commerceApplicationModel.getCommerceApplicationModelId(), actionId);
    }
}

