/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.util;

import com.liferay.commerce.currency.internal.configuration.ECBExchangeRateProviderConfiguration;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.util.ExchangeRateProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.currency.internal.configuration.ECBExchangeRateProviderConfiguration"}, enabled=false, immediate=true, property={"commerce.exchange.provider.key=european-central-bank"}, service={ExchangeRateProvider.class})
public class ECBExchangeRateProvider
implements ExchangeRateProvider {
    @Reference
    private Http _http;
    @Reference
    private SAXReader _saxReader;
    private volatile String _url;

    public BigDecimal getExchangeRate(CommerceCurrency primaryCommerceCurrency, CommerceCurrency secondaryCommerceCurrency) throws Exception {
        String primaryCurrencyCode = primaryCommerceCurrency.getCode();
        String secondaryCurrencyCode = secondaryCommerceCurrency.getCode();
        primaryCurrencyCode = StringUtil.toUpperCase((String)primaryCurrencyCode);
        secondaryCurrencyCode = StringUtil.toUpperCase((String)secondaryCurrencyCode);
        String xml = null;
        int i = 0;
        while (Validator.isNull(xml)) {
            block8: {
                try {
                    xml = this._http.URLtoString(this._getURL());
                }
                catch (IOException ioException) {
                    if (i++ < 10) break block8;
                    throw ioException;
                }
            }
            if (i < 10) continue;
            throw new PortalException("Impossible to load " + this._url);
        }
        Document document = this._saxReader.read(xml);
        Element rootElement = document.getRootElement();
        List rootCubeElements = rootElement.elements("Cube");
        Element rootCubeElement = (Element)rootCubeElements.get(0);
        List cubeParentElements = rootCubeElement.elements("Cube");
        Element cubeParentElement = (Element)cubeParentElements.get(0);
        List cubeElements = cubeParentElement.elements("Cube");
        BigDecimal rateToPrimary = BigDecimal.ZERO;
        BigDecimal rateToSecondary = BigDecimal.ZERO;
        for (Element cubeElement : cubeElements) {
            String currency = cubeElement.attributeValue("currency");
            BigDecimal rate = new BigDecimal(cubeElement.attributeValue("rate"));
            if (currency.equals(primaryCurrencyCode)) {
                rateToPrimary = rate;
            }
            if (currency.equals(secondaryCurrencyCode)) {
                rateToSecondary = rate;
            }
            if (rateToPrimary.compareTo(BigDecimal.ZERO) <= 0 || rateToSecondary.compareTo(BigDecimal.ZERO) <= 0) continue;
            break;
        }
        if (primaryCurrencyCode.equals("EUR")) {
            rateToPrimary = BigDecimal.ONE;
        }
        if (secondaryCurrencyCode.equals("EUR")) {
            rateToSecondary = BigDecimal.ONE;
        }
        return rateToSecondary.divide(rateToPrimary, 4, RoundingMode.HALF_EVEN);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ECBExchangeRateProviderConfiguration ecbExchangeRateProviderConfiguration = (ECBExchangeRateProviderConfiguration)ConfigurableUtil.createConfigurable(ECBExchangeRateProviderConfiguration.class, properties);
        this._url = ecbExchangeRateProviderConfiguration.europeanCentralBankURL();
    }

    @Deactivate
    protected void deactivate() {
        this._url = null;
    }

    private URL _getURL() throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(this._url);
        if (url == null) {
            url = new URL(this._url);
        }
        return url;
    }
}

