/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.service.impl;

import com.liferay.commerce.currency.configuration.CommerceCurrencyConfiguration;
import com.liferay.commerce.currency.configuration.RoundingTypeConfiguration;
import com.liferay.commerce.currency.exception.CommerceCurrencyCodeException;
import com.liferay.commerce.currency.exception.CommerceCurrencyNameException;
import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.base.CommerceCurrencyLocalServiceBaseImpl;
import com.liferay.commerce.currency.util.ExchangeRateProvider;
import com.liferay.commerce.currency.util.ExchangeRateProviderRegistry;
import com.liferay.commerce.currency.util.comparator.CommerceCurrencyPriorityComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceCurrencyLocalServiceImpl
extends CommerceCurrencyLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceCurrencyLocalServiceImpl.class);
    @ServiceReference(type=ConfigurationProvider.class)
    private ConfigurationProvider _configurationProvider;
    @ServiceReference(type=ExchangeRateProviderRegistry.class)
    private ExchangeRateProviderRegistry _exchangeRateProviderRegistry;

    public CommerceCurrency addCommerceCurrency(long userId, String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (primary) {
            rate = BigDecimal.ONE;
        }
        this.validate(0L, user.getCompanyId(), code, nameMap, primary);
        if (formatPatternMap.isEmpty()) {
            formatPatternMap.put(user.getLocale(), "###,##0.00");
        }
        if (Validator.isNull((String)roundingMode)) {
            RoundingTypeConfiguration roundingTypeConfiguration = (RoundingTypeConfiguration)this._configurationProvider.getConfiguration(RoundingTypeConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.currency.rounding.type"));
            RoundingMode roundingModeEnum = roundingTypeConfiguration.roundingMode();
            roundingMode = roundingModeEnum.name();
        }
        long commerceCurrencyId = this.counterLocalService.increment();
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.create(commerceCurrencyId);
        commerceCurrency.setCompanyId(user.getCompanyId());
        commerceCurrency.setUserId(user.getUserId());
        commerceCurrency.setUserName(user.getFullName());
        commerceCurrency.setCode(code);
        commerceCurrency.setNameMap(nameMap);
        commerceCurrency.setSymbol(symbol);
        commerceCurrency.setRate(rate);
        commerceCurrency.setFormatPatternMap(formatPatternMap);
        commerceCurrency.setMaxFractionDigits(maxFractionDigits);
        commerceCurrency.setMinFractionDigits(minFractionDigits);
        commerceCurrency.setRoundingMode(roundingMode);
        commerceCurrency.setPrimary(primary);
        commerceCurrency.setPriority(priority);
        commerceCurrency.setActive(active);
        return (CommerceCurrency)this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
    }

    public void deleteCommerceCurrencies(long companyId) {
        this.commerceCurrencyPersistence.removeByCompanyId(companyId);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceCurrency deleteCommerceCurrency(CommerceCurrency commerceCurrency) {
        return (CommerceCurrency)this.commerceCurrencyPersistence.remove((BaseModel)commerceCurrency);
    }

    @Override
    public CommerceCurrency deleteCommerceCurrency(long commerceCurrencyId) throws PortalException {
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        return this.commerceCurrencyLocalService.deleteCommerceCurrency(commerceCurrency);
    }

    public CommerceCurrency fetchPrimaryCommerceCurrency(long companyId) {
        return this.commerceCurrencyPersistence.fetchByC_P_A_First(companyId, true, true, (OrderByComparator)new CommerceCurrencyPriorityComparator());
    }

    public List<CommerceCurrency> getCommerceCurrencies(long companyId, boolean active) {
        return this.commerceCurrencyPersistence.findByC_A(companyId, active);
    }

    public List<CommerceCurrency> getCommerceCurrencies(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.commerceCurrencyPersistence.findByC_A(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceCurrency> getCommerceCurrencies(long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.commerceCurrencyPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCommerceCurrenciesCount(long companyId) {
        return this.commerceCurrencyPersistence.countByCompanyId(companyId);
    }

    public int getCommerceCurrenciesCount(long companyId, boolean active) {
        return this.commerceCurrencyPersistence.countByC_A(companyId, active);
    }

    public CommerceCurrency getCommerceCurrency(long companyId, String code) throws NoSuchCurrencyException {
        return this.commerceCurrencyPersistence.findByC_C(companyId, code);
    }

    public void importDefaultValues(ServiceContext serviceContext) throws Exception {
        block1: {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            String currenciesPath = "com/liferay/commerce/currency/service/impl/dependencies/currencies.json";
            String countriesJSON = StringUtil.read((ClassLoader)clazz.getClassLoader(), (String)currenciesPath, (boolean)false);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)countriesJSON);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String code = jsonObject.getString("code");
                CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.fetchByC_C(serviceContext.getCompanyId(), code);
                if (commerceCurrency != null) continue;
                boolean primary = jsonObject.getBoolean("primary");
                double priority = jsonObject.getDouble("priority");
                String symbol = jsonObject.getString("symbol");
                RoundingTypeConfiguration roundingTypeConfiguration = (RoundingTypeConfiguration)this._configurationProvider.getConfiguration(RoundingTypeConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.currency.rounding.type"));
                HashMap nameMap = HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)jsonObject.getString("name")).build();
                StringBundler sb = new StringBundler(3);
                sb.append(symbol);
                sb.append(" ");
                sb.append("###,##0.00");
                HashMap formatPatternMap = HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)sb.toString()).build();
                RoundingMode roundingMode = roundingTypeConfiguration.roundingMode();
                this.commerceCurrencyLocalService.addCommerceCurrency(serviceContext.getUserId(), code, (Map)nameMap, symbol, BigDecimal.ONE, (Map)formatPatternMap, roundingTypeConfiguration.maximumFractionDigits(), roundingTypeConfiguration.minimumFractionDigits(), roundingMode.name(), primary, priority, true);
            }
            Iterator iterator = this._exchangeRateProviderRegistry.getExchangeRateProviderKeys().iterator();
            if (!iterator.hasNext()) break block1;
            String exchangeRateProviderKey = (String)iterator.next();
            this._updateExchangeRates(serviceContext.getCompanyId(), exchangeRateProviderKey);
        }
    }

    public CommerceCurrency setActive(long commerceCurrencyId, boolean active) throws PortalException {
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        commerceCurrency.setActive(active);
        return (CommerceCurrency)this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
    }

    public CommerceCurrency setPrimary(long commerceCurrencyId, boolean primary) throws PortalException {
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        this.validate(commerceCurrencyId, commerceCurrency.getCompanyId(), commerceCurrency.getCode(), commerceCurrency.getNameMap(), primary);
        commerceCurrency.setPrimary(primary);
        return (CommerceCurrency)this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
    }

    public CommerceCurrency updateCommerceCurrency(long commerceCurrencyId, String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        if (primary) {
            rate = BigDecimal.ONE;
        }
        this.validate(commerceCurrency.getCommerceCurrencyId(), serviceContext.getCompanyId(), code, nameMap, primary);
        if (formatPatternMap.isEmpty()) {
            formatPatternMap.put(serviceContext.getLocale(), "###,##0.00");
        }
        if (Validator.isNull((String)roundingMode)) {
            RoundingTypeConfiguration roundingTypeConfiguration = (RoundingTypeConfiguration)this._configurationProvider.getConfiguration(RoundingTypeConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.currency.rounding.type"));
            RoundingMode roundingModeEnum = roundingTypeConfiguration.roundingMode();
            roundingMode = roundingModeEnum.name();
        }
        commerceCurrency.setCode(code);
        commerceCurrency.setNameMap(nameMap);
        commerceCurrency.setSymbol(symbol);
        commerceCurrency.setRate(rate);
        commerceCurrency.setFormatPatternMap(formatPatternMap);
        commerceCurrency.setMaxFractionDigits(maxFractionDigits);
        commerceCurrency.setMinFractionDigits(minFractionDigits);
        commerceCurrency.setRoundingMode(roundingMode);
        commerceCurrency.setPrimary(primary);
        commerceCurrency.setPriority(priority);
        commerceCurrency.setActive(active);
        return (CommerceCurrency)this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
    }

    public CommerceCurrency updateCommerceCurrencyRate(long commerceCurrencyId, BigDecimal rate) throws PortalException {
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        commerceCurrency.setRate(rate);
        return (CommerceCurrency)this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
    }

    public void updateExchangeRate(long commerceCurrencyId, String exchangeRateProviderKey) throws PortalException {
        ExchangeRateProvider exchangeRateProvider = this._exchangeRateProviderRegistry.getExchangeRateProvider(exchangeRateProviderKey);
        if (exchangeRateProvider == null) {
            return;
        }
        CommerceCurrency commerceCurrency = this.commerceCurrencyPersistence.findByPrimaryKey(commerceCurrencyId);
        CommerceCurrency primaryCommerceCurrency = this.commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(commerceCurrency.getCompanyId());
        if (primaryCommerceCurrency == null) {
            return;
        }
        BigDecimal exchangeRate = BigDecimal.ZERO;
        try {
            exchangeRate = exchangeRateProvider.getExchangeRate(primaryCommerceCurrency, commerceCurrency);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return;
        }
        commerceCurrency.setRate(exchangeRate);
        this.commerceCurrencyLocalService.updateCommerceCurrency(commerceCurrency);
    }

    public void updateExchangeRates() throws PortalException {
        long[] companyIds;
        for (long companyId : companyIds = ArrayUtil.toLongArray((Collection)this.commerceCurrencyFinder.getCompanyIds())) {
            CommerceCurrencyConfiguration commerceCurrencyConfiguration = (CommerceCurrencyConfiguration)this._configurationProvider.getConfiguration(CommerceCurrencyConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.commerce.currency.exchange.rate"));
            if (!commerceCurrencyConfiguration.enableAutoUpdate()) continue;
            String defaultExchangeRateProviderKey = commerceCurrencyConfiguration.defaultExchangeRateProviderKey();
            this._updateExchangeRates(companyId, defaultExchangeRateProviderKey);
        }
    }

    protected void validate(long commerceCurrencyId, long companyId, String code, Map<Locale, String> nameMap, boolean primary) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (Validator.isNull((String)code)) {
            throw new CommerceCurrencyCodeException();
        }
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommerceCurrencyNameException();
        }
        if (primary) {
            List commerceCurrencies = this.commerceCurrencyPersistence.findByC_P(companyId, primary);
            for (CommerceCurrency commerceCurrency : commerceCurrencies) {
                if (commerceCurrency.getCommerceCurrencyId() == commerceCurrencyId) continue;
                commerceCurrency.setPrimary(false);
                this.commerceCurrencyPersistence.update((BaseModel)commerceCurrency);
            }
        }
    }

    private void _updateExchangeRates(long companyId, String exchangeRateProviderKey) throws PortalException {
        List commerceCurrencies = this.commerceCurrencyLocalService.getCommerceCurrencies(companyId, true);
        for (CommerceCurrency commerceCurrency : commerceCurrencies) {
            this.commerceCurrencyLocalService.updateExchangeRate(commerceCurrency.getCommerceCurrencyId(), exchangeRateProviderKey);
        }
    }
}

