/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.service.persistence.impl;

import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceCurrencyTable;
import com.liferay.commerce.currency.model.impl.CommerceCurrencyImpl;
import com.liferay.commerce.currency.model.impl.CommerceCurrencyModelImpl;
import com.liferay.commerce.currency.service.persistence.CommerceCurrencyPersistence;
import com.liferay.commerce.currency.service.persistence.CommerceCurrencyUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceCurrencyPersistenceImpl
extends BasePersistenceImpl<CommerceCurrency>
implements CommerceCurrencyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceCurrencyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "commerceCurrency.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(commerceCurrency.uuid IS NULL OR commerceCurrency.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "commerceCurrency.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(commerceCurrency.uuid IS NULL OR commerceCurrency.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "commerceCurrency.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceCurrency.companyId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_COMPANYID_2 = "commerceCurrency.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CODE_2 = "commerceCurrency.code = ?";
    private static final String _FINDER_COLUMN_C_C_CODE_3 = "(commerceCurrency.code IS NULL OR commerceCurrency.code = '')";
    private FinderPath _finderPathWithPaginationFindByC_P;
    private FinderPath _finderPathWithoutPaginationFindByC_P;
    private FinderPath _finderPathCountByC_P;
    private static final String _FINDER_COLUMN_C_P_COMPANYID_2 = "commerceCurrency.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_PRIMARY_2 = "commerceCurrency.primary = ?";
    private FinderPath _finderPathWithPaginationFindByC_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A;
    private FinderPath _finderPathCountByC_A;
    private static final String _FINDER_COLUMN_C_A_COMPANYID_2 = "commerceCurrency.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_ACTIVE_2 = "commerceCurrency.active = ?";
    private FinderPath _finderPathWithPaginationFindByC_P_A;
    private FinderPath _finderPathWithoutPaginationFindByC_P_A;
    private FinderPath _finderPathCountByC_P_A;
    private static final String _FINDER_COLUMN_C_P_A_COMPANYID_2 = "commerceCurrency.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_A_PRIMARY_2 = "commerceCurrency.primary = ? AND ";
    private static final String _FINDER_COLUMN_C_P_A_ACTIVE_2 = "commerceCurrency.active = ?";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCECURRENCY = "SELECT commerceCurrency FROM CommerceCurrency commerceCurrency";
    private static final String _SQL_SELECT_COMMERCECURRENCY_WHERE = "SELECT commerceCurrency FROM CommerceCurrency commerceCurrency WHERE ";
    private static final String _SQL_COUNT_COMMERCECURRENCY = "SELECT COUNT(commerceCurrency) FROM CommerceCurrency commerceCurrency";
    private static final String _SQL_COUNT_COMMERCECURRENCY_WHERE = "SELECT COUNT(commerceCurrency) FROM CommerceCurrency commerceCurrency WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceCurrency.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceCurrency exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceCurrency exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceCurrencyPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "code", "primary", "active"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceCurrency> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<CommerceCurrency> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<CommerceCurrency> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (uuid.equals(commerceCurrency.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByUuid_First(String uuid, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByUuid_First(uuid, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByUuid_First(String uuid, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByUuid_Last(String uuid, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByUuid_Last(uuid, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByUuid_Last(String uuid, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByUuid_PrevAndNext(long commerceCurrencyId, String uuid, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        uuid = Objects.toString(uuid, "");
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByUuid_PrevAndNext(session, commerceCurrency, uuid, orderByComparator, true), commerceCurrency, this.getByUuid_PrevAndNext(session, commerceCurrency, uuid, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByUuid_PrevAndNext(Session session, CommerceCurrency commerceCurrency, String uuid, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (CommerceCurrency commerceCurrency : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCurrency> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<CommerceCurrency> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<CommerceCurrency> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (uuid.equals(commerceCurrency.getUuid()) && companyId == commerceCurrency.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("commerceCurrency.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByUuid_C_PrevAndNext(long commerceCurrencyId, String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        uuid = Objects.toString(uuid, "");
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByUuid_C_PrevAndNext(session, commerceCurrency, uuid, companyId, orderByComparator, true), commerceCurrency, this.getByUuid_C_PrevAndNext(session, commerceCurrency, uuid, companyId, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByUuid_C_PrevAndNext(Session session, CommerceCurrency commerceCurrency, String uuid, long companyId, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("commerceCurrency.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (CommerceCurrency commerceCurrency : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("commerceCurrency.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCurrency> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceCurrency> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceCurrency> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (companyId == commerceCurrency.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByCompanyId_First(long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByCompanyId_First(long companyId, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByCompanyId_Last(long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByCompanyId_PrevAndNext(long commerceCurrencyId, long companyId, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByCompanyId_PrevAndNext(session, commerceCurrency, companyId, orderByComparator, true), commerceCurrency, this.getByCompanyId_PrevAndNext(session, commerceCurrency, companyId, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByCompanyId_PrevAndNext(Session session, CommerceCurrency commerceCurrency, long companyId, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        sb.append("commerceCurrency.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceCurrency commerceCurrency : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCurrency findByC_C(long companyId, String code) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_C(companyId, code);
        if (commerceCurrency == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", code=");
            sb.append(code);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCurrencyException(sb.toString());
        }
        return commerceCurrency;
    }

    public CommerceCurrency fetchByC_C(long companyId, String code) {
        return this.fetchByC_C(companyId, code, true);
    }

    public CommerceCurrency fetchByC_C(long companyId, String code, boolean useFinderCache) {
        CommerceCurrency commerceCurrency;
        code = Objects.toString(code, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, code};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceCurrency && (companyId != (commerceCurrency = (CommerceCurrency)result).getCompanyId() || !Objects.equals(code, commerceCurrency.getCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            boolean bindCode = false;
            if (code.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_CODE_3);
            } else {
                bindCode = true;
                sb.append(_FINDER_COLUMN_C_C_CODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindCode) {
                    queryPos.add(code);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    CommerceCurrency commerceCurrency2 = (CommerceCurrency)list.get(0);
                    result = commerceCurrency2;
                    this.cacheResult(commerceCurrency2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceCurrency)result;
    }

    public CommerceCurrency removeByC_C(long companyId, String code) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.findByC_C(companyId, code);
        return (CommerceCurrency)this.remove((BaseModel)commerceCurrency);
    }

    public int countByC_C(long companyId, String code) {
        code = Objects.toString(code, "");
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{companyId, code};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            boolean bindCode = false;
            if (code.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_CODE_3);
            } else {
                bindCode = true;
                sb.append(_FINDER_COLUMN_C_C_CODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindCode) {
                    queryPos.add(code);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCurrency> findByC_P(long companyId, boolean primary) {
        return this.findByC_P(companyId, primary, -1, -1, null);
    }

    public List<CommerceCurrency> findByC_P(long companyId, boolean primary, int start, int end) {
        return this.findByC_P(companyId, primary, start, end, null);
    }

    public List<CommerceCurrency> findByC_P(long companyId, boolean primary, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByC_P(companyId, primary, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByC_P(long companyId, boolean primary, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_P;
                finderArgs = new Object[]{companyId, primary};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_P;
            finderArgs = new Object[]{companyId, primary, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (companyId == commerceCurrency.getCompanyId() && primary == commerceCurrency.isPrimary()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_P_PRIMARY_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(primary);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByC_P_First(long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_P_First(companyId, primary, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", primary=");
        sb.append(primary);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_P_First(long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByC_P(companyId, primary, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByC_P_Last(long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_P_Last(companyId, primary, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", primary=");
        sb.append(primary);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_P_Last(long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByC_P(companyId, primary);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByC_P(companyId, primary, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByC_P_PrevAndNext(long commerceCurrencyId, long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByC_P_PrevAndNext(session, commerceCurrency, companyId, primary, orderByComparator, true), commerceCurrency, this.getByC_P_PrevAndNext(session, commerceCurrency, companyId, primary, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByC_P_PrevAndNext(Session session, CommerceCurrency commerceCurrency, long companyId, boolean primary, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        sb.append("commerceCurrency.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_P_PRIMARY_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(primary);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByC_P(long companyId, boolean primary) {
        for (CommerceCurrency commerceCurrency : this.findByC_P(companyId, primary, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByC_P(long companyId, boolean primary) {
        FinderPath finderPath = this._finderPathCountByC_P;
        Object[] finderArgs = new Object[]{companyId, primary};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_P_PRIMARY_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(primary);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCurrency> findByC_A(long companyId, boolean active) {
        return this.findByC_A(companyId, active, -1, -1, null);
    }

    public List<CommerceCurrency> findByC_A(long companyId, boolean active, int start, int end) {
        return this.findByC_A(companyId, active, start, end, null);
    }

    public List<CommerceCurrency> findByC_A(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByC_A(companyId, active, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByC_A(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_A;
                finderArgs = new Object[]{companyId, active};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_A;
            finderArgs = new Object[]{companyId, active, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (companyId == commerceCurrency.getCompanyId() && active == commerceCurrency.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append("commerceCurrency.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(active);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByC_A_First(long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_A_First(companyId, active, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_A_First(long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByC_A(companyId, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByC_A_Last(long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_A_Last(companyId, active, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_A_Last(long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByC_A(companyId, active);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByC_A(companyId, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByC_A_PrevAndNext(long commerceCurrencyId, long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByC_A_PrevAndNext(session, commerceCurrency, companyId, active, orderByComparator, true), commerceCurrency, this.getByC_A_PrevAndNext(session, commerceCurrency, companyId, active, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByC_A_PrevAndNext(Session session, CommerceCurrency commerceCurrency, long companyId, boolean active, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        sb.append("commerceCurrency.companyId = ? AND ");
        sb.append("commerceCurrency.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByC_A(long companyId, boolean active) {
        for (CommerceCurrency commerceCurrency : this.findByC_A(companyId, active, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByC_A(long companyId, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_A;
        Object[] finderArgs = new Object[]{companyId, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append("commerceCurrency.active = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(active);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCurrency> findByC_P_A(long companyId, boolean primary, boolean active) {
        return this.findByC_P_A(companyId, primary, active, -1, -1, null);
    }

    public List<CommerceCurrency> findByC_P_A(long companyId, boolean primary, boolean active, int start, int end) {
        return this.findByC_P_A(companyId, primary, active, start, end, null);
    }

    public List<CommerceCurrency> findByC_P_A(long companyId, boolean primary, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findByC_P_A(companyId, primary, active, start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findByC_P_A(long companyId, boolean primary, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_P_A;
                finderArgs = new Object[]{companyId, primary, active};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_P_A;
            finderArgs = new Object[]{companyId, primary, active, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCurrency commerceCurrency : list) {
                if (companyId == commerceCurrency.getCompanyId() && primary == commerceCurrency.isPrimary() && active == commerceCurrency.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_P_A_PRIMARY_2);
            sb.append("commerceCurrency.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCurrency.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(primary);
                queryPos.add(active);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCurrency findByC_P_A_First(long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_P_A_First(companyId, primary, active, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", primary=");
        sb.append(primary);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_P_A_First(long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) {
        List<CommerceCurrency> list = this.findByC_P_A(companyId, primary, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency findByC_P_A_Last(long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.fetchByC_P_A_Last(companyId, primary, active, orderByComparator);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", primary=");
        sb.append(primary);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCurrencyException(sb.toString());
    }

    public CommerceCurrency fetchByC_P_A_Last(long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) {
        int count = this.countByC_P_A(companyId, primary, active);
        if (count == 0) {
            return null;
        }
        List<CommerceCurrency> list = this.findByC_P_A(companyId, primary, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCurrency[] findByC_P_A_PrevAndNext(long commerceCurrencyId, long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = this.findByPrimaryKey(commerceCurrencyId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency[] array = new CommerceCurrencyImpl[]{this.getByC_P_A_PrevAndNext(session, commerceCurrency, companyId, primary, active, orderByComparator, true), commerceCurrency, this.getByC_P_A_PrevAndNext(session, commerceCurrency, companyId, primary, active, orderByComparator, false)};
            CommerceCurrency[] commerceCurrencyArray = array;
            return commerceCurrencyArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency getByC_P_A_PrevAndNext(Session session, CommerceCurrency commerceCurrency, long companyId, boolean primary, boolean active, OrderByComparator<CommerceCurrency> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_COMMERCECURRENCY_WHERE);
        sb.append("commerceCurrency.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_P_A_PRIMARY_2);
        sb.append("commerceCurrency.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCurrency.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(primary);
        queryPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCurrency)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCurrency)list.get(1);
        }
        return null;
    }

    public void removeByC_P_A(long companyId, boolean primary, boolean active) {
        for (CommerceCurrency commerceCurrency : this.findByC_P_A(companyId, primary, active, -1, -1, null)) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countByC_P_A(long companyId, boolean primary, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_P_A;
        Object[] finderArgs = new Object[]{companyId, primary, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_COMMERCECURRENCY_WHERE);
            sb.append("commerceCurrency.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_P_A_PRIMARY_2);
            sb.append("commerceCurrency.active = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(primary);
                queryPos.add(active);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCurrencyPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("code", "code_");
        dbColumnNames.put("primary", "primary_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceCurrency.class);
        this.setModelImplClass(CommerceCurrencyImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceCurrencyTable.INSTANCE);
    }

    public void cacheResult(CommerceCurrency commerceCurrency) {
        this.entityCache.putResult(CommerceCurrencyImpl.class, (Serializable)Long.valueOf(commerceCurrency.getPrimaryKey()), (Serializable)commerceCurrency);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{commerceCurrency.getCompanyId(), commerceCurrency.getCode()}, (Object)commerceCurrency);
    }

    public void cacheResult(List<CommerceCurrency> commerceCurrencies) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceCurrencies.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceCurrency commerceCurrency : commerceCurrencies) {
            if (this.entityCache.getResult(CommerceCurrencyImpl.class, (Serializable)Long.valueOf(commerceCurrency.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceCurrency);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceCurrencyImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceCurrency commerceCurrency) {
        this.entityCache.removeResult(CommerceCurrencyImpl.class, (BaseModel)commerceCurrency);
    }

    public void clearCache(List<CommerceCurrency> commerceCurrencies) {
        for (CommerceCurrency commerceCurrency : commerceCurrencies) {
            this.entityCache.removeResult(CommerceCurrencyImpl.class, (BaseModel)commerceCurrency);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceCurrencyImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceCurrencyModelImpl commerceCurrencyModelImpl) {
        Object[] args = new Object[]{commerceCurrencyModelImpl.getCompanyId(), commerceCurrencyModelImpl.getCode()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)commerceCurrencyModelImpl, false);
    }

    public CommerceCurrency create(long commerceCurrencyId) {
        CommerceCurrencyImpl commerceCurrency = new CommerceCurrencyImpl();
        commerceCurrency.setNew(true);
        commerceCurrency.setPrimaryKey(commerceCurrencyId);
        String uuid = PortalUUIDUtil.generate();
        commerceCurrency.setUuid(uuid);
        commerceCurrency.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceCurrency;
    }

    public CommerceCurrency remove(long commerceCurrencyId) throws NoSuchCurrencyException {
        return this.remove(Long.valueOf(commerceCurrencyId));
    }

    public CommerceCurrency remove(Serializable primaryKey) throws NoSuchCurrencyException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceCurrency commerceCurrency = (CommerceCurrency)session.get(CommerceCurrencyImpl.class, primaryKey);
            if (commerceCurrency == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCurrencyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceCurrency commerceCurrency2 = (CommerceCurrency)this.remove((BaseModel)commerceCurrency);
            return commerceCurrency2;
        }
        catch (NoSuchCurrencyException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCurrency removeImpl(CommerceCurrency commerceCurrency) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceCurrency)) {
                commerceCurrency = (CommerceCurrency)session.get(CommerceCurrencyImpl.class, commerceCurrency.getPrimaryKeyObj());
            }
            if (commerceCurrency != null) {
                session.delete((Object)commerceCurrency);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceCurrency != null) {
            this.clearCache(commerceCurrency);
        }
        return commerceCurrency;
    }

    public CommerceCurrency updateImpl(CommerceCurrency commerceCurrency) {
        boolean isNew = commerceCurrency.isNew();
        if (!(commerceCurrency instanceof CommerceCurrencyModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceCurrency.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceCurrency);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceCurrency proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceCurrency implementation " + commerceCurrency.getClass());
        }
        CommerceCurrencyModelImpl commerceCurrencyModelImpl = (CommerceCurrencyModelImpl)commerceCurrency;
        if (Validator.isNull((String)commerceCurrency.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            commerceCurrency.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceCurrency.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceCurrency.setCreateDate(date);
            } else {
                commerceCurrency.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceCurrencyModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceCurrency.setModifiedDate(date);
            } else {
                commerceCurrency.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceCurrency);
            } else {
                commerceCurrency = (CommerceCurrency)session.merge((Object)commerceCurrency);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceCurrencyImpl.class, (BaseModel)commerceCurrencyModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceCurrencyModelImpl);
        if (isNew) {
            commerceCurrency.setNew(false);
        }
        commerceCurrency.resetOriginalValues();
        return commerceCurrency;
    }

    public CommerceCurrency findByPrimaryKey(Serializable primaryKey) throws NoSuchCurrencyException {
        CommerceCurrency commerceCurrency = (CommerceCurrency)this.fetchByPrimaryKey(primaryKey);
        if (commerceCurrency == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCurrencyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceCurrency;
    }

    public CommerceCurrency findByPrimaryKey(long commerceCurrencyId) throws NoSuchCurrencyException {
        return this.findByPrimaryKey(Long.valueOf(commerceCurrencyId));
    }

    public CommerceCurrency fetchByPrimaryKey(long commerceCurrencyId) {
        return (CommerceCurrency)this.fetchByPrimaryKey(Long.valueOf(commerceCurrencyId));
    }

    public List<CommerceCurrency> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceCurrency> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceCurrency> findAll(int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceCurrency> findAll(int start, int end, OrderByComparator<CommerceCurrency> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCECURRENCY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCECURRENCY;
                sql = sql.concat(" ORDER BY commerceCurrency.priority ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceCurrency commerceCurrency : this.findAll()) {
            this.remove((BaseModel)commerceCurrency);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCECURRENCY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceCurrencyId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCECURRENCY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceCurrencyModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceCurrencyPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceCurrencyModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceCurrency.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByC_C = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "code_"}, true);
        this._finderPathCountByC_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "code_"}, false);
        this._finderPathWithPaginationFindByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "primary_"}, true);
        this._finderPathWithoutPaginationFindByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "primary_"}, true);
        this._finderPathCountByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_P", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "primary_"}, false);
        this._finderPathWithPaginationFindByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "active_"}, true);
        this._finderPathWithoutPaginationFindByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "active_"}, true);
        this._finderPathCountByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "active_"}, false);
        this._finderPathWithPaginationFindByC_P_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_P_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "primary_", "active_"}, true);
        this._finderPathWithoutPaginationFindByC_P_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_P_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "primary_", "active_"}, true);
        this._finderPathCountByC_P_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_P_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "primary_", "active_"}, false);
        this._setCommerceCurrencyUtilPersistence(this);
    }

    public void destroy() {
        this._setCommerceCurrencyUtilPersistence(null);
        this.entityCache.removeCache(CommerceCurrencyImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _setCommerceCurrencyUtilPersistence(CommerceCurrencyPersistence commerceCurrencyPersistence) {
        try {
            Field field = CommerceCurrencyUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, commerceCurrencyPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceCurrencyModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceCurrencyModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            CommerceCurrencyModelImpl commerceCurrencyModelImpl = (CommerceCurrencyModelImpl)baseModel;
            long columnBitmask = commerceCurrencyModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceCurrencyModelArgumentsResolver._getValue(commerceCurrencyModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceCurrencyModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceCurrencyModelArgumentsResolver._getValue(commerceCurrencyModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(CommerceCurrencyModelImpl commerceCurrencyModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceCurrencyModelImpl.getColumnOriginalValue(columnName) : commerceCurrencyModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceCurrencyModelImpl.getColumnBitmask("priority");
        }
    }
}

