/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.service.impl;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.base.CommerceCurrencyServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommerceCurrencyServiceImpl
extends CommerceCurrencyServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceCurrencyServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.currency");

    public CommerceCurrency addCommerceCurrency(String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.addCommerceCurrency(this.getUserId(), code, nameMap, symbol, rate, formatPatternMap, maxFractionDigits, minFractionDigits, roundingMode, primary, priority, active);
    }

    public void deleteCommerceCurrency(long commerceCurrencyId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        this.commerceCurrencyLocalService.deleteCommerceCurrency(commerceCurrencyId);
    }

    public CommerceCurrency fetchPrimaryCommerceCurrency(long companyId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(companyId);
    }

    public List<CommerceCurrency> getCommerceCurrencies(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrencies(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceCurrency> getCommerceCurrencies(long companyId, int start, int end, OrderByComparator<CommerceCurrency> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrencies(companyId, start, end, orderByComparator);
    }

    public int getCommerceCurrenciesCount(long companyId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrenciesCount(companyId);
    }

    public int getCommerceCurrenciesCount(long companyId, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrenciesCount(companyId, active);
    }

    public CommerceCurrency getCommerceCurrency(long commerceCurrencyId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrency(commerceCurrencyId);
    }

    public CommerceCurrency getCommerceCurrency(long companyId, String code) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.getCommerceCurrency(companyId, code);
    }

    public CommerceCurrency setActive(long commerceCurrencyId, boolean active) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.setActive(commerceCurrencyId, active);
    }

    public CommerceCurrency setPrimary(long commerceCurrencyId, boolean primary) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.setPrimary(commerceCurrencyId, primary);
    }

    public CommerceCurrency updateCommerceCurrency(long commerceCurrencyId, String code, Map<Locale, String> nameMap, String symbol, BigDecimal rate, Map<Locale, String> formatPatternMap, int maxFractionDigits, int minFractionDigits, String roundingMode, boolean primary, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        return this.commerceCurrencyLocalService.updateCommerceCurrency(commerceCurrencyId, code, nameMap, symbol, rate, formatPatternMap, maxFractionDigits, minFractionDigits, roundingMode, primary, priority, active, serviceContext);
    }

    public void updateExchangeRate(long commerceCurrencyId, String exchangeRateProviderKey) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        this.commerceCurrencyLocalService.updateExchangeRate(commerceCurrencyId, exchangeRateProviderKey);
    }

    public void updateExchangeRates() throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_COMMERCE_CURRENCIES");
        this.commerceCurrencyLocalService.updateExchangeRates();
    }
}

