/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.currency.model.impl;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceCurrencyModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceCurrency service. Represents a row in the &quot;CommerceCurrency&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceCurrencyModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceCurrencyImpl}.
 * </p>
 *
 * @author Andrea Di Giorgi
 * @see CommerceCurrencyImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceCurrencyModelImpl
	extends BaseModelImpl<CommerceCurrency> implements CommerceCurrencyModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce currency model instance should use the <code>CommerceCurrency</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceCurrency";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"commerceCurrencyId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"code_", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"symbol", Types.VARCHAR}, {"rate", Types.DECIMAL},
		{"formatPattern", Types.VARCHAR}, {"maxFractionDigits", Types.INTEGER},
		{"minFractionDigits", Types.INTEGER}, {"roundingMode", Types.VARCHAR},
		{"primary_", Types.BOOLEAN}, {"priority", Types.DOUBLE},
		{"active_", Types.BOOLEAN}, {"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("code_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("symbol", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("rate", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("formatPattern", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("maxFractionDigits", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minFractionDigits", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("roundingMode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("primary_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceCurrency (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,commerceCurrencyId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,code_ VARCHAR(75) null,name STRING null,symbol VARCHAR(75) null,rate DECIMAL(30, 16) null,formatPattern STRING null,maxFractionDigits INTEGER,minFractionDigits INTEGER,roundingMode VARCHAR(75) null,primary_ BOOLEAN,priority DOUBLE,active_ BOOLEAN,lastPublishDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceCurrency";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceCurrency.priority ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceCurrency.priority ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIMARY_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 32L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.currency.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.currency.model.CommerceCurrency"));

	public CommerceCurrencyModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceCurrencyId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceCurrencyId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceCurrencyId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceCurrency.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceCurrency.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceCurrency, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceCurrency, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceCurrency, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceCurrency)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceCurrency, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceCurrency, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceCurrency)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceCurrency, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceCurrency, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceCurrency, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceCurrency, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceCurrency, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<CommerceCurrency, Object>>();
		Map<String, BiConsumer<CommerceCurrency, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceCurrency, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceCurrency::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceCurrency, Long>)
				CommerceCurrency::setMvccVersion);
		attributeGetterFunctions.put("uuid", CommerceCurrency::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceCurrency, String>)CommerceCurrency::setUuid);
		attributeGetterFunctions.put(
			"commerceCurrencyId", CommerceCurrency::getCommerceCurrencyId);
		attributeSetterBiConsumers.put(
			"commerceCurrencyId",
			(BiConsumer<CommerceCurrency, Long>)
				CommerceCurrency::setCommerceCurrencyId);
		attributeGetterFunctions.put(
			"companyId", CommerceCurrency::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceCurrency, Long>)CommerceCurrency::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceCurrency::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceCurrency, Long>)CommerceCurrency::setUserId);
		attributeGetterFunctions.put("userName", CommerceCurrency::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceCurrency, String>)
				CommerceCurrency::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceCurrency::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceCurrency, Date>)
				CommerceCurrency::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceCurrency::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceCurrency, Date>)
				CommerceCurrency::setModifiedDate);
		attributeGetterFunctions.put("code", CommerceCurrency::getCode);
		attributeSetterBiConsumers.put(
			"code",
			(BiConsumer<CommerceCurrency, String>)CommerceCurrency::setCode);
		attributeGetterFunctions.put("name", CommerceCurrency::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceCurrency, String>)CommerceCurrency::setName);
		attributeGetterFunctions.put("symbol", CommerceCurrency::getSymbol);
		attributeSetterBiConsumers.put(
			"symbol",
			(BiConsumer<CommerceCurrency, String>)CommerceCurrency::setSymbol);
		attributeGetterFunctions.put("rate", CommerceCurrency::getRate);
		attributeSetterBiConsumers.put(
			"rate",
			(BiConsumer<CommerceCurrency, BigDecimal>)
				CommerceCurrency::setRate);
		attributeGetterFunctions.put(
			"formatPattern", CommerceCurrency::getFormatPattern);
		attributeSetterBiConsumers.put(
			"formatPattern",
			(BiConsumer<CommerceCurrency, String>)
				CommerceCurrency::setFormatPattern);
		attributeGetterFunctions.put(
			"maxFractionDigits", CommerceCurrency::getMaxFractionDigits);
		attributeSetterBiConsumers.put(
			"maxFractionDigits",
			(BiConsumer<CommerceCurrency, Integer>)
				CommerceCurrency::setMaxFractionDigits);
		attributeGetterFunctions.put(
			"minFractionDigits", CommerceCurrency::getMinFractionDigits);
		attributeSetterBiConsumers.put(
			"minFractionDigits",
			(BiConsumer<CommerceCurrency, Integer>)
				CommerceCurrency::setMinFractionDigits);
		attributeGetterFunctions.put(
			"roundingMode", CommerceCurrency::getRoundingMode);
		attributeSetterBiConsumers.put(
			"roundingMode",
			(BiConsumer<CommerceCurrency, String>)
				CommerceCurrency::setRoundingMode);
		attributeGetterFunctions.put("primary", CommerceCurrency::getPrimary);
		attributeSetterBiConsumers.put(
			"primary",
			(BiConsumer<CommerceCurrency, Boolean>)
				CommerceCurrency::setPrimary);
		attributeGetterFunctions.put("priority", CommerceCurrency::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<CommerceCurrency, Double>)
				CommerceCurrency::setPriority);
		attributeGetterFunctions.put("active", CommerceCurrency::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommerceCurrency, Boolean>)CommerceCurrency::setActive);
		attributeGetterFunctions.put(
			"lastPublishDate", CommerceCurrency::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommerceCurrency, Date>)
				CommerceCurrency::setLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceCurrencyId = commerceCurrencyId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getCode() {
		if (_code == null) {
			return "";
		}
		else {
			return _code;
		}
	}

	@Override
	public void setCode(String code) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_code = code;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCode() {
		return getColumnOriginalValue("code_");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSymbol() {
		if (_symbol == null) {
			return "";
		}
		else {
			return _symbol;
		}
	}

	@Override
	public void setSymbol(String symbol) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_symbol = symbol;
	}

	@JSON
	@Override
	public BigDecimal getRate() {
		return _rate;
	}

	@Override
	public void setRate(BigDecimal rate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rate = rate;
	}

	@JSON
	@Override
	public String getFormatPattern() {
		if (_formatPattern == null) {
			return "";
		}
		else {
			return _formatPattern;
		}
	}

	@Override
	public String getFormatPattern(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFormatPattern(languageId);
	}

	@Override
	public String getFormatPattern(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFormatPattern(languageId, useDefault);
	}

	@Override
	public String getFormatPattern(String languageId) {
		return LocalizationUtil.getLocalization(getFormatPattern(), languageId);
	}

	@Override
	public String getFormatPattern(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getFormatPattern(), languageId, useDefault);
	}

	@Override
	public String getFormatPatternCurrentLanguageId() {
		return _formatPatternCurrentLanguageId;
	}

	@JSON
	@Override
	public String getFormatPatternCurrentValue() {
		Locale locale = getLocale(_formatPatternCurrentLanguageId);

		return getFormatPattern(locale);
	}

	@Override
	public Map<Locale, String> getFormatPatternMap() {
		return LocalizationUtil.getLocalizationMap(getFormatPattern());
	}

	@Override
	public void setFormatPattern(String formatPattern) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_formatPattern = formatPattern;
	}

	@Override
	public void setFormatPattern(String formatPattern, Locale locale) {
		setFormatPattern(formatPattern, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setFormatPattern(
		String formatPattern, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(formatPattern)) {
			setFormatPattern(
				LocalizationUtil.updateLocalization(
					getFormatPattern(), "FormatPattern", formatPattern,
					languageId, defaultLanguageId));
		}
		else {
			setFormatPattern(
				LocalizationUtil.removeLocalization(
					getFormatPattern(), "FormatPattern", languageId));
		}
	}

	@Override
	public void setFormatPatternCurrentLanguageId(String languageId) {
		_formatPatternCurrentLanguageId = languageId;
	}

	@Override
	public void setFormatPatternMap(Map<Locale, String> formatPatternMap) {
		setFormatPatternMap(formatPatternMap, LocaleUtil.getDefault());
	}

	@Override
	public void setFormatPatternMap(
		Map<Locale, String> formatPatternMap, Locale defaultLocale) {

		if (formatPatternMap == null) {
			return;
		}

		setFormatPattern(
			LocalizationUtil.updateLocalization(
				formatPatternMap, getFormatPattern(), "FormatPattern",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public int getMaxFractionDigits() {
		return _maxFractionDigits;
	}

	@Override
	public void setMaxFractionDigits(int maxFractionDigits) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maxFractionDigits = maxFractionDigits;
	}

	@JSON
	@Override
	public int getMinFractionDigits() {
		return _minFractionDigits;
	}

	@Override
	public void setMinFractionDigits(int minFractionDigits) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minFractionDigits = minFractionDigits;
	}

	@JSON
	@Override
	public String getRoundingMode() {
		if (_roundingMode == null) {
			return "";
		}
		else {
			return _roundingMode;
		}
	}

	@Override
	public void setRoundingMode(String roundingMode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_roundingMode = roundingMode;
	}

	@JSON
	@Override
	public boolean getPrimary() {
		return _primary;
	}

	@JSON
	@Override
	public boolean isPrimary() {
		return _primary;
	}

	@Override
	public void setPrimary(boolean primary) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_primary = primary;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalPrimary() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("primary_"));
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceCurrency.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceCurrency.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> formatPatternMap = getFormatPatternMap();

		for (Map.Entry<Locale, String> entry : formatPatternMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			CommerceCurrency.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String formatPattern = getFormatPattern(defaultLocale);

		if (Validator.isNull(formatPattern)) {
			setFormatPattern(
				getFormatPattern(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setFormatPattern(
				getFormatPattern(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceCurrency toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceCurrency>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceCurrencyImpl commerceCurrencyImpl = new CommerceCurrencyImpl();

		commerceCurrencyImpl.setMvccVersion(getMvccVersion());
		commerceCurrencyImpl.setUuid(getUuid());
		commerceCurrencyImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commerceCurrencyImpl.setCompanyId(getCompanyId());
		commerceCurrencyImpl.setUserId(getUserId());
		commerceCurrencyImpl.setUserName(getUserName());
		commerceCurrencyImpl.setCreateDate(getCreateDate());
		commerceCurrencyImpl.setModifiedDate(getModifiedDate());
		commerceCurrencyImpl.setCode(getCode());
		commerceCurrencyImpl.setName(getName());
		commerceCurrencyImpl.setSymbol(getSymbol());
		commerceCurrencyImpl.setRate(getRate());
		commerceCurrencyImpl.setFormatPattern(getFormatPattern());
		commerceCurrencyImpl.setMaxFractionDigits(getMaxFractionDigits());
		commerceCurrencyImpl.setMinFractionDigits(getMinFractionDigits());
		commerceCurrencyImpl.setRoundingMode(getRoundingMode());
		commerceCurrencyImpl.setPrimary(isPrimary());
		commerceCurrencyImpl.setPriority(getPriority());
		commerceCurrencyImpl.setActive(isActive());
		commerceCurrencyImpl.setLastPublishDate(getLastPublishDate());

		commerceCurrencyImpl.resetOriginalValues();

		return commerceCurrencyImpl;
	}

	@Override
	public CommerceCurrency cloneWithOriginalValues() {
		CommerceCurrencyImpl commerceCurrencyImpl = new CommerceCurrencyImpl();

		commerceCurrencyImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceCurrencyImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceCurrencyImpl.setCommerceCurrencyId(
			this.<Long>getColumnOriginalValue("commerceCurrencyId"));
		commerceCurrencyImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceCurrencyImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceCurrencyImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceCurrencyImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceCurrencyImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceCurrencyImpl.setCode(
			this.<String>getColumnOriginalValue("code_"));
		commerceCurrencyImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		commerceCurrencyImpl.setSymbol(
			this.<String>getColumnOriginalValue("symbol"));
		commerceCurrencyImpl.setRate(
			this.<BigDecimal>getColumnOriginalValue("rate"));
		commerceCurrencyImpl.setFormatPattern(
			this.<String>getColumnOriginalValue("formatPattern"));
		commerceCurrencyImpl.setMaxFractionDigits(
			this.<Integer>getColumnOriginalValue("maxFractionDigits"));
		commerceCurrencyImpl.setMinFractionDigits(
			this.<Integer>getColumnOriginalValue("minFractionDigits"));
		commerceCurrencyImpl.setRoundingMode(
			this.<String>getColumnOriginalValue("roundingMode"));
		commerceCurrencyImpl.setPrimary(
			this.<Boolean>getColumnOriginalValue("primary_"));
		commerceCurrencyImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		commerceCurrencyImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		commerceCurrencyImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return commerceCurrencyImpl;
	}

	@Override
	public int compareTo(CommerceCurrency commerceCurrency) {
		int value = 0;

		if (getPriority() < commerceCurrency.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commerceCurrency.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceCurrency)) {
			return false;
		}

		CommerceCurrency commerceCurrency = (CommerceCurrency)object;

		long primaryKey = commerceCurrency.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceCurrency> toCacheModel() {
		CommerceCurrencyCacheModel commerceCurrencyCacheModel =
			new CommerceCurrencyCacheModel();

		commerceCurrencyCacheModel.mvccVersion = getMvccVersion();

		commerceCurrencyCacheModel.uuid = getUuid();

		String uuid = commerceCurrencyCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceCurrencyCacheModel.uuid = null;
		}

		commerceCurrencyCacheModel.commerceCurrencyId = getCommerceCurrencyId();

		commerceCurrencyCacheModel.companyId = getCompanyId();

		commerceCurrencyCacheModel.userId = getUserId();

		commerceCurrencyCacheModel.userName = getUserName();

		String userName = commerceCurrencyCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceCurrencyCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceCurrencyCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceCurrencyCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceCurrencyCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceCurrencyCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceCurrencyCacheModel.code = getCode();

		String code = commerceCurrencyCacheModel.code;

		if ((code != null) && (code.length() == 0)) {
			commerceCurrencyCacheModel.code = null;
		}

		commerceCurrencyCacheModel.name = getName();

		String name = commerceCurrencyCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceCurrencyCacheModel.name = null;
		}

		commerceCurrencyCacheModel.symbol = getSymbol();

		String symbol = commerceCurrencyCacheModel.symbol;

		if ((symbol != null) && (symbol.length() == 0)) {
			commerceCurrencyCacheModel.symbol = null;
		}

		commerceCurrencyCacheModel.rate = getRate();

		commerceCurrencyCacheModel.formatPattern = getFormatPattern();

		String formatPattern = commerceCurrencyCacheModel.formatPattern;

		if ((formatPattern != null) && (formatPattern.length() == 0)) {
			commerceCurrencyCacheModel.formatPattern = null;
		}

		commerceCurrencyCacheModel.maxFractionDigits = getMaxFractionDigits();

		commerceCurrencyCacheModel.minFractionDigits = getMinFractionDigits();

		commerceCurrencyCacheModel.roundingMode = getRoundingMode();

		String roundingMode = commerceCurrencyCacheModel.roundingMode;

		if ((roundingMode != null) && (roundingMode.length() == 0)) {
			commerceCurrencyCacheModel.roundingMode = null;
		}

		commerceCurrencyCacheModel.primary = isPrimary();

		commerceCurrencyCacheModel.priority = getPriority();

		commerceCurrencyCacheModel.active = isActive();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commerceCurrencyCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commerceCurrencyCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return commerceCurrencyCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceCurrency, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceCurrency, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceCurrency, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceCurrency)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceCurrency, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceCurrency, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceCurrency, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceCurrency)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceCurrency>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceCurrency.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _commerceCurrencyId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _code;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _symbol;
	private BigDecimal _rate;
	private String _formatPattern;
	private String _formatPatternCurrentLanguageId;
	private int _maxFractionDigits;
	private int _minFractionDigits;
	private String _roundingMode;
	private boolean _primary;
	private double _priority;
	private boolean _active;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceCurrency, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceCurrency)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("commerceCurrencyId", _commerceCurrencyId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("code_", _code);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("symbol", _symbol);
		_columnOriginalValues.put("rate", _rate);
		_columnOriginalValues.put("formatPattern", _formatPattern);
		_columnOriginalValues.put("maxFractionDigits", _maxFractionDigits);
		_columnOriginalValues.put("minFractionDigits", _minFractionDigits);
		_columnOriginalValues.put("roundingMode", _roundingMode);
		_columnOriginalValues.put("primary_", _primary);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("code_", "code");
		attributeNames.put("primary_", "primary");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("commerceCurrencyId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("code_", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("symbol", 1024L);

		columnBitmasks.put("rate", 2048L);

		columnBitmasks.put("formatPattern", 4096L);

		columnBitmasks.put("maxFractionDigits", 8192L);

		columnBitmasks.put("minFractionDigits", 16384L);

		columnBitmasks.put("roundingMode", 32768L);

		columnBitmasks.put("primary_", 65536L);

		columnBitmasks.put("priority", 131072L);

		columnBitmasks.put("active_", 262144L);

		columnBitmasks.put("lastPublishDate", 524288L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceCurrency _escapedModel;

}